/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom.dynamax;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.item.abstracts.MSDPokemonSelectingItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamaxCandy
extends MSDPokemonSelectingItem {
    public DynamaxCandy(Item.Properties arg) {
        super(arg);
    }

    private void particleEffect(PokemonEntity context, SimpleParticleType particleType) {
        if (context == null) {
            return;
        }
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double scaleFactor = 0.5;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityWidth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)particleType, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public void appendHoverText(ItemStack arg, Item.TooltipContext arg2, List<Component> tooltipComponents, TooltipFlag arg3) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.mega_showdown.dynamax_candy.tooltip"));
        super.appendHoverText(arg, arg2, tooltipComponents, arg3);
    }

    @Nullable
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack itemStack, @NotNull Pokemon pokemon) {
        if (pokemon.getEntity() != null && pokemon.getEntity().isBattling()) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (pokemon.getOwnerPlayer() == player && pokemon.getDmaxLevel() < 10) {
            pokemon.setDmaxLevel(pokemon.getDmaxLevel() + 1);
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.dmax_level_up", (Object[])new Object[]{pokemon.getDisplayName(), pokemon.getDmaxLevel()}).withStyle(ChatFormatting.GREEN), true);
            if (pokemon.getDmaxLevel() == 10) {
                AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "dynamax/dynamax_candy_max");
            }
            if (pokemon.getSpecies().getName().equals("Calyrex")) {
                this.particleEffect(pokemon.getEntity(), ParticleTypes.SOUL_FIRE_FLAME);
            } else {
                this.particleEffect(pokemon.getEntity(), ParticleTypes.FLAME);
            }
            itemStack.consume(1, (LivingEntity)player);
            return InteractionResultHolder.success((Object)itemStack);
        }
        if (pokemon.getDmaxLevel() >= Cobblemon.config.getMaxDynamaxLevel() && pokemon.getOwnerPlayer() == player) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.dmax_level_cap").withStyle(ChatFormatting.RED), true);
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    public boolean canUseOnPokemon(@NotNull Pokemon pokemon) {
        return pokemon.getDmaxLevel() < Cobblemon.config.getMaxDynamaxLevel() && !pokemon.getSpecies().getDynamaxBlocked();
    }
}

