/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom.tera;

import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TeraShard
extends Item {
    private final TeraType teraType;

    public TeraShard(Item.Properties arg, TeraType teraType) {
        super(arg);
        this.teraType = teraType;
    }

    public InteractionResult interactLivingEntity(ItemStack arg, Player player, @NotNull LivingEntity context, InteractionHand hand) {
        if (player.level().isClientSide || player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (context instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)context;
            Pokemon pokemon = pk.getPokemon();
            if (pokemon.getEntity() == null || pokemon.getEntity().level().isClientSide || pokemon.getEntity().isBattling()) {
                return InteractionResult.PASS;
            }
            if (pokemon.getSpecies().getName().equals("Ogerpon") || pokemon.getSpecies().getName().equals("Terapagos")) {
                return InteractionResult.PASS;
            }
            int required_shards = MegaShowdownConfig.teraShardRequired;
            if (pokemon.getOwnerPlayer() == player && arg.getCount() == required_shards) {
                if (pokemon.getTeraType() == this.teraType) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.same_tera").withColor(0xFF0000), true);
                    return InteractionResult.PASS;
                }
                arg.shrink(required_shards);
                if (this.teraType != TeraMoves.STELLAR_TERA_SHARD.get()) {
                    this.particleEffect((LivingEntity)pokemon.getEntity());
                    pokemon.setTeraType(this.teraType);
                    AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "tera/change_tera");
                } else {
                    this.particleEffect((LivingEntity)pokemon.getEntity());
                    pokemon.setTeraType(this.teraType);
                    AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "tera/change_tera");
                    AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "tera/change_tera_stellar");
                }
            } else if (pokemon.getOwnerPlayer() == player && arg.getCount() != required_shards) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.tera_requirements", (Object[])new Object[]{required_shards}).withColor(0xFF0000), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void particleEffect(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.GLOW, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

