/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.procedures;

import javax.annotation.Nullable;
import net.mcreator.createstuffadditions.init.CreateSaModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class SlimeHelmetElytraCancelProcedure {
    @SubscribeEvent
    public static void onEntityAttacked(LivingIncomingDamageEvent event) {
        if (event.getEntity() != null) {
            SlimeHelmetElytraCancelProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), event.getSource(), (Entity)event.getEntity(), event.getAmount());
        }
    }

    public static void execute(LevelAccessor world, DamageSource damagesource, Entity entity, double amount) {
        SlimeHelmetElytraCancelProcedure.execute(null, world, damagesource, entity, amount);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, DamageSource damagesource, Entity entity, double amount) {
        ItemStack itemStack;
        if (damagesource == null || entity == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity _entGetArmor = (LivingEntity)entity;
            itemStack = _entGetArmor.getItemBySlot(EquipmentSlot.HEAD);
        } else {
            itemStack = ItemStack.EMPTY;
        }
        if (itemStack.getItem() == CreateSaModItems.SLIME_HELMET.get() && damagesource.is(DamageTypes.FLY_INTO_WALL) && amount > 0.5) {
            Level _level;
            if (event instanceof ICancellableEvent) {
                ICancellableEvent _cancellable = (ICancellableEvent)event;
                _cancellable.setCanceled(true);
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.slime.jump")), SoundSource.NEUTRAL, 1.0f, 4.0f);
                } else {
                    _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.slime.jump")), SoundSource.NEUTRAL, 1.0f, 4.0f, false);
                }
            }
            entity.hurt(new DamageSource(world.holderOrThrow(DamageTypes.FLY_INTO_WALL)), 0.2f);
            entity.setDeltaMovement(new Vec3(entity.getLookAngle().x * -0.2 * amount, entity.getLookAngle().y * -0.2 * amount, entity.getLookAngle().z * -0.2 * amount));
            if (world instanceof ServerLevel) {
                ItemStack itemStack2;
                _level = (ServerLevel)world;
                if (entity instanceof LivingEntity) {
                    LivingEntity _entGetArmor = (LivingEntity)entity;
                    itemStack2 = _entGetArmor.getItemBySlot(EquipmentSlot.HEAD);
                } else {
                    itemStack2 = ItemStack.EMPTY;
                }
                itemStack2.hurtAndBreak(1, (ServerLevel)_level, null, _stkprov -> {});
            }
        }
    }
}

