/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;

public class ModelBlockDefinition {
    private static final String DIRECTORY = "dev/block_definitions";
    public static final Hashtable<ResourceLocation, ModelBlockDefinition> DEFINITIONS = new Hashtable();
    private static final Hashtable<Block, DungeonModelBlockType> DEFAULT = new Hashtable();
    private static final ModelBlockDefinition DEFAULT_DEFINITION;
    private static final ResourceLocation DEFAULT_LOCATION;
    public ModelBlockDefinition fallback;
    private final Hashtable<Block, DungeonModelBlockType> definition;
    private final Hashtable<DungeonModelBlockType, Block> invertedDefinition;
    private static ImmutableSet<ResourceLocation> KEYS;
    private static ImmutableSet.Builder<ResourceLocation> keySetBuilder;

    public ModelBlockDefinition(Hashtable<Block, DungeonModelBlockType> definition) {
        this.definition = definition;
        this.invertedDefinition = new Hashtable();
        this.definition.forEach((block, type) -> this.invertedDefinition.put((DungeonModelBlockType)((Object)type), (Block)block));
    }

    public boolean containsBlock(Block block) {
        return this.definition.containsKey(block);
    }

    public DungeonModelBlockType getType(Block block) {
        return this.definition.getOrDefault(block, DungeonModelBlockType.OTHER);
    }

    public Block getBlock(DungeonModelBlock block) {
        if (block.type == DungeonModelBlockType.OTHER) {
            return (Block)BuiltInRegistries.BLOCK.get(block.blockName);
        }
        if (block.type == DungeonModelBlockType.CARPET) {
            if (block.block != null) {
                return block.block;
            }
            return Blocks.WHITE_CARPET;
        }
        if (this.invertedDefinition.containsKey((Object)block.type)) {
            return this.invertedDefinition.get((Object)block.type);
        }
        if (this.fallback != null && this.fallback.invertedDefinition.containsKey((Object)block.type)) {
            return this.fallback.invertedDefinition.get((Object)block.type);
        }
        return Blocks.AIR;
    }

    public static void loadJson(ResourceManager resourceManager) {
        keySetBuilder = new ImmutableSet.Builder();
        ArrayList referencesToUpdate = Lists.newArrayList();
        resourceManager.listResources(DIRECTORY, s -> s.getPath().endsWith(".json")).forEach((file, resource) -> ModelBlockDefinition.loadDefinition(resourceManager, file, referencesToUpdate));
        for (Tuple reference : referencesToUpdate) {
            ResourceLocation key = (ResourceLocation)reference.getB();
            if (DEFINITIONS.containsKey(key)) {
                ((ModelBlockDefinition)reference.getA()).fallback = DEFINITIONS.get(key);
                continue;
            }
            DungeonCrawl.LOGGER.warn("Unknown fallback model block definition: {}", (Object)key);
        }
        KEYS = keySetBuilder.build();
    }

    private static void loadDefinition(ResourceManager resourceManager, ResourceLocation resourceLocation, List<Tuple<ModelBlockDefinition, ResourceLocation>> referencesToUpdate) {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)resourceLocation);
        Hashtable<Block, DungeonModelBlockType> definition = new Hashtable<Block, DungeonModelBlockType>();
        Resource resource = (Resource)resourceManager.getResource(resourceLocation).orElseThrow();
        try {
            JsonObject object = JsonParser.parseReader((Reader)new InputStreamReader(resource.open())).getAsJsonObject();
            object.getAsJsonObject("definition").entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)key));
                if (block != null) {
                    String value = ((JsonElement)entry.getValue()).getAsString().toUpperCase();
                    if (DungeonModelBlockType.NAME_TO_TYPE.containsKey((Object)value)) {
                        definition.put(block, (DungeonModelBlockType)((Object)((Object)DungeonModelBlockType.NAME_TO_TYPE.get((Object)value))));
                    } else {
                        DungeonCrawl.LOGGER.warn("Unknown model block type: {}", (Object)value);
                    }
                } else {
                    DungeonCrawl.LOGGER.warn("Unknown block: {}", (Object)key);
                }
            });
            ModelBlockDefinition blockDefinition = new ModelBlockDefinition(definition);
            if (object.has("fallback")) {
                referencesToUpdate.add((Tuple<ModelBlockDefinition, ResourceLocation>)new Tuple((Object)blockDefinition, (Object)ResourceLocation.parse((String)object.get("fallback").getAsString())));
            }
            ResourceLocation key = DungeonCrawl.key(resourceLocation, DIRECTORY, ".json");
            DEFINITIONS.put(key, blockDefinition);
            keySetBuilder.add((Object)key);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ModelBlockDefinition getDefaultDefinition() {
        return DEFINITIONS.getOrDefault(DEFAULT_LOCATION, DEFAULT_DEFINITION);
    }

    public static ImmutableSet<ResourceLocation> getKeys() {
        return KEYS;
    }

    static {
        DEFAULT_LOCATION = DungeonCrawl.locate("default");
        DEFAULT.put(Blocks.AIR, DungeonModelBlockType.AIR);
        DEFAULT.put(Blocks.CAVE_AIR, DungeonModelBlockType.AIR);
        DEFAULT.put(Blocks.CHEST, DungeonModelBlockType.CHEST);
        DEFAULT.put(Blocks.STONE_BRICK_STAIRS, DungeonModelBlockType.SOLID_STAIRS);
        DEFAULT.put(Blocks.COBBLESTONE, DungeonModelBlockType.GENERIC);
        DEFAULT.put(Blocks.STONE_BRICKS, DungeonModelBlockType.SOLID);
        DEFAULT.put(Blocks.STONE_BRICK_WALL, DungeonModelBlockType.WALL);
        DEFAULT.put(Blocks.PURPUR_PILLAR, DungeonModelBlockType.SOLID_PILLAR);
        DEFAULT.put(Blocks.IRON_BARS, DungeonModelBlockType.FENCING);
        DEFAULT.put(Blocks.WATER, DungeonModelBlockType.FLUID);
        DEFAULT.put(Blocks.OAK_LOG, DungeonModelBlockType.PILLAR);
        DEFAULT.put(Blocks.OAK_PLANKS, DungeonModelBlockType.MATERIAL);
        DEFAULT.put(Blocks.OAK_DOOR, DungeonModelBlockType.DOOR);
        DEFAULT.put(Blocks.OAK_STAIRS, DungeonModelBlockType.MATERIAL_STAIRS);
        DEFAULT.put(Blocks.OAK_SLAB, DungeonModelBlockType.MATERIAL_SLAB);
        DEFAULT.put(Blocks.OAK_BUTTON, DungeonModelBlockType.MATERIAL_BUTTON);
        DEFAULT.put(Blocks.OAK_FENCE, DungeonModelBlockType.FENCE);
        DEFAULT.put(Blocks.OAK_FENCE_GATE, DungeonModelBlockType.FENCE_GATE);
        DEFAULT.put(Blocks.OAK_PRESSURE_PLATE, DungeonModelBlockType.MATERIAL_PRESSURE_PLATE);
        DEFAULT.put(Blocks.OAK_TRAPDOOR, DungeonModelBlockType.TRAPDOOR);
        DEFAULT.put(Blocks.GRAVEL, DungeonModelBlockType.FLOOR);
        DEFAULT.put(Blocks.CRACKED_STONE_BRICKS, DungeonModelBlockType.SOLID_FLOOR);
        DEFAULT.put(Blocks.COBBLESTONE_STAIRS, DungeonModelBlockType.STAIRS);
        DEFAULT.put(Blocks.COBBLESTONE_SLAB, DungeonModelBlockType.SLAB);
        DEFAULT.put(Blocks.SKELETON_SKULL, DungeonModelBlockType.SKULL);
        DEFAULT_DEFINITION = new ModelBlockDefinition(DEFAULT);
        DEFINITIONS.put(DungeonCrawl.locate("builtin/default"), DEFAULT_DEFINITION);
    }
}

