/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.util.Range;

public class SpawnRates {
    private static Range[] DELAY;
    private static Range[] AMOUNT;

    public static Range getAmount(int level) {
        if (level < 0) {
            return AMOUNT[0];
        }
        if (level > 4) {
            return AMOUNT[4];
        }
        return AMOUNT[level];
    }

    public static Range getDelay(int level) {
        if (level < 0) {
            return DELAY[0];
        }
        if (level > 4) {
            return DELAY[4];
        }
        return DELAY[level];
    }

    public static void loadJson(ResourceManager resourceManager) {
        DELAY = new Range[5];
        AMOUNT = new Range[5];
        ResourceLocation file = DungeonCrawl.locate("monster/spawn_rates.json");
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)file.toString());
        Resource resource = (Resource)resourceManager.getResource(file).orElseThrow(() -> new DatapackLoadException("Missing file: " + String.valueOf(file)));
        try {
            JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(resource.open())).getAsJsonObject();
            SpawnRates.loadLevel(data, file, 0);
            SpawnRates.loadLevel(data, file, 1);
            SpawnRates.loadLevel(data, file, 2);
            SpawnRates.loadLevel(data, file, 3);
            SpawnRates.loadLevel(data, file, 4);
        }
        catch (IOException e) {
            DungeonCrawl.LOGGER.error("An error occurred whilst trying to load {}", (Object)resource.toString());
            e.printStackTrace();
        }
    }

    private static void loadLevel(JsonObject object, ResourceLocation resource, int level) {
        String entry = "level_" + (level + 1);
        if (!object.has(entry)) {
            throw new DatapackLoadException("Missing entry " + entry + " in " + String.valueOf(resource));
        }
        JsonObject data = object.getAsJsonObject(entry);
        JsonObject delay = data.getAsJsonObject("delay");
        JsonObject amount = data.getAsJsonObject("amount");
        SpawnRates.DELAY[level] = new Range(delay.get("min").getAsInt(), delay.get("max").getAsInt());
        SpawnRates.AMOUNT[level] = new Range(amount.get("min").getAsInt(), amount.get("max").getAsInt());
    }
}

