/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import com.google.common.collect.ImmutableSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.neoforged.neoforge.registries.DeferredHolder;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.treasure.function.EnchantedBook;
import xiroc.dungeoncrawl.dungeon.treasure.function.MaterialBlocks;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomItem;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomPotion;
import xiroc.dungeoncrawl.dungeon.treasure.function.Shield;
import xiroc.dungeoncrawl.dungeon.treasure.function.SuspiciousStew;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;

public interface Loot {
    public static final DeferredHolder<LootItemFunctionType<?>, ?> ENCHANTED_BOOK = DungeonCrawl.LOOT_FUNCTION_TYPE.register("enchanted_book", () -> new LootItemFunctionType(EnchantedBook.CODEC));
    public static final DeferredHolder<LootItemFunctionType<?>, ?> MATERIAL_BLOCKS = DungeonCrawl.LOOT_FUNCTION_TYPE.register("material_blocks", () -> new LootItemFunctionType(MaterialBlocks.CODEC));
    public static final DeferredHolder<LootItemFunctionType<?>, ?> RANDOM_ITEM = DungeonCrawl.LOOT_FUNCTION_TYPE.register("random_item", () -> new LootItemFunctionType(RandomItem.CODEC));
    public static final DeferredHolder<LootItemFunctionType<?>, ?> RANDOM_POTION = DungeonCrawl.LOOT_FUNCTION_TYPE.register("random_potion", () -> new LootItemFunctionType(RandomPotion.CODEC));
    public static final DeferredHolder<LootItemFunctionType<?>, ?> SHIELD = DungeonCrawl.LOOT_FUNCTION_TYPE.register("shield", () -> new LootItemFunctionType(Shield.CODEC));
    public static final DeferredHolder<LootItemFunctionType<?>, ?> SUSPICIOUS_STEW = DungeonCrawl.LOOT_FUNCTION_TYPE.register("suspicious_stew", () -> new LootItemFunctionType(SuspiciousStew.CODEC));
    public static final String KEY_LOOT_LEVEL = "loot_level";
    public static final ResourceKey<LootTable> CHEST_FOOD = Loot.lootTable("chests/food");
    public static final ResourceKey<LootTable> CHEST_SECRET_ROOM = Loot.lootTable("chests/secret_room");
    public static final ResourceKey<LootTable> CHEST_SUPPLY = Loot.lootTable("chests/supply");
    public static final ResourceKey<LootTable> CHEST_TREASURE = Loot.lootTable("chests/treasure");
    public static final ResourceKey<LootTable> CHEST_STAGE_1 = Loot.lootTable("chests/stage_1");
    public static final ResourceKey<LootTable> CHEST_STAGE_2 = Loot.lootTable("chests/stage_2");
    public static final ResourceKey<LootTable> CHEST_STAGE_3 = Loot.lootTable("chests/stage_3");
    public static final ResourceKey<LootTable> CHEST_STAGE_4 = Loot.lootTable("chests/stage_4");
    public static final ResourceKey<LootTable> CHEST_STAGE_5 = Loot.lootTable("chests/stage_5");
    public static final ResourceKey<LootTable> WITHER_SKELETON = Loot.lootTable("monster_overrides/wither_skeleton");
    public static final ImmutableSet<ResourceKey<LootTable>> ALL_LOOT_TABLES = ImmutableSet.builder().add(CHEST_FOOD).add(CHEST_SECRET_ROOM).add(CHEST_SUPPLY).add(CHEST_TREASURE).add(CHEST_STAGE_1).add(CHEST_STAGE_2).add(CHEST_STAGE_3).add(CHEST_STAGE_4).add(CHEST_STAGE_5).build();

    private static ResourceKey<LootTable> lootTable(String path) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)DungeonCrawl.locate(path));
    }

    public static void init() {
    }

    public static void setLoot(LevelAccessor world, BlockPos pos, RandomizableContainerBlockEntity tile, ResourceKey<LootTable> lootTable, Theme theme, SecondaryTheme secondaryTheme, RandomSource rand) {
        RandomizableContainer.setBlockEntityLootTable((BlockGetter)world, (RandomSource)rand, (BlockPos)pos, lootTable);
        Loot.setLootInformation(tile.getPersistentData(), theme, secondaryTheme);
    }

    public static ResourceKey<LootTable> getLootTable(int lootLevel, RandomSource rand) {
        return switch (lootLevel) {
            case 0 -> {
                if ((double)rand.nextFloat() < 0.1) {
                    yield BuiltInLootTables.JUNGLE_TEMPLE;
                }
                yield CHEST_STAGE_1;
            }
            case 1 -> {
                if ((double)rand.nextFloat() < 0.1) {
                    yield BuiltInLootTables.SIMPLE_DUNGEON;
                }
                yield CHEST_STAGE_2;
            }
            case 2 -> {
                if ((double)rand.nextFloat() < 0.1) {
                    yield BuiltInLootTables.SIMPLE_DUNGEON;
                }
                yield CHEST_STAGE_3;
            }
            case 3 -> {
                if ((double)rand.nextFloat() < 0.1) {
                    yield BuiltInLootTables.STRONGHOLD_CROSSING;
                }
                yield CHEST_STAGE_4;
            }
            case 4 -> {
                if ((double)rand.nextFloat() < 0.1) {
                    yield BuiltInLootTables.STRONGHOLD_CROSSING;
                }
                yield CHEST_STAGE_5;
            }
            default -> CHEST_STAGE_5;
        };
    }

    public static void setLootInformation(CompoundTag nbt, Theme theme, SecondaryTheme secondaryTheme) {
        CompoundTag data = new CompoundTag();
        data.putString("theme", theme.getKey().toString());
        data.putString("secondaryTheme", secondaryTheme.getKey().toString());
        nbt.put("dungeoncrawl", (Tag)data);
    }

    public static Tuple<Theme, SecondaryTheme> getLootInformation(CompoundTag nbt) {
        CompoundTag data = nbt.getCompound("dungeoncrawl");
        return new Tuple((Object)Theme.getTheme(ResourceLocation.parse((String)data.getString("theme"))), (Object)Theme.getSecondaryTheme(ResourceLocation.parse((String)data.getString("secondaryTheme"))));
    }
}

