/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure.function;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.Range;

public class MaterialBlocks
extends LootItemConditionalFunction {
    public static final MapCodec<MaterialBlocks> CODEC = RecordCodecBuilder.mapCodec(builder -> MaterialBlocks.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, MaterialBlocks::new));
    private static final Range AMOUNT = new Range(16, 64);

    public MaterialBlocks(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        if (context.hasParam(LootContextParams.ORIGIN)) {
            Vec3 origin = (Vec3)context.getParam(LootContextParams.ORIGIN);
            BlockPos chestPosition = new BlockPos((int)(origin.x - 0.5), (int)(origin.y - 0.5), (int)(origin.z - 0.5));
            BlockEntity chest = context.getLevel().getBlockEntity(chestPosition);
            if (chest != null && chest.getPersistentData().contains("dungeoncrawl", 10)) {
                Tuple<Theme, SecondaryTheme> themes = Loot.getLootInformation(chest.getPersistentData());
                return new ItemStack((ItemLike)MaterialBlocks.getMaterial((Theme)themes.getA(), (SecondaryTheme)themes.getB(), (LevelAccessor)context.getLevel(), chestPosition, context.getRandom()), AMOUNT.nextInt(context.getRandom()));
            }
        }
        return new ItemStack((ItemLike)Blocks.STONE_BRICKS, AMOUNT.nextInt(context.getRandom()));
    }

    private static Block getMaterial(Theme theme, SecondaryTheme secondaryTheme, LevelAccessor world, BlockPos pos, RandomSource rand) {
        if (rand.nextBoolean()) {
            return theme.material.get(world, pos, rand).getBlock();
        }
        return secondaryTheme.material.get(world, pos, rand).getBlock();
    }

    public static LootItemConditionalFunction.Builder<?> materialBlocks() {
        return MaterialBlocks.simpleBuilder(MaterialBlocks::new);
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)Loot.MATERIAL_BLOCKS.get();
    }
}

