/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.appliedsoul.common.me.cell;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.definitions.AEItems;
import com.buuz135.soulplied_energistics.applied.SoulAEKeyType;
import com.buuz135.soulplied_energistics.applied.SoulKey;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.yxiao233.appliedsoul.common.item.SoulCellItem;
import net.yxiao233.appliedsoul.common.registry.SoulComponents;

public class SoulCellInventory
implements StorageCell {
    private final SoulCellItem cell;
    private final ItemStack stack;
    private final ISaveProvider container;
    private long soulAmount;
    private boolean isPersisted = true;

    public SoulCellInventory(SoulCellItem cell, ItemStack stack, ISaveProvider container) {
        this.cell = cell;
        this.stack = stack;
        this.container = container;
        this.soulAmount = (Long)stack.getOrDefault(SoulComponents.SOUL_CELL_AMOUNT, (Object)0L);
    }

    public long getTotalBytes() {
        return this.cell.getTotalBytes();
    }

    public long getUsedBytes() {
        int amountPerByte = SoulAEKeyType.TYPE.getAmountPerByte();
        return (this.soulAmount + (long)amountPerByte - 1L) / (long)amountPerByte;
    }

    public long getMaxSoul() {
        return this.cell.getTotalBytes() * (long)SoulAEKeyType.TYPE.getAmountPerByte();
    }

    public long getSoulAmount() {
        return this.soulAmount;
    }

    public CellState getStatus() {
        if (this.soulAmount == 0L) {
            return CellState.EMPTY;
        }
        if (this.soulAmount == this.getMaxSoul()) {
            return CellState.FULL;
        }
        if (this.soulAmount > this.getMaxSoul() / 2L) {
            return CellState.TYPES_FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return this.cell.getIdleDrain();
    }

    public IUpgradeInventory getUpgrades() {
        return this.cell.getUpgrades(this.stack);
    }

    private void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L || !(what instanceof SoulKey)) {
            return 0L;
        }
        long inserted = Math.min(amount, Math.max(0L, this.getMaxSoul() - this.soulAmount));
        if (mode == Actionable.MODULATE) {
            this.soulAmount += inserted;
            this.saveChanges();
        }
        return this.getUpgrades().isInstalled((ItemLike)AEItems.VOID_CARD) ? amount : inserted;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        long currentAmount = this.soulAmount;
        if (this.soulAmount > 0L && Objects.equals(SoulKey.INSTANCE, what)) {
            if (mode == Actionable.MODULATE) {
                this.soulAmount = Math.max(0L, this.soulAmount - extractAmount);
                this.saveChanges();
            }
            return Math.min(extractAmount, currentAmount);
        }
        return 0L;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.soulAmount < 0L) {
            this.stack.remove(SoulComponents.SOUL_CELL_AMOUNT);
        } else {
            this.stack.set(SoulComponents.SOUL_CELL_AMOUNT, (Object)this.soulAmount);
        }
        this.isPersisted = true;
    }

    public Component getDescription() {
        return this.stack.getHoverName();
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.soulAmount > 0L) {
            out.add((AEKey)SoulKey.INSTANCE, this.soulAmount);
        }
    }
}

