/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.appliedsoul.common.me.strategy;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.buuz135.industrialforegoingsouls.capabilities.SoulCapabilities;
import com.buuz135.soulplied_energistics.applied.SoulKey;
import com.google.common.primitives.Ints;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class SoulStorageExportStrategy
implements StackExportStrategy {
    private final BlockCapabilityCache<ISoulHandler, Direction> cache;

    public SoulStorageExportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockCapabilityCache.create((BlockCapability)SoulCapabilities.BLOCK, (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
    }

    public long transfer(StackTransferContext context, AEKey what, long amount) {
        if (!(what instanceof SoulKey)) {
            return 0L;
        }
        ISoulHandler sourceTile = (ISoulHandler)this.cache.getCapability();
        if (sourceTile != null) {
            int insertable = sourceTile.fill(Ints.saturatedCast((long)amount), ISoulHandler.Action.SIMULATE);
            int extracted = (int)StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)context.getInternalStorage().getInventory(), (AEKey)SoulKey.INSTANCE, (long)insertable, (IActionSource)context.getActionSource(), (Actionable)Actionable.MODULATE);
            if (extracted > 0) {
                sourceTile.fill(extracted, ISoulHandler.Action.EXECUTE);
            }
            return extracted;
        }
        return 0L;
    }

    public long push(AEKey what, long amount, Actionable mode) {
        if (!(what instanceof SoulKey)) {
            return 0L;
        }
        ISoulHandler sourceTile = (ISoulHandler)this.cache.getCapability();
        return sourceTile != null ? (long)sourceTile.fill(Ints.saturatedCast((long)amount), mode.isSimulate() ? ISoulHandler.Action.SIMULATE : ISoulHandler.Action.EXECUTE) : 0L;
    }
}

