/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.block;

import com.yungnickyoung.minecraft.yungscavebiomes.module.CriteriaModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.ItemModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class PricklyPeachCactusBlock
extends Block
implements BonemealableBlock {
    public static final BooleanProperty FRUIT = BlockStateProperties.BERRIES;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_25;
    protected static final VoxelShape COLLISION_SHAPE = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)8.0, (double)11.0);
    protected static final VoxelShape OUTLINE_SHAPE = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)11.0);
    private static final float AGE_CHANCE = 0.5f;
    private static final float BERRY_CHANCE = 0.1f;
    private static final int MAX_AGE = 25;

    public PricklyPeachCactusBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!PricklyPeachCactusBlock.isMaxAge(blockState) && itemStack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult hitResult) {
        if (((Boolean)blockState.getValue((Property)FRUIT)).booleanValue()) {
            PricklyPeachCactusBlock.popFruit(level, blockPos);
            float volume = Mth.randomBetween((RandomSource)level.random, (float)0.8f, (float)1.2f);
            level.playSound(null, blockPos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, volume);
            level.setBlock(blockPos, (BlockState)((BlockState)blockState.setValue((Property)FRUIT, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
        } else if (player.getMainHandItem().isEmpty()) {
            player.hurt(level.damageSources().cactus(), 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaModule.INTERACT_EMPTY_PRICKLY_CACTUS.trigger(serverPlayer);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (!blockState.canSurvive((LevelReader)serverLevel, blockPos)) {
            serverLevel.destroyBlock(blockPos, true);
        }
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (PricklyPeachCactusBlock.isMaxAge(blockState) || PricklyPeachCactusBlock.hasFruit(blockState)) {
            return;
        }
        if (random.nextDouble() < 0.5) {
            int newAge = (Integer)blockState.getValue((Property)AGE) + 1;
            BlockState newBlockState = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge));
            if (random.nextDouble() < (double)0.1f || newAge == 25) {
                newBlockState = (BlockState)newBlockState.setValue((Property)FRUIT, (Comparable)Boolean.valueOf(true));
            }
            serverLevel.setBlockAndUpdate(blockPos, newBlockState);
        }
    }

    public void spawnAfterBreak(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, ItemStack itemStack, boolean bl) {
        super.spawnAfterBreak(blockState, serverLevel, blockPos, itemStack, bl);
        if (blockState.hasProperty((Property)FRUIT) && ((Boolean)blockState.getValue((Property)FRUIT)).booleanValue()) {
            Block.popResource((Level)serverLevel, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)ItemModule.PRICKLY_PEACH_ITEM.get(), 1));
        }
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return blockState.hasProperty((Property)FRUIT) && (Boolean)blockState.getValue((Property)FRUIT) == false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource random, BlockPos blockPos, BlockState blockState) {
        serverLevel.setBlock(blockPos, (BlockState)((BlockState)blockState.setValue((Property)FRUIT, (Comparable)Boolean.valueOf(true))).setValue((Property)AGE, (Comparable)Integer.valueOf(25)), 2);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return COLLISION_SHAPE;
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return OUTLINE_SHAPE;
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockState blockStateBelow = levelReader.getBlockState(blockPos.below());
        return blockStateBelow.is(BlockTags.SAND);
    }

    @NotNull
    public BlockState updateShape(BlockState currState, Direction neighborDirection, BlockState neighborBlockState, LevelAccessor levelAccessor, BlockPos currPos, BlockPos neighborPos) {
        if (!currState.canSurvive((LevelReader)levelAccessor, currPos)) {
            levelAccessor.scheduleTick(currPos, (Block)this, 1);
        }
        return super.updateShape(currState, neighborDirection, neighborBlockState, levelAccessor, currPos, neighborPos);
    }

    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (entity.getType() == EntityTypeModule.SAND_SNAPPER.get()) {
            return;
        }
        entity.hurt(level.damageSources().cactus(), 1.0f);
    }

    public boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, FRUIT});
    }

    private static boolean isMaxAge(BlockState blockState) {
        return blockState.hasProperty((Property)AGE) && (Integer)blockState.getValue((Property)AGE) == 25;
    }

    private static boolean hasFruit(BlockState blockState) {
        return blockState.hasProperty((Property)FRUIT) && (Boolean)blockState.getValue((Property)FRUIT) != false;
    }

    private static void popFruit(Level level, BlockPos $$1) {
        if (!level.isClientSide && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            double x = (double)$$1.getX() + 0.5;
            double y = (double)$$1.getY() + 0.5 - (double)(EntityType.ITEM.getHeight() / 2.0f);
            double z = (double)$$1.getZ() + 0.5;
            double xOffset = Mth.nextDouble((RandomSource)level.random, (double)0.2, (double)0.25);
            double yOffset = 0.25;
            double zOffset = Mth.nextDouble((RandomSource)level.random, (double)0.2, (double)0.25);
            double dx = Mth.nextDouble((RandomSource)level.random, (double)0.075, (double)0.1);
            double dy = 0.2;
            double dz = Mth.nextDouble((RandomSource)level.random, (double)0.075, (double)0.1);
            if (level.random.nextBoolean()) {
                xOffset *= -1.0;
                dx *= -1.0;
            }
            if (level.random.nextBoolean()) {
                zOffset *= -1.0;
                dz *= -1.0;
            }
            ItemStack fruitItemStack = new ItemStack((ItemLike)ItemModule.PRICKLY_PEACH_ITEM.get(), 1);
            ItemEntity itemEntity = new ItemEntity(level, x += xOffset, y += yOffset, z += zOffset, fruitItemStack, dx, dy, dz);
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
    }
}

