/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.client.render.sandstorm;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yungnickyoung.minecraft.yungscavebiomes.client.render.sandstorm.ISandstormClientDataProvider;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BiomeModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.Mth;

public class SandstormFogRenderer {
    private double fogLevel = 0.0;

    public void render(FogRenderer.FogMode mode, float renderDistance) {
        if (mode == FogRenderer.FogMode.FOG_TERRAIN) {
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            ClientLevel clientLevel = Minecraft.getInstance().level;
            if (localPlayer == null || clientLevel == null) {
                return;
            }
            this.fogLevel = clientLevel.getBiome(localPlayer.blockPosition()).is(BiomeModule.LOST_CAVES) && ((ISandstormClientDataProvider)clientLevel).getSandstormClientData().isSandstormActive() ? Mth.clamp((double)(this.fogLevel + 0.002), (double)0.0, (double)1.0) : Mth.clamp((double)(this.fogLevel - 0.002), (double)0.0, (double)1.0);
            if (!localPlayer.isAlive()) {
                this.fogLevel = 0.0;
            }
            if (this.fogLevel > 0.0) {
                RenderSystem.setShaderFogStart((float)((float)Mth.lerp((double)this.fogLevel, (double)RenderSystem.getShaderFogStart(), (double)-4.0)));
                RenderSystem.setShaderFogEnd((float)((float)Mth.lerp((double)this.fogLevel, (double)RenderSystem.getShaderFogEnd(), (double)Math.min(renderDistance * 0.45f, 64.0f))));
            }
        }
    }

    public double getFogLevel() {
        return this.fogLevel;
    }
}

