/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.world.noise.OpenSimplex2S;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class PillarRockFeature
extends Feature<SimpleBlockConfiguration> {
    private static final int RADIUS_MIN = 5;
    private static final int RADIUS_MAX = 10;
    private static final float HEIGHT_RELATIVE_TO_RADIUS_MIN = 1.5f;
    private static final float HEIGHT_RELATIVE_TO_RADIUS_MAX = 2.0f;
    private static final float TOP_HEIGHT_PROPORTION = 0.3f;
    private static final float TOP_START_HEMISPHERE_OFFSET_MIN = 0.875f;
    private static final float TOP_START_HEMISPHERE_OFFSET_MAX = 0.9375f;
    private static final float BOTTOM_START_HEMISPHERE_OFFSET_MIN = 0.25f;
    private static final float BOTTOM_START_HEMISPHERE_OFFSET_MAX = 0.5f;
    private static final double NOISE_FREQUENCY_XZ = 0.1;
    private static final double NOISE_FREQUENCY_Y = 0.08333333333333334;
    public static final float NOISE_MODULATION_AMOUNT = 0.6f;
    private static final long NOISE_SEED_FLIP_MASK = 4187418520378946841L;

    public PillarRockFeature(Codec<SimpleBlockConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        SimpleBlockConfiguration config = (SimpleBlockConfiguration)context.config();
        BlockState state = config.toPlace().getState(random, context.origin());
        long noiseSeed = level.getSeed() ^ 0x3A1CB2F559143519L;
        float radXZ = Mth.square((float)random.nextFloat()) * 5.0f + 5.0f;
        float height = Mth.nextFloat((RandomSource)random, (float)1.5f, (float)2.0f) * radXZ;
        float topHeight = radXZ * 0.3f;
        float bottomHeight = height - topHeight;
        float creasePositionY = height * 0.5f - topHeight;
        float topStartHemisphereOffset = Mth.nextFloat((RandomSource)random, (float)0.875f, (float)0.9375f);
        float bottomStartHemisphereOffset = Mth.nextFloat((RandomSource)random, (float)0.25f, (float)0.5f);
        float dyTopMultiplier = (1.0f - topStartHemisphereOffset) / topHeight;
        float dyBottomMultiplier = (bottomStartHemisphereOffset - 1.0f) / bottomHeight;
        float dyTopOffset = topStartHemisphereOffset - dyTopMultiplier * creasePositionY;
        float dyBottomOffset = bottomStartHemisphereOffset - dyBottomMultiplier * creasePositionY;
        float dySqTopAtCrease = Mth.square((float)(creasePositionY * dyTopMultiplier + dyTopOffset));
        float dySqBottomAtCrease = Mth.square((float)(creasePositionY * dyBottomMultiplier + dyBottomOffset));
        float topStartDistSqXZCorrection = (1.0f - dySqTopAtCrease) / (radXZ * radXZ);
        float bottomStartDistSqXZCorrection = (1.0f - dySqBottomAtCrease) / (radXZ * radXZ);
        float falloffCurveTopMultiplier = -1.0f / (1.0f - dySqTopAtCrease);
        float falloffCurveBottomMultiplier = -1.0f / (1.0f - dySqBottomAtCrease);
        float falloffCurveTopOffset = 1.0f - falloffCurveTopMultiplier * dySqTopAtCrease;
        float falloffCurveBottomOffset = 1.0f - falloffCurveBottomMultiplier * dySqBottomAtCrease;
        int radYBound = Mth.ceil((float)(height * 0.5f));
        int radXZBound = Mth.ceil((float)radXZ);
        for (int dy = -radYBound; dy <= radYBound; ++dy) {
            boolean isTop = (float)dy >= creasePositionY;
            float dySq = isTop ? Mth.square((float)((float)dy * dyTopMultiplier + dyTopOffset)) : Mth.square((float)((float)dy * dyBottomMultiplier + dyBottomOffset));
            for (int dz = -radXZBound; dz <= radXZBound; ++dz) {
                for (int dx = -radXZBound; dx <= radXZBound; ++dx) {
                    boolean isInRange;
                    float distSqXZ = (float)(dx * dx + dz * dz) * (isTop ? topStartDistSqXZCorrection : bottomStartDistSqXZCorrection);
                    float distSq = distSqXZ + dySq;
                    float baseDensityHere = isTop ? distSq * falloffCurveTopMultiplier + falloffCurveTopOffset : distSq * falloffCurveBottomMultiplier + falloffCurveBottomOffset;
                    boolean bl = isInRange = baseDensityHere >= 0.6f;
                    if (!isInRange) {
                        float noiseHere = OpenSimplex2S.noise3_ImproveXZ(noiseSeed, (double)(dx + origin.getX()) * 0.1, (double)(dy + origin.getY()) * 0.08333333333333334, (double)(dz + origin.getZ()) * 0.1) * 0.3f + 0.3f;
                        float densityHere = baseDensityHere - noiseHere;
                        boolean bl2 = isInRange = densityHere > 0.0f;
                    }
                    if (!isInRange) continue;
                    BlockPos local = origin.offset(dx, dy, dz);
                    level.setBlock(local, state, 3);
                }
            }
        }
        return false;
    }
}

