/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.compat;

import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.api.IEffectScreenExtension;
import net.mehvahdjukaar.jeed.api.JeedAPI;
import net.minecraft.client.gui.screens.inventory.BeaconScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.Nullable;

public class NativeCompat {
    private static MobEffectInstance inventoryHoveredEffect;
    private static boolean small;
    private static final IEffectScreenExtension<BeaconScreen> BEACON_EXTENSION;
    public static final IEffectScreenExtension INVENTORY_EXTENSION;

    public static void init() {
        JeedAPI.registerScreenExtension(EffectRenderingInventoryScreen.class, INVENTORY_EXTENSION);
        JeedAPI.registerScreenExtension(CreativeModeInventoryScreen.class, INVENTORY_EXTENSION);
        JeedAPI.registerScreenExtension(InventoryScreen.class, INVENTORY_EXTENSION);
        JeedAPI.registerScreenExtension(BeaconScreen.class, BEACON_EXTENSION);
    }

    public static void setInventoryEffect(@Nullable MobEffectInstance hoveredEffect, boolean isSmall) {
        inventoryHoveredEffect = hoveredEffect;
        small = isSmall;
    }

    static {
        small = false;
        BEACON_EXTENSION = (screen, mouseX, mouseY, reason) -> {
            if (reason != IEffectScreenExtension.CallReason.MOUSE_CLICKED) {
                for (BeaconScreen.BeaconButton b : screen.beaconButtons) {
                    BeaconScreen.BeaconPowerButton pb;
                    if (!(b instanceof BeaconScreen.BeaconPowerButton) || !(pb = (BeaconScreen.BeaconPowerButton)b).isHovered()) continue;
                    int tier = b.getClass() != BeaconScreen.BeaconPowerButton.class ? 1 : 0;
                    return new MobEffectInstance(pb.effect, 0, tier);
                }
            }
            return null;
        };
        INVENTORY_EXTENSION = new IEffectScreenExtension<EffectRenderingInventoryScreen>(){

            @Override
            @Nullable
            public MobEffectInstance getEffectAtPosition(EffectRenderingInventoryScreen screen, double mouseX, double mouseY, IEffectScreenExtension.CallReason reason) {
                if (!reason.isForRender() || screen.hoveredSlot == null && screen.getMenu().getCarried().isEmpty()) {
                    if (small && reason == IEffectScreenExtension.CallReason.TOOLTIP && !Jeed.suppressVanillaTooltips()) {
                        return null;
                    }
                    return inventoryHoveredEffect;
                }
                return null;
            }

            @Override
            public boolean showDurationOnTooltip() {
                return small;
            }
        };
    }
}

