/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.PlayerNotifier;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.api.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.api.Protection;
import dev.ftb.mods.ftbchunks.api.ProtectionPolicy;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimedChunkManagerImpl
implements ClaimedChunkManager {
    public static final LevelResource DATA_DIR = new LevelResource("ftbchunks");
    private static final Long2ObjectMap<UUID> EMPTY_CHUNKS = Long2ObjectMaps.emptyMap();
    protected static final String BYPASS_FTB_CHUNKS_PROTECTION = "BypassFTBChunksProtection";
    private static ClaimedChunkManagerImpl instance;
    private final TeamManager teamManager;
    private final Map<UUID, ChunkTeamDataImpl> teamData;
    private final Map<ChunkDimPos, ClaimedChunkImpl> claimedChunks;
    private final Path dataDirectory;
    private Map<ResourceKey<Level>, Long2ObjectMap<UUID>> forceLoadedChunkCache;

    public ClaimedChunkManagerImpl(TeamManager teamManager) {
        this.teamManager = teamManager;
        this.teamData = new HashMap<UUID, ChunkTeamDataImpl>();
        this.claimedChunks = new HashMap<ChunkDimPos, ClaimedChunkImpl>();
        this.dataDirectory = this.getMinecraftServer().getWorldPath(DATA_DIR);
        Path localDirectory = Platform.getGameFolder().resolve("local/ftbchunks");
        try {
            if (Files.notExists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            if (Files.notExists(localDirectory, new LinkOption[0])) {
                Files.createDirectories(localDirectory, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ClaimedChunkManagerImpl getInstance() {
        return instance;
    }

    public static void init(TeamManager teamManager) {
        instance = new ClaimedChunkManagerImpl(teamManager);
    }

    public static void shutdown() {
        instance = null;
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public void initForceLoadedChunks(ServerLevel level) {
        Long2ObjectMap<UUID> map = this.getForceLoadedChunks((ResourceKey<Level>)level.dimension());
        if (map.isEmpty() || level.getChunkSource() == null) {
            return;
        }
        map.forEach((pos, id) -> {
            ChunkPos chunkPos = new ChunkPos(pos.longValue());
            FTBChunksExpected.addChunkToForceLoaded(level, "ftbchunks", id, chunkPos.x, chunkPos.z, true);
        });
        level.getChunkSource().save(false);
        FTBChunks.LOGGER.info("Force-loaded %d chunks in %s".formatted(map.size(), level.dimension().location()));
    }

    private ChunkTeamDataImpl loadTeamData(Team team) {
        Path path = this.dataDirectory.resolve(String.valueOf(team.getId()) + ".snbt");
        ChunkTeamDataImpl data = new ChunkTeamDataImpl(this, path, team);
        SNBTCompoundTag dataFile = SNBT.read((Path)path);
        if (dataFile != null) {
            data.deserializeNBT((CompoundTag)dataFile);
            this.teamData.put(team.getId(), data);
            return data;
        }
        return data;
    }

    public MinecraftServer getMinecraftServer() {
        return this.teamManager.getServer();
    }

    @Override
    public ChunkTeamDataImpl getOrCreateData(@NotNull Team team) {
        ChunkTeamDataImpl data = this.teamData.get(team.getId());
        if (data == null) {
            data = this.loadTeamData(team);
            this.teamData.put(team.getId(), data);
        }
        return data;
    }

    @Override
    public ChunkTeamDataImpl getPersonalData(UUID id) {
        return this.getTeamManager().getPlayerTeamForPlayerID(id).map(this::getOrCreateData).orElse(null);
    }

    @Override
    public ChunkTeamDataImpl getOrCreateData(ServerPlayer player) {
        return this.getTeamManager().getTeamForPlayer(player).map(this::getOrCreateData).orElse(null);
    }

    public void deleteTeam(Team toDelete) {
        ChunkTeamDataImpl data = this.teamData.get(toDelete.getId());
        if (data != null && toDelete.getMembers().isEmpty()) {
            FTBChunks.LOGGER.debug("dropping references to empty team " + String.valueOf(toDelete.getId()));
            this.teamData.remove(toDelete.getId());
            try {
                Files.deleteIfExists(data.getFile());
            }
            catch (IOException e) {
                FTBChunks.LOGGER.error(String.format("can't delete file %s: %s", data.getFile(), e.getMessage()));
            }
        }
    }

    @Override
    @Nullable
    public ClaimedChunkImpl getChunk(ChunkDimPos pos) {
        return this.claimedChunks.get(pos);
    }

    public Collection<ClaimedChunkImpl> getAllClaimedChunks() {
        return Collections.unmodifiableCollection(this.claimedChunks.values());
    }

    @Override
    public Map<UUID, Collection<ClaimedChunk>> getClaimedChunksByTeam(Predicate<ClaimedChunk> predicate) {
        return Collections.unmodifiableMap(this.getAllClaimedChunks().stream().filter(predicate).collect(Collectors.groupingBy(cc -> cc.getTeamData().getTeam().getId())));
    }

    @Override
    public boolean getBypassProtection(UUID player) {
        return this.teamManager.getPlayerTeamForPlayerID(player).map(team -> team.getExtraData().getBoolean(BYPASS_FTB_CHUNKS_PROTECTION)).orElse(false);
    }

    @Override
    public void setBypassProtection(UUID player, boolean bypass) {
        this.teamManager.getPlayerTeamForPlayerID(player).ifPresent(team -> {
            team.getExtraData().putBoolean(BYPASS_FTB_CHUNKS_PROTECTION, bypass);
            team.markDirty();
        });
    }

    @Override
    public boolean shouldPreventInteraction(@Nullable Entity actor, InteractionHand hand, BlockPos pos, Protection protection, @Nullable Entity targetEntity) {
        ServerPlayer player;
        block11: {
            block10: {
                if (!(actor instanceof ServerPlayer)) break block10;
                player = (ServerPlayer)actor;
                if (!((Boolean)FTBChunksWorldConfig.DISABLE_PROTECTION.get()).booleanValue() && player.level() != null) break block11;
            }
            return false;
        }
        boolean isFake = PlayerHooks.isFake((Player)player);
        if (isFake && ((ProtectionPolicy)((Object)FTBChunksWorldConfig.ALLOW_FAKE_PLAYERS.get())).isOverride()) {
            return ((ProtectionPolicy)((Object)FTBChunksWorldConfig.ALLOW_FAKE_PLAYERS.get())).shouldPreventInteraction();
        }
        ClaimedChunkImpl chunk = this.getChunk(new ChunkDimPos(player.level(), pos));
        if (chunk != null) {
            boolean prevented;
            ProtectionPolicy policy = protection.getProtectionPolicy(player, pos, hand, chunk, targetEntity);
            boolean bl = policy.isOverride() ? policy.shouldPreventInteraction() : (prevented = !player.isSpectator() && (isFake || !this.getBypassProtection(player.getUUID())));
            if (prevented) {
                PlayerNotifier.notifyWithCooldown((Player)player, (Component)Component.translatable((String)"ftbchunks.action_prevented").withStyle(ChatFormatting.GOLD), 2000L);
                if (isFake) {
                    chunk.getTeamData().logPreventedAccess(player, System.currentTimeMillis());
                }
            }
            return prevented;
        }
        if (FTBChunksWorldConfig.noWilderness(player)) {
            ProtectionPolicy override = protection.getProtectionPolicy(player, pos, hand, null, targetEntity);
            if (override.isOverride()) {
                return override.shouldPreventInteraction();
            }
            if (!isFake && (this.getBypassProtection(player.getUUID()) || player.isSpectator())) {
                return false;
            }
            PlayerNotifier.notifyWithCooldown((Player)player, (Component)Component.translatable((String)"ftbchunks.need_to_claim_chunk").withStyle(ChatFormatting.GOLD), 2000L);
            return true;
        }
        return false;
    }

    public void clearForceLoadedCache() {
        this.forceLoadedChunkCache = null;
    }

    @Override
    public Map<ResourceKey<Level>, Long2ObjectMap<UUID>> getForceLoadedChunks() {
        if (this.forceLoadedChunkCache == null) {
            this.forceLoadedChunkCache = new HashMap<ResourceKey<Level>, Long2ObjectMap<UUID>>();
            for (ClaimedChunkImpl chunk : this.getAllClaimedChunks()) {
                if (!chunk.isActuallyForceLoaded()) continue;
                Long2ObjectMap pos2idMap = this.forceLoadedChunkCache.computeIfAbsent((ResourceKey<Level>)chunk.getPos().dimension(), k -> new Long2ObjectOpenHashMap());
                pos2idMap.put(ChunkPos.asLong((int)chunk.getPos().x(), (int)chunk.getPos().z()), (Object)chunk.getTeamData().getTeamId());
            }
            this.forceLoadedChunkCache = this.forceLoadedChunkCache.isEmpty() ? Collections.emptyMap() : this.forceLoadedChunkCache;
        }
        return Collections.unmodifiableMap(this.forceLoadedChunkCache);
    }

    @Override
    @NotNull
    public Long2ObjectMap<UUID> getForceLoadedChunks(ResourceKey<Level> dimension) {
        return this.getForceLoadedChunks().getOrDefault(dimension, EMPTY_CHUNKS);
    }

    @Override
    public boolean isChunkForceLoaded(ChunkDimPos chunkDimPos) {
        return this.getForceLoadedChunks((ResourceKey<Level>)chunkDimPos.dimension()).containsKey(chunkDimPos.chunkPos().toLong());
    }

    public void registerClaim(ChunkDimPos pos, ClaimedChunk chunk) {
        if (chunk instanceof ClaimedChunkImpl) {
            ClaimedChunkImpl impl = (ClaimedChunkImpl)chunk;
            this.claimedChunks.put(pos, impl);
        }
    }

    public void unregisterClaim(ChunkDimPos pos) {
        this.claimedChunks.remove(pos);
    }
}

