/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.block.entity.BlockEntityWritableGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModSounds;

public final class BlockEntityDecorativeGrave
extends BlockEntityWritableGrave {
    private long lastCheckSoul = -1L;
    private long lastCheckCorruption = -1L;
    private int corruptionLevel = 0;
    private boolean isScreaming = false;
    private long lastRiteTicks = -1L;
    public static final List<BlockPos> PARTICLE_OFFSETS = BlockPos.betweenClosedStream((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(pos -> Math.abs(pos.getX()) == 2 || Math.abs(pos.getZ()) == 2).map(BlockPos::immutable).toList();

    public BlockEntityDecorativeGrave(BlockPos pos, BlockState state) {
        super(ModBlocks.tile_decorative_grave, pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlockEntityDecorativeGrave grave) {
        SoulType soulType;
        BlockEntityDecorativeGrave.commonTick(level, pos, state, grave);
        if (grave.isScreaming()) {
            Random random = Helper.RANDOM;
            for (BlockPos currentPos : PARTICLE_OFFSETS) {
                if (random.nextInt(1000) != 0) continue;
                level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, (double)((float)currentPos.getX() + random.nextFloat()) - 0.5, (double)((float)currentPos.getY() - random.nextFloat()) - 1.0, (double)((float)currentPos.getZ() + random.nextFloat()) - 0.5);
            }
        } else if (TimeHelper.atInterval(grave.countTicks, 25) && (soulType = (SoulType)((Object)state.getValue(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
            ProxyHelper.produceGraveSoul(level, pos, soulType, (int)(grave.countTicks % 100L / 25L));
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlockEntityDecorativeGrave grave) {
        int checkCount;
        int checkInterval;
        BlockEntityDecorativeGrave.commonTick(level, pos, state, grave);
        long serverGlobalTime = GlobalClock.INSTANCE.getTime(level);
        if (grave.corruptionLevel > 0) {
            if (grave.lastCheckCorruption <= 0L || grave.lastCheckCorruption > serverGlobalTime) {
                grave.lastCheckCorruption = serverGlobalTime;
            } else {
                checkInterval = TimeHelper.isDateAroundSpringBloom() ? 1200 : 12000;
                checkCount = (int)(serverGlobalTime - grave.lastCheckCorruption) / checkInterval;
                if (checkCount > 0) {
                    grave.decreaseCorruption(checkCount);
                    grave.lastCheckCorruption += (long)checkCount * (long)checkInterval;
                }
            }
        }
        if (grave.isScreaming() && TimeHelper.atInterval(serverGlobalTime, 900)) {
            level.playSound(null, pos, ModSounds.soul_whisper, SoundSource.AMBIENT, 0.4f, 0.8f + Helper.RANDOM.nextFloat() * 0.4f);
            if (Helper.RANDOM.nextBoolean()) {
                Vec3 centerVec = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(0.5, 1.0, 0.5);
                Player closestPlayer = level.getNearestPlayer(centerVec.x, centerVec.y, centerVec.z, 20.0, false);
                if (closestPlayer != null && Helper.canSeeEntity((Entity)closestPlayer, centerVec)) {
                    Snowball snowball = new Snowball(level, centerVec.x, centerVec.y, centerVec.z);
                    snowball.setItem(new ItemStack((ItemLike)Items.BONE));
                    snowball.getPersistentData().putBoolean("slowing_bone", true);
                    Vec3 vec = closestPlayer.position().add(0.0, (double)closestPlayer.getEyeHeight(), 0.0).subtract(snowball.position());
                    snowball.setNoGravity(true);
                    snowball.shoot(vec.x, vec.y, vec.z, 0.5f, 1.0f);
                    level.addFreshEntity((Entity)snowball);
                }
            }
        }
        if (grave.lastCheckSoul <= 0L || grave.lastCheckSoul > serverGlobalTime || grave.isScreaming()) {
            grave.lastCheckSoul = serverGlobalTime;
            return;
        }
        checkInterval = TimeHelper.tickFromMinute((Integer)ConfigTombstone.decorative_grave.soulTime.get());
        checkCount = (int)(serverGlobalTime - grave.lastCheckSoul) / checkInterval;
        if (checkCount > 0) {
            if (((SoulType)((Object)state.getValue(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
                grave.resetCheckSoul();
                return;
            }
            double chance = 1.0 - Math.pow(1.0 - (double)((Integer)ConfigTombstone.decorative_grave.soulChance.get()).intValue() / 100.0, checkCount);
            if (chance >= 1.0 || Helper.RANDOM.nextDouble() <= chance) {
                SoulType soulType;
                LightningBolt bolt;
                if (checkCount == 1 && grave.lastCheckSoul == serverGlobalTime + (long)checkInterval && (bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level)) != null) {
                    bolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
                    bolt.setVisualOnly(true);
                    level.addFreshEntity((Entity)bolt);
                }
                if ((soulType = SoulType.generateSoulType()) == SoulType.STRONG && ((Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get()).booleanValue() && Helper.RANDOM.nextBoolean() && EntityHelper.noGraveGuardianAround(level, pos)) {
                    Helper.spawnGraveGuardian(level, pos);
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue(BlockDecorativeGrave.SOUL_TYPE, (Comparable)((Object)soulType)));
                }
                grave.lastCheckSoul += (long)checkCount * (long)checkInterval;
            }
        }
    }

    public void resetCheckSoul() {
        this.lastCheckSoul = -1L;
    }

    public boolean isScreaming() {
        return this.isScreaming;
    }

    public void setScreaming(boolean flag) {
        if (this.isScreaming != flag) {
            this.isScreaming = flag;
            this.setChanged();
            if (this.level != null) {
                BlockState state = this.getBlockState();
                this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
            }
        }
    }

    public int getCorruptionLevel() {
        return this.corruptionLevel;
    }

    public void increaseCorruption(int amount) {
        if (!this.isScreaming()) {
            this.corruptionLevel = Mth.clamp((int)(this.corruptionLevel + amount), (int)0, (int)100);
            this.setChanged();
            if (this.corruptionLevel == 100) {
                this.setScreaming(true);
            }
        }
    }

    public void decreaseCorruption(int amount) {
        Level level;
        this.corruptionLevel = Math.max(0, this.corruptionLevel - amount);
        if (this.corruptionLevel == 0) {
            this.setScreaming(false);
        }
        if (amount > 1 && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.0, (double)this.getBlockPos().getZ() + 0.5, 8, 0.3, 0.0, 0.3, 0.1);
        }
    }

    public boolean applySpammingRite() {
        if (this.level != null) {
            long serverGlobalTime = GlobalClock.INSTANCE.getTime(this.level);
            if (this.lastRiteTicks > 0L && this.lastRiteTicks < serverGlobalTime && !TimeHelper.isMinuteElapsed(serverGlobalTime, this.lastRiteTicks, 5)) {
                this.increaseCorruption(15);
                return true;
            }
            this.lastRiteTicks = serverGlobalTime;
        }
        return false;
    }

    public boolean applyScreaming(ServerPlayer serverPlayer) {
        if (this.isScreaming()) {
            LangKey.MESSAGE_SCREAMING_GRAVE.sendMessage((Player)serverPlayer, new Object[0]);
            serverPlayer.serverLevel().playSound(null, this.getBlockPos(), SoundEvents.GHAST_SCREAM, SoundSource.BLOCKS, 0.5f, 0.8f + Helper.RANDOM.nextFloat() * 0.4f);
            return true;
        }
        return false;
    }

    @Override
    protected CompoundTag writeShared(CompoundTag compound) {
        super.writeShared(compound);
        if (this.lastCheckSoul > 0L) {
            compound.putLong("lastCheckSoul", this.lastCheckSoul);
        }
        compound.putBoolean("is_screaming", this.isScreaming());
        compound.putInt("corruption_level", this.corruptionLevel);
        if (this.lastRiteTicks > 0L) {
            compound.putLong("last_rite_ticks", this.lastRiteTicks);
        }
        return compound;
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("lastCheckSoul", 4)) {
            this.lastCheckSoul = compound.getLong("lastCheckSoul");
        }
        if (compound.contains("is_screaming")) {
            this.isScreaming = compound.getBoolean("is_screaming");
        }
        if (compound.contains("corruption_level", 3)) {
            this.corruptionLevel = compound.getInt("corruption_level");
        }
        if (compound.contains("last_rite_ticks", 4)) {
            this.lastRiteTicks = compound.getLong("last_rite_ticks");
        }
    }
}

