/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block.entity;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import ovh.corail.tombstone.block.entity.BlockEntityWritableGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;

public final class BlockEntityPlayerGrave
extends BlockEntityWritableGrave {
    private static final int INVENTORY_SIZE = 255;
    private final ItemStackHandler inventory = new ItemStackHandler(255);
    private boolean needAccess = false;
    private Item lastOffhandItem = Items.AIR;

    public BlockEntityPlayerGrave(BlockPos pos, BlockState state) {
        super(ModBlocks.tile_grave, pos, state);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void giveInventory(ServerPlayer player) {
        boolean hasLosses;
        if (this.getLevel() == null || !EntityHelper.isValidServerPlayer(player)) {
            return;
        }
        assert (player.getServer() != null);
        boolean bl = hasLosses = (Integer)ConfigTombstone.player_death.chanceLossOnDeath.get() > 0 && (Integer)ConfigTombstone.player_death.percentLossOnDeath.get() > 0 && ((Boolean)ConfigTombstone.player_death.lossOnDeathOnlyForAbandonedGrave.get() == false || !this.getNeedAccess()) && Helper.RANDOM.nextInt(100) < (Integer)ConfigTombstone.player_death.chanceLossOnDeath.get();
        if (hasLosses) {
            float percentLossOnDeath = (float)((Integer)ConfigTombstone.player_death.percentLossOnDeath.get()).intValue() * 0.01f;
            int countLoss = 0;
            for (int slotId = 0; slotId < this.inventory.getSlots(); ++slotId) {
                ItemStack stack2 = this.inventory.getStackInSlot(slotId);
                if (stack2.isEmpty()) continue;
                if (stack2.isStackable()) {
                    int losses = Math.round((float)stack2.getCount() * percentLossOnDeath);
                    if (losses <= 0) continue;
                    this.inventory.extractItem(slotId, losses, false);
                    ++countLoss;
                    continue;
                }
                if (((Boolean)ConfigTombstone.player_death.lossOnDeathOnlyForStackableItems.get()).booleanValue() || !(Helper.RANDOM.nextFloat() <= percentLossOnDeath)) continue;
                this.inventory.setStackInSlot(slotId, ItemStack.EMPTY);
                ++countLoss;
            }
            if (countLoss > 0) {
                LangKey.MESSAGE_LOSSES_ON_DEATH.sendSpecialMessage((Player)player, new Object[0]);
            }
        }
        EventFactory.onRestoreInventory((Player)player, this);
        PlayerPreference playerPreference = PlayerPreference.get(player);
        if (playerPreference.getAutoEquipRule().equipOnGraveRecovery()) {
            InventoryHelper.autoequip(player, this.inventory, this.lastOffhandItem);
        }
        NonNullList swapItems = NonNullList.create();
        if (playerPreference.priorizeToolOnHotbar()) {
            IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
            int playerSlotId = -1;
            for (int graveSlotId = 0; graveSlotId < this.inventory.getSlots() && playerSlotId < 9; ++graveSlotId) {
                ItemStack playerStack;
                if (!InventoryHelper.isToolOrMelee(this.inventory.getStackInSlot(graveSlotId))) continue;
                do {
                    playerStack = itemHandler.getStackInSlot(++playerSlotId);
                } while (playerSlotId < 9 && InventoryHelper.isToolOrMelee(playerStack));
                if (!playerStack.isEmpty()) {
                    swapItems.add((Object)itemHandler.extractItem(playerSlotId, 1, false));
                }
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.inventory.extractItem(graveSlotId, 1, false), (int)playerSlotId);
                this.inventory.setStackInSlot(graveSlotId, ItemStack.EMPTY);
            }
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack3 = this.inventory.getStackInSlot(i);
            if (stack3.isEmpty()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack3.copy());
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
        if (!swapItems.isEmpty()) {
            swapItems.forEach(stack -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack));
            swapItems.clear();
        }
        if (PlayerPreference.get(player).isReverseInventorySorting()) {
            List<ItemStack> orderedList = IntStream.range(9, player.getInventory().items.size()).mapToObj(arg_0 -> ((NonNullList)player.getInventory().items).get(arg_0)).toList();
            int j = 0;
            for (int i = player.getInventory().items.size() - 1; i >= 9; --i) {
                player.getInventory().setItem(i, orderedList.get(j++));
            }
        }
        this.removeGraveBy(player);
        EffectHelper.capDuration((LivingEntity)player, ModEffects.ghostly_shape, 100);
        player.inventoryMenu.broadcastChanges();
        LangKey.MESSAGE_OPEN_GRAVE_SUCCESS.sendMessage((Player)player, new Object[0]);
    }

    private void removeGraveBy(ServerPlayer player) {
        ServerPlayer owner;
        if (this.getLevel() == null) {
            return;
        }
        ServerPlayer serverPlayer = owner = player.getGameProfile().getName().equals(this.ownerName) ? player : (ServerPlayer)Optional.ofNullable(player.getServer()).map(MinecraftServer::getPlayerList).map(list -> list.getPlayerByName(this.ownerName)).orElse(null);
        if (owner != null) {
            DeathHandler.INSTANCE.removeGrave(owner, new Location(this.worldPosition, this.getLevel()));
        }
        DeathHandler.INSTANCE.removeAndEmptyPlayerGrave(this.getLevel(), this.worldPosition);
        this.getLevel().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR, SoundSource.BLOCKS, 0.5f, 0.5f);
    }

    public void setOwner(Player player, long deathDate, boolean needAccess) {
        this.setOwner(player.getGameProfile().getId(), player.getGameProfile().getName(), deathDate);
        this.needAccess = needAccess;
    }

    public boolean getNeedAccess() {
        int decayTime = (Integer)SharedConfigTombstone.player_death.decayTime.get();
        return this.needAccess && (decayTime == -1 || this.getDeathMCTime() < (long)TimeHelper.tickFromMinute(decayTime));
    }

    public Item getLastOffhandItem() {
        return this.lastOffhandItem;
    }

    public void setLastOffhandItem(Item item) {
        if (item != Items.AIR) {
            this.lastOffhandItem = item;
        }
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("inventory", (Tag)this.inventory.serializeNBT(provider));
        compound.putString("last_offhand_item", BuiltInRegistries.ITEM.getKey((Object)this.lastOffhandItem).toString());
    }

    @Override
    protected CompoundTag writeShared(CompoundTag compound) {
        super.writeShared(compound);
        compound.putBoolean("need_access", this.needAccess);
        return compound;
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("inventory", 10)) {
            CompoundTag tag = compound.getCompound("inventory");
            tag.putInt("Size", 255);
            this.inventory.deserializeNBT(provider, tag);
        }
        this.needAccess = compound.getBoolean("need_access");
        if (compound.contains("last_offhand_item", 8)) {
            ResourceLocation itemRL = ResourceLocation.tryParse((String)compound.getString("last_offhand_item"));
            Optional.ofNullable(RegistryHelper.getItem(itemRL)).ifPresent(item -> {
                this.lastOffhandItem = item;
            });
        }
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public String getFormattedInfo() {
        StringBuilder builder = new StringBuilder(ChatFormatting.GOLD.toString()).append(LangKey.MESSAGE_RIP.getText(new Object[0]).getString()).append(" ").append(this.getOwnerName()).append(" ");
        if (this.getNeedAccess()) {
            int left;
            builder.append(ChatFormatting.RED).append("[").append(LangKey.MESSAGE_LOCKED.getText(new Object[0]).getString()).append("]");
            int decayTime = (Integer)SharedConfigTombstone.player_death.decayTime.get();
            if (decayTime > 0 && (left = TimeHelper.tickFromMinute(decayTime) - (int)this.getDeathMCTime()) > 0) {
                builder.append(" ").append(TimeHelper.getTimeStringWithUnit(left));
            }
        } else {
            builder.append(ChatFormatting.GREEN).append("[").append(LangKey.MESSAGE_UNLOCKED.getText(new Object[0]).getString()).append("]");
        }
        return builder.toString();
    }

    public String getFormattedDeathDate() {
        Date date = new Date(this.getOwnerDeathTime());
        return String.valueOf(ChatFormatting.ITALIC) + LangKey.MESSAGE_DIED_ON.getText(new Object[0]).getString() + " " + new SimpleDateFormat("dd/MM/yyyy").format(date) + " " + LangKey.MESSAGE_DEATH_TIME.getText(new SimpleDateFormat("HH:mm:ss").format(date)).getString();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlockEntityPlayerGrave grave) {
        BlockEntityPlayerGrave.commonTick(level, pos, state, grave);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlockEntityPlayerGrave grave) {
        BlockEntityPlayerGrave.commonTick(level, pos, state, grave);
    }
}

