/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Method;
import java.util.Optional;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.ShaderRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.minecraft.client.renderer.GameRenderer;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.Helper;

public class CompatibilityIris {
    public static final CompatibilityIris instance = new CompatibilityIris();
    private final Method methodGetCurrentPackName;

    private CompatibilityIris() {
        if (SupportMods.IRIS.isLoaded() || SupportMods.OCULUS.isLoaded()) {
            Class<?> irisClass = Helper.getClass("net.irisshaders.iris.Iris");
            this.methodGetCurrentPackName = Optional.ofNullable(irisClass).map(c -> Helper.getMethod(c, "getCurrentPackName", new Class[0])).orElse(null);
        } else {
            this.methodGetCurrentPackName = null;
        }
    }

    public boolean isShaderEnabled() {
        if (this.methodGetCurrentPackName != null) {
            try {
                String currentPackName = (String)this.methodGetCurrentPackName.invoke(null, new Object[0]);
                return !currentPackName.startsWith("(off)");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public void setFogShader() {
        try {
            WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
            if (pipeline instanceof ShaderRenderingPipeline) {
                ShaderRenderingPipeline shaderRenderingPipeline = (ShaderRenderingPipeline)pipeline;
                RenderSystem.setShader(() -> shaderRenderingPipeline.getShaderMap().getShader(ShaderKey.SPS));
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RenderSystem.setShader(GameRenderer::getParticleShader);
    }
}

