/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.helper.Helper;

public record CastSpectralBite(LevelBasedValue minDamage, LevelBasedValue maxDamage) implements EnchantmentEntityEffect
{
    public static final MapCodec<CastSpectralBite> CODEC = RecordCodecBuilder.mapCodec(c -> c.group((App)LevelBasedValue.CODEC.fieldOf("min_damage").forGetter(CastSpectralBite::minDamage), (App)LevelBasedValue.CODEC.fieldOf("max_damage").forGetter(CastSpectralBite::maxDamage)).apply((Applicative)c, CastSpectralBite::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse itemInUse, Entity entity, Vec3 origin) {
        LivingEntity attacker;
        if (itemInUse.owner() != null && itemInUse.owner().isAlive() && entity instanceof LivingEntity && (attacker = (LivingEntity)entity).isAlive()) {
            int damage = Math.max(0, Math.round(Mth.randomBetween((RandomSource)Helper.RANDOM_SOURCE, (float)this.minDamage.calculate(enchantmentLevel), (float)this.maxDamage.calculate(enchantmentLevel))));
            Helper.castSpectralBite(itemInUse.owner(), (Entity)attacker, damage, true);
        }
    }

    public MapCodec<CastSpectralBite> codec() {
        return CODEC;
    }
}

