/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModTriggers;

public record StealRandomEffect(LevelBasedValue minDuration, LevelBasedValue maxDuration) implements EnchantmentEntityEffect
{
    public static final MapCodec<StealRandomEffect> CODEC = RecordCodecBuilder.mapCodec(c -> c.group((App)LevelBasedValue.CODEC.fieldOf("min_duration").forGetter(StealRandomEffect::minDuration), (App)LevelBasedValue.CODEC.fieldOf("max_duration").forGetter(StealRandomEffect::maxDuration)).apply((Applicative)c, StealRandomEffect::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse itemInUse, Entity entity, Vec3 origin) {
        MobEffectInstance targetEffectInstance;
        LivingEntity attacker;
        LivingEntity livingEntity;
        LivingEntity target;
        if (entity instanceof LivingEntity && (target = (LivingEntity)entity).isAlive() && (livingEntity = itemInUse.owner()) instanceof LivingEntity && (attacker = livingEntity).isAlive() && (targetEffectInstance = (MobEffectInstance)Helper.getRandomInList(target.getActiveEffects().stream().filter(EffectHelper::isAllowedEffect).collect(Collectors.toList())).orElse(null)) != null) {
            int oldDuration;
            int stolenDuration = Math.round(Mth.randomBetween((RandomSource)Helper.RANDOM_SOURCE, (float)this.minDuration.calculate(enchantmentLevel), (float)this.maxDuration.calculate(enchantmentLevel)) * 20.0f);
            if (!targetEffectInstance.isInfiniteDuration() && stolenDuration > targetEffectInstance.getDuration()) {
                stolenDuration = targetEffectInstance.getDuration();
            }
            if ((oldDuration = EffectHelper.getDuration(attacker, (Holder<MobEffect>)targetEffectInstance.getEffect(), targetEffectInstance.getAmplifier())) >= 0) {
                attacker.addEffect(new MobEffectInstance(targetEffectInstance.getEffect(), Mth.clamp((int)(stolenDuration + oldDuration), (int)-1, (int)Integer.MAX_VALUE), targetEffectInstance.getAmplifier()));
            }
            if (!targetEffectInstance.isInfiniteDuration()) {
                EffectHelper.clearEffect(target, (Holder<MobEffect>)targetEffectInstance.getEffect());
                if (stolenDuration < targetEffectInstance.getDuration()) {
                    targetEffectInstance.duration -= stolenDuration;
                    target.addEffect(targetEffectInstance);
                }
                if (target.getHealth() > target.getMaxHealth()) {
                    target.setHealth(target.getMaxHealth());
                }
            }
            if (EntityHelper.isValidServerPlayer((Entity)attacker)) {
                ModTriggers.steal_effect.trigger((ServerPlayer)attacker);
            }
        }
    }

    public MapCodec<StealRandomEffect> codec() {
        return CODEC;
    }
}

