/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEntities;

public class SpectralBite
extends EvokerFangs {
    private boolean isSpectral = false;
    private int damage = 1;

    public SpectralBite(EntityType<? extends SpectralBite> entityType, Level level) {
        super(entityType, level);
    }

    public SpectralBite(Level level, double x, double y, double z, float rotRad, int warmupDelayTicks, LivingEntity owner) {
        this(ModEntities.spectral_bite, level);
        this.warmupDelayTicks = warmupDelayTicks;
        this.setOwner(owner);
        this.setYRot(rotRad * 57.295776f);
        this.setPos(x, y, z);
    }

    public void dealDamageTo(LivingEntity target) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LivingEntity owner = this.getOwner();
            if (target.isAlive() && !target.isInvulnerable() && target != owner) {
                int oldDuration;
                if (Optional.ofNullable(owner).map(o -> o.isAlliedTo((Entity)target)).orElse(false).booleanValue()) {
                    return;
                }
                if (this.isSpectral && (oldDuration = EffectHelper.getDuration(target, (Holder<MobEffect>)MobEffects.WITHER, 0)) >= 0) {
                    target.addEffect(new MobEffectInstance(MobEffects.WITHER, 5 + oldDuration, 0), (Entity)owner);
                }
                if (owner == null) {
                    Helper.hurtWithoutCooldown(target, this.damageSources().magic(), this.damage);
                } else if (!owner.isAlliedTo((Entity)target)) {
                    Helper.hurtWithoutCooldown(target, this.damageSources().indirectMagic((Entity)this, (Entity)owner), this.damage);
                }
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putInt("damage", this.damage);
        compoundTag.putBoolean("is_spectral", this.isSpectral);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains("damage", 3)) {
            this.damage = compoundTag.getInt("damage");
        }
        if (compoundTag.contains("is_spectral", 1)) {
            this.isSpectral = compoundTag.getBoolean("is_spectral");
        }
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public void setSpectral(boolean isSpectral) {
        this.isSpectral = isSpectral;
    }
}

