/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CycleButton<T>
extends AbstractButton {
    static final BooleanSupplier DEFAULT_ALT_LIST_SELECTOR = Screen::hasAltDown;
    private static final List<Boolean> BOOLEAN_OPTIONS = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private final Component name;
    private int index;
    private T value;
    private final ValueListSupplier<T> values;
    private final Function<T, Component> valueStringifier;
    private final Function<CycleButton<T>, MutableComponent> narrationProvider;
    private final OnValueChange<T> onValueChange;
    private final TooltipSupplier<T> tooltipSupplier;
    private final boolean displayOnlyValue;

    CycleButton(int x, int y, int width, int height, Component message, Component name, int index, T value, ValueListSupplier<T> values, Function<T, Component> valueStringifier, Function<CycleButton<T>, MutableComponent> narrationProvider, OnValueChange<T> onValueChange, TooltipSupplier<T> tooltipSupplier, boolean displayOnlyValue) {
        super(x, y, width, height, message);
        this.name = name;
        this.index = index;
        this.value = value;
        this.values = values;
        this.valueStringifier = valueStringifier;
        this.narrationProvider = narrationProvider;
        this.onValueChange = onValueChange;
        this.tooltipSupplier = tooltipSupplier;
        this.displayOnlyValue = displayOnlyValue;
    }

    public void onPress() {
        this.cycleValue(Screen.hasShiftDown() ? -1 : 1);
    }

    private void cycleValue(int id) {
        List<T> list = this.values.getSelectedList();
        this.index = Mth.positiveModulo((int)(this.index + id), (int)list.size());
        T t = list.get(this.index);
        this.updateValue(t);
        this.onValueChange.onValueChange(this, t);
    }

    private T getCycledValue(int id) {
        List<T> list = this.values.getSelectedList();
        return list.get(Mth.positiveModulo((int)(this.index + id), (int)list.size()));
    }

    public boolean mouseScrolled(double p_168885_, double p_168886_, double p_168887_) {
        if (p_168887_ > 0.0) {
            this.cycleValue(-1);
        } else if (p_168887_ < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    public void setValue(T value) {
        List<T> list = this.values.getSelectedList();
        int i = list.indexOf(value);
        if (i != -1) {
            this.index = i;
        }
        this.updateValue(value);
    }

    private void updateValue(T value) {
        Component component = this.createLabelForValue(value);
        this.setMessage(component);
        this.value = value;
    }

    private Component createLabelForValue(T value) {
        return this.displayOnlyValue ? this.valueStringifier.apply(value) : this.createFullName(value);
    }

    private MutableComponent createFullName(T value) {
        return CommonComponents.optionNameValue((Component)this.name, (Component)this.valueStringifier.apply(value));
    }

    public T getValue() {
        return this.value;
    }

    protected MutableComponent createNarrationMessage() {
        return this.narrationProvider.apply(this);
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            T t = this.getCycledValue(1);
            Component component = this.createLabelForValue(t);
            if (this.isFocused()) {
                output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{component}));
            } else {
                output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{component}));
            }
        }
    }

    public MutableComponent createDefaultNarrationMessage() {
        return CycleButton.wrapDefaultNarrationMessage((Component)(this.displayOnlyValue ? this.createFullName(this.value) : this.getMessage()));
    }

    public static <T> Builder<T> builder(Function<T, Component> valueStringifier) {
        return new Builder<T>(valueStringifier);
    }

    public static Builder<Boolean> booleanBuilder(Component p_168897_, Component p_168898_) {
        return new Builder<Boolean>(p_168902_ -> p_168902_ != false ? p_168897_ : p_168898_).withValues(BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Boolean>(p_168891_ -> p_168891_ != false ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF).withValues(BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder(boolean value) {
        return CycleButton.onOffBuilder().withInitialValue(value);
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface ValueListSupplier<T> {
        public List<T> getSelectedList();

        public List<T> getDefaultList();

        public static <T> ValueListSupplier<T> create(List<T> p_168969_) {
            ImmutableList list = ImmutableList.copyOf(p_168969_);
            return new ValueListSupplier<T>((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getSelectedList() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }

        public static <T> ValueListSupplier<T> create(final BooleanSupplier p_168971_, List<T> p_168972_, List<T> p_168973_) {
            ImmutableList list = ImmutableList.copyOf(p_168972_);
            ImmutableList list1 = ImmutableList.copyOf(p_168973_);
            return new ValueListSupplier<T>((List)list1, (List)list){
                final /* synthetic */ List val$list1;
                final /* synthetic */ List val$list;
                {
                    this.val$list1 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getSelectedList() {
                    return p_168971_.getAsBoolean() ? this.val$list1 : this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnValueChange<T> {
        public void onValueChange(CycleButton<T> var1, T var2);
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface TooltipSupplier<T>
    extends Function<T, List<FormattedCharSequence>> {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder<T> {
        private int initialIndex;
        @Nullable
        private T initialValue;
        private final Function<T, Component> valueStringifier;
        private TooltipSupplier<T> tooltipSupplier = p_168964_ -> ImmutableList.of();
        private Function<CycleButton<T>, MutableComponent> narrationProvider = CycleButton::createDefaultNarrationMessage;
        private ValueListSupplier<T> values = ValueListSupplier.create(ImmutableList.of());
        private boolean displayOnlyValue;

        public Builder(Function<T, Component> valueStringifier) {
            this.valueStringifier = valueStringifier;
        }

        public Builder<T> withValues(List<T> p_168951_) {
            this.values = ValueListSupplier.create(p_168951_);
            return this;
        }

        @SafeVarargs
        public final Builder<T> withValues(T ... p_168962_) {
            return this.withValues((List<T>)ImmutableList.copyOf((Object[])p_168962_));
        }

        public Builder<T> withValues(List<T> list1, List<T> list2) {
            this.values = ValueListSupplier.create(DEFAULT_ALT_LIST_SELECTOR, list1, list2);
            return this;
        }

        public Builder<T> withValues(BooleanSupplier booleanSupplier, List<T> list1, List<T> list2) {
            this.values = ValueListSupplier.create(booleanSupplier, list1, list2);
            return this;
        }

        public Builder<T> withTooltip(TooltipSupplier<T> tooltipSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            return this;
        }

        public Builder<T> withInitialValue(T initialValue) {
            this.initialValue = initialValue;
            int i = this.values.getDefaultList().indexOf(initialValue);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public Builder<T> withCustomNarration(Function<CycleButton<T>, MutableComponent> narrationProvider) {
            this.narrationProvider = narrationProvider;
            return this;
        }

        public Builder<T> displayOnlyValue() {
            this.displayOnlyValue = true;
            return this;
        }

        public CycleButton<T> create(int x, int y, int width, int height, Component name) {
            return this.create(x, y, width, height, name, (p_168946_, p_168947_) -> {});
        }

        public CycleButton<T> create(int p_168937_, int p_168938_, int p_168939_, int p_168940_, Component name, OnValueChange<T> onValueChange) {
            List<T> list = this.values.getDefaultList();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T t = this.initialValue != null ? this.initialValue : list.get(this.initialIndex);
            Component component = this.valueStringifier.apply(t);
            Component component1 = this.displayOnlyValue ? component : CommonComponents.optionNameValue((Component)name, (Component)component);
            return new CycleButton<T>(p_168937_, p_168938_, p_168939_, p_168940_, component1, name, this.initialIndex, t, this.values, this.valueStringifier, this.narrationProvider, onValueChange, this.tooltipSupplier, this.displayOnlyValue);
        }
    }
}

