/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.VanillaStructures;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.registry.ModTags;

public final class SpawnHelper {
    private final ResourceKey<Level> dimId;
    private BlockPos initPos;
    private final Level level;
    private final Predicate<BlockPos> withinWorldBorder;
    private final Predicate<BlockPos> withinWorldBuildHeight;
    private final int minHeight;
    private final int maxHeight;
    private boolean isGravePlacement = false;
    private boolean graveInWater = true;
    private List<BlockPos> positions;
    private BlockPos spawnPos = null;
    private SpawnResult spawnType = SpawnResult.NONE;
    private int move = 0;

    public SpawnHelper(ServerLevel level, BlockPos initPos) {
        this.level = level;
        this.dimId = this.level.dimension();
        this.initPos = WorldHelper.getCloserValidPos(this.level, initPos);
        this.withinWorldBorder = pos -> this.level.getWorldBorder().isWithinBounds(pos);
        this.minHeight = this.level.getMinBuildHeight();
        this.maxHeight = this.minHeight + this.level.dimensionType().logicalHeight();
        this.withinWorldBuildHeight = pos -> pos.getY() >= this.minHeight && pos.getY() < this.maxHeight;
    }

    public SpawnHelper withPlayerPreference(PlayerPreference playerPreference) {
        this.graveInWater = playerPreference.allowGraveInWater();
        return this;
    }

    private Location result() {
        return new Location(this.spawnPos, this.dimId);
    }

    public Location findSafePlace(int range, boolean withHeight) {
        this.initPositions(this.initPos.offset(-range, withHeight ? -range : 0, -range), this.initPos.offset(range, withHeight ? range : 0, range));
        for (BlockPos currentPos : this.positions) {
            if (!this.isIdealSpawnPlace(currentPos)) continue;
            return this.result();
        }
        return Location.ORIGIN;
    }

    public Location findStructurePlace(ResourceLocation structureRL) {
        this.initPos = new BlockPos(this.initPos.getX(), WorldHelper.getY(structureRL, (ServerLevel)this.level, this.initPos.getX(), this.initPos.getZ()), this.initPos.getZ());
        return this.findPlace(VanillaStructures.BURIED_TREASURE.is(structureRL));
    }

    public Location findSpawnPlace() {
        return this.findPlace();
    }

    public Location findGravePlace() {
        this.isGravePlacement = true;
        return this.findPlace();
    }

    private BlockPos getInitPosInFluid() {
        BlockPos adjustedPos = this.initPos;
        BlockState state = this.level.getBlockState(adjustedPos);
        FluidState fluidState = state.getFluidState();
        if (fluidState.isEmpty() && this.withinWorldBuildHeight.test(adjustedPos = adjustedPos.above())) {
            state = this.level.getBlockState(adjustedPos);
            fluidState = state.getFluidState();
        }
        if (fluidState.isEmpty() || fluidState.is(FluidTags.WATER) && (!this.isGravePlacement || this.graveInWater)) {
            return this.initPos;
        }
        while (!this.level.getBlockState(adjustedPos).getFluidState().isEmpty()) {
            if (this.withinWorldBuildHeight.test(adjustedPos = adjustedPos.above())) continue;
            return this.initPos;
        }
        return adjustedPos;
    }

    private Location findPlace() {
        return this.findPlace(false);
    }

    private Location findPlace(boolean uniquePosition) {
        Predicate<BlockPos> predicPos;
        Predicate<BlockPos> predicate = predicPos = this.isGravePlacement ? this::isIdealGravePlace : this::isIdealSpawnPlace;
        if (predicPos.test(this.initPos)) {
            return this.result();
        }
        if (uniquePosition) {
            this.initUniquePosition();
        } else {
            this.initChunkPositions();
        }
        BlockPos adjustedPos = this.getInitPosInFluid();
        boolean wasInLiquid = !adjustedPos.equals((Object)this.initPos);
        int maxY = Math.min(adjustedPos.getY() + 70, this.maxHeight);
        int minY = Math.max(adjustedPos.getY() - 70, this.minHeight);
        int yUp = adjustedPos.getY();
        int yDown = yUp - 1;
        boolean canGoDown = true;
        boolean canGoUp = true;
        this.move = 0;
        while (canGoUp || canGoDown) {
            canGoUp = yUp < maxY;
            canGoDown = !wasInLiquid && yDown > minY;
            for (BlockPos pos : this.positions) {
                BlockPos currentPos;
                if (canGoUp && predicPos.test(currentPos = new BlockPos(pos.getX(), yUp, pos.getZ()))) {
                    return this.result();
                }
                if (!canGoDown || !predicPos.test(currentPos = new BlockPos(pos.getX(), yDown, pos.getZ()))) continue;
                return this.result();
            }
            ++yUp;
            --yDown;
            ++this.move;
        }
        return this.isGravePlacement && SpawnResult.FIT.hasPattern(this.spawnType) ? this.result() : Location.ORIGIN;
    }

    private boolean isIdealSpawnPlace(BlockPos pos) {
        if (this.isSafePlace(pos) && this.isSafePlace(pos.above()) && this.isSafeGround(pos.below())) {
            this.setTypeAndPosition(SpawnResult.IDEAL, pos);
            return true;
        }
        return false;
    }

    private boolean isIdealGravePlace(BlockPos pos) {
        if (this.isGravePlace(pos)) {
            SpawnResult type = this.isSafeGround(pos.below()) ? (this.isSafePlace(pos.above()) ? (this.isSafePlace(pos.above(2)) ? SpawnResult.IDEAL : SpawnResult.FIT) : SpawnResult.NORMAL) : SpawnResult.MINIMAL;
            this.setTypeAndPosition(type, pos);
            return this.move > 40 ? SpawnResult.FIT.hasPattern(this.spawnType) : type == SpawnResult.IDEAL;
        }
        return false;
    }

    private boolean isGravePlace(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        FluidState fluidState = state.getFluidState();
        return (fluidState.isEmpty() || this.graveInWater && fluidState.is(FluidTags.WATER)) && (state.canBeReplaced() || state.is(BlockTags.FLOWERS)) && !state.hasBlockEntity();
    }

    private void setTypeAndPosition(SpawnResult type, BlockPos pos) {
        if (type.ordinal() > this.spawnType.ordinal()) {
            this.spawnType = type;
            this.spawnPos = pos;
        }
    }

    private void initChunkPositions() {
        ChunkPos chunkPos = new ChunkPos(this.initPos);
        this.initPositions(new BlockPos(chunkPos.getMinBlockX(), 0, chunkPos.getMinBlockZ()), new BlockPos(chunkPos.getMaxBlockX(), 0, chunkPos.getMaxBlockZ()));
    }

    private void initPositions(BlockPos startPos, BlockPos endPos) {
        this.spawnPos = null;
        this.spawnType = SpawnResult.NONE;
        this.positions = SpawnHelper.getAllInBox(startPos, endPos).sorted(Comparator.comparingDouble(pos -> Helper.getDistanceSq((Vec3i)pos, this.initPos.getX(), 0, this.initPos.getZ()))).toList();
    }

    private void initUniquePosition() {
        this.spawnPos = null;
        this.spawnType = SpawnResult.NONE;
        this.positions = ImmutableList.of((Object)this.initPos);
    }

    public static Stream<BlockPos> getAllInBox(BlockPos startPos, BlockPos endPos) {
        int minX = Math.min(startPos.getX(), endPos.getX());
        int maxX = Math.max(startPos.getX(), endPos.getX());
        int minY = Math.min(startPos.getY(), endPos.getY());
        int maxY = Math.max(startPos.getY(), endPos.getY());
        int minZ = Math.min(startPos.getZ(), endPos.getZ());
        int maxZ = Math.max(startPos.getZ(), endPos.getZ());
        Stream.Builder<BlockPos> list = Stream.builder();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    list.accept(new BlockPos(x, y, z));
                }
            }
        }
        return list.build();
    }

    private boolean isSafePlace(BlockPos pos) {
        boolean allowInWater;
        if (!this.withinWorldBorder.test(pos)) {
            return false;
        }
        BlockState state = this.level.getBlockState(pos);
        @Nullable PathType type = state.getBlockPathType((BlockGetter)this.level, pos, null);
        boolean bl = allowInWater = !this.isGravePlacement || this.graveInWater;
        if (type != null) {
            return switch (type) {
                case PathType.OPEN, PathType.BREACH -> true;
                case PathType.WATER, PathType.WATER_BORDER -> allowInWater;
                default -> false;
            };
        }
        Block block = state.getBlock();
        if (state.isAir() || block == Blocks.SNOW || allowInWater && block == Blocks.WATER) {
            return true;
        }
        if (block == Blocks.LAVA || block == Blocks.COBWEB || state.is(BlockTags.FIRE) || block == Blocks.SWEET_BERRY_BUSH || block == Blocks.POWDER_SNOW || state.is(BlockTags.PORTALS)) {
            return false;
        }
        VoxelShape collisionShape = state.getCollisionShape((BlockGetter)this.level, pos);
        if (collisionShape != Shapes.empty()) {
            return false;
        }
        FluidState fluidState = state.getFluidState();
        return fluidState.isEmpty() || allowInWater && fluidState.is(FluidTags.WATER);
    }

    private boolean isSafeGround(BlockPos pos) {
        if (!this.withinWorldBorder.test(pos)) {
            return false;
        }
        BlockState state = this.level.getBlockState(pos);
        @Nullable PathType type = state.getBlockPathType((BlockGetter)this.level, pos, null);
        if (type != null) {
            return switch (type) {
                case PathType.WATER, PathType.WATER_BORDER, PathType.BLOCKED, PathType.WALKABLE, PathType.LEAVES, PathType.COCOA, PathType.RAIL -> true;
                default -> false;
            };
        }
        Block block = state.getBlock();
        if (block == Blocks.LILY_PAD || block == Blocks.SNOW || block == Blocks.WATER) {
            return true;
        }
        if (!this.isGravePlacement && state.is(ModTags.Blocks.graves)) {
            return true;
        }
        if (state.isAir() || block == Blocks.MAGMA_BLOCK || block == Blocks.CACTUS || block == Blocks.BARRIER || block == Blocks.TNT) {
            return false;
        }
        VoxelShape collisionShape = state.getCollisionShape((BlockGetter)this.level, pos);
        if (collisionShape == Shapes.empty()) {
            FluidState fluidState = state.getFluidState();
            return !fluidState.isEmpty() && fluidState.is(FluidTags.WATER);
        }
        if (collisionShape == Shapes.block()) {
            return true;
        }
        return state.is(BlockTags.SLABS) || state.is(BlockTags.WOOL_CARPETS) || state.is(BlockTags.STAIRS) || state.is(BlockTags.RAILS);
    }

    public static enum SpawnResult {
        NONE,
        MINIMAL,
        NORMAL,
        FIT,
        IDEAL;


        public boolean hasPattern(SpawnResult actualPattern) {
            return this.ordinal() <= actualPattern.ordinal();
        }
    }
}

