/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class PreciseEnchantFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"precise_enchant");
    public static final MapCodec<PreciseEnchantFunction> CODEC = RecordCodecBuilder.mapCodec(b -> PreciseEnchantFunction.commonFields((RecordCodecBuilder.Instance)b).and(b.group((App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("id").orElse((Object)"tombstone:soulbound").forGetter(g -> g.id), (App)NumberProviders.CODEC.fieldOf("level").orElse((Object)new ConstantValue(1.0f)).forGetter(g -> g.level))).apply((Applicative)b, PreciseEnchantFunction::new));
    private final String id;
    private final NumberProvider level;

    private PreciseEnchantFunction(List<LootItemCondition> conditionsIn, String id, NumberProvider level) {
        super(conditionsIn);
        this.id = id;
        this.level = level;
    }

    public LootItemFunctionType<PreciseEnchantFunction> getType() {
        return ModLootFunctions.PRECISE_ENCHANT;
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        ResourceLocation rl = ResourceLocation.parse((String)this.id);
        Holder enchantHolder = ModEnchantments.getEnchantmentHolder(rl, (Level)context.getLevel()).orElse(null);
        if (enchantHolder != null) {
            ItemEnchantments.Mutable itemEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            itemEnchantments.set(enchantHolder, Mth.clamp((int)this.level.getInt(context), (int)((Enchantment)enchantHolder.value()).getMinLevel(), (int)Helper.getMaxLevel((Holder<Enchantment>)enchantHolder)));
            EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)itemEnchantments.toImmutable());
            return stack;
        }
        return stack.is(Items.ENCHANTED_BOOK) ? ItemStack.EMPTY : stack;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final String id;
        private final int level;

        public Builder(ResourceKey<Enchantment> enchantmentRK) {
            this(enchantmentRK, 1);
        }

        public Builder(ResourceKey<Enchantment> enchantmentRK, int level) {
            this.id = enchantmentRK.location().toString();
            this.level = level;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new PreciseEnchantFunction(this.getConditions(), this.id, (NumberProvider)new ConstantValue((float)this.level));
        }
    }
}

