/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEffects;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(method={"isAlliedTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodIsAlliedTo(Entity entity, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Entity entity2;
        if (entity != null && (entity2 = (Entity)this) instanceof LivingEntity) {
            LivingEntity otherEntity;
            LivingEntity thisEntity = (LivingEntity)entity2;
            if (entity instanceof LivingEntity && EntityHelper.areOwnerOrServants(thisEntity, otherEntity = (LivingEntity)entity)) {
                callbackInfoReturnable.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"isInvisibleTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodIsInvisibleTo(Player player, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (player.hasEffect(ModEffects.ghostly_shape) || player.hasEffect(ModEffects.true_sight)) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"deflection"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodDeflection(Projectile projectile, CallbackInfoReturnable<ProjectileDeflection> callbackInfoReturnable) {
        LivingEntity livingEntity;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(ModEffects.projectile_reflection)) {
            callbackInfoReturnable.setReturnValue((proj, attacker, randomSource) -> {
                proj.setDeltaMovement(proj.getDeltaMovement().scale(-1.0));
                proj.setYRot(proj.getYRot() + 180.0f);
                proj.yRotO += 180.0f;
                proj.hasImpulse = true;
            });
        }
    }
}

