/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.registry.ModTriggers;

public record SMessagePlayerPreference(PlayerPreference playerPreference, boolean isLogin) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, SMessagePlayerPreference> STREAM_CODEC = StreamCodec.ofMember(SMessagePlayerPreference::encode, SMessagePlayerPreference::decode);
    static final CustomPacketPayload.Type<SMessagePlayerPreference> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"player_preference"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static SMessagePlayerPreference decode(RegistryFriendlyByteBuf buf) {
        return new SMessagePlayerPreference(PlayerPreference.fromBytes((ByteBuf)buf), buf.readBoolean());
    }

    static void encode(SMessagePlayerPreference msg, RegistryFriendlyByteBuf buf) {
        PlayerPreference.toBytes(msg.playerPreference, (ByteBuf)buf);
        buf.writeBoolean(msg.isLogin);
    }

    static void handle(SMessagePlayerPreference msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        PlayerPreference oldPlayerPreference = PlayerPreference.get(player);
        PlayerPreference.set(player, msg.playerPreference);
        if (!msg.isLogin && !msg.playerPreference.hasSameFavoriteGrave(oldPlayerPreference)) {
            ModTriggers.choose_grave_type.trigger(player);
        }
    }
}

