/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.particle.CustomParticle;
import ovh.corail.tombstone.particle.ParticleRenderTypes;
import ovh.corail.tombstone.registry.ModSounds;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleGhost
extends CustomParticle {
    private final double mX;
    private final double mZ;

    public ParticleGhost(ClientLevel level, double x, double y, double z, double mX, double mZ) {
        super(level, x, y + 1.0, z);
        this.mX = mX;
        this.mZ = mZ;
        this.setLifetime(200);
        this.scale(6.0f);
        level.playLocalSound(x, y, z, ModSounds.getGhostSound(), SoundSource.VOICE, 1.0f, 1.0f, true);
        this.setAlpha(0.5f);
    }

    @Override
    public void update() {
        super.update();
        if (this.age < 10 && this.age % 3 == 0) {
            ParticleUtils.spawnParticlesAlongAxis((Direction.Axis)Direction.Axis.X, (Level)this.level, (BlockPos)BlockPos.containing((double)this.x, (double)(this.y - 1.0), (double)this.z), (double)0.125, (ParticleOptions)ParticleTypes.FLASH, (UniformInt)UniformInt.of((int)1, (int)2));
        }
        ParticleUtils.spawnParticlesAlongAxis((Direction.Axis)Direction.Axis.X, (Level)this.level, (BlockPos)BlockPos.containing((double)this.x, (double)this.y, (double)this.z), (double)0.125, (ParticleOptions)ParticleTypes.CRIMSON_SPORE, (UniformInt)UniformInt.of((int)1, (int)3));
        if (this.age == 10) {
            this.xd = this.mX;
            this.zd = this.mZ;
        }
        float ratio = (float)this.age / (float)this.lifetime;
        this.setAlpha((1.0f - ratio) * 0.8f);
        ProxyHelper.produceGraveSmoke((Level)this.level, 3, this.x, this.y - 0.8, this.z, 0xFFFFFF);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderTypes.GHOST;
    }
}

