/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.registries.RegisterEvent;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.recipe.DisableableShapedRecipe;
import ovh.corail.tombstone.recipe.DisableableShapelessRecipe;
import ovh.corail.tombstone.recipe.RecipeEnchantedGraveKey;
import ovh.corail.tombstone.recipe.ShapedSerializer;
import ovh.corail.tombstone.recipe.ShapelessSerializer;

public final class ModSerializers {
    public static RecipeSerializer<DisableableShapelessRecipe> DISABLEABLE_SHAPELESS = (RecipeSerializer)Helper.unsafeNullCast();
    public static RecipeSerializer<DisableableShapedRecipe> DISABLEABLE_SHAPED = (RecipeSerializer)Helper.unsafeNullCast();
    public static RecipeSerializer<RecipeEnchantedGraveKey> ENCHANTED_GRAVE_KEY = (RecipeSerializer)Helper.unsafeNullCast();

    static void onRegister(RegisterEvent event) {
        DISABLEABLE_SHAPELESS = new ShapelessSerializer<DisableableShapelessRecipe>(DisableableShapelessRecipe::new);
        ModSerializers.register(event, DISABLEABLE_SHAPELESS, "disableable_shapeless");
        DISABLEABLE_SHAPED = new ShapedSerializer<DisableableShapedRecipe>(DisableableShapedRecipe::new);
        ModSerializers.register(event, DISABLEABLE_SHAPED, "disableable_shaped");
        ENCHANTED_GRAVE_KEY = new ShapelessSerializer<RecipeEnchantedGraveKey>(RecipeEnchantedGraveKey::new);
        ModSerializers.register(event, ENCHANTED_GRAVE_KEY, "enchanted_grave_key");
    }

    private static void register(RegisterEvent event, RecipeSerializer<?> serializer, String name) {
        event.register(Registries.RECIPE_SERIALIZER, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name), () -> serializer);
    }
}

