/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SkeletonClothingLayer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.render.GraveGuardianArmorLayer;
import ovh.corail.tombstone.render.GraveGuardianCapeLayer;
import ovh.corail.tombstone.render.GraveGuardianItemInHandLayer;

@OnlyIn(value=Dist.CLIENT)
public final class GraveGuardianRenderer
extends MobRenderer<GraveGuardian, SkeletonModel<GraveGuardian>> {
    private static final ResourceLocation SKELETON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/stray.png");
    private static final ResourceLocation STRAY_CLOTHES_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/stray_overlay.png");

    public GraveGuardianRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SkeletonModel(context.bakeLayer(ModelLayers.STRAY)), 0.5f);
        this.addLayer((RenderLayer)new GraveGuardianItemInHandLayer((RenderLayerParent<GraveGuardian, SkeletonModel<GraveGuardian>>)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new GraveGuardianArmorLayer(this, context));
        this.addLayer((RenderLayer)new SkeletonClothingLayer((RenderLayerParent)this, context.getModelSet(), ModelLayers.STRAY_OUTER_LAYER, STRAY_CLOTHES_LOCATION));
        this.addLayer(new GraveGuardianCapeLayer((RenderLayerParent<GraveGuardian, SkeletonModel<GraveGuardian>>)this, context.getModelSet()));
    }

    public ResourceLocation getTextureLocation(GraveGuardian graveGuardian) {
        return SKELETON_LOCATION;
    }
}

