/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.entity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.block.entity.BlockEntityPlayerGrave;
import ovh.corail.tombstone.block.entity.BlockEntityWritableGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public final class RenderWritableGrave<T extends BlockEntityWritableGrave>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation SCREAMING_GRAVE_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/particle/fake_fog.png");
    private static final ResourceLocation TEXTURE_SKELETON_HEAD = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/skeleton.png");
    private final Map<SkullBlock.Type, SkullModelBase> skullModels;

    public RenderWritableGrave(BlockEntityRendererProvider.Context context) {
        this.skullModels = SkullBlockRenderer.createSkullRenderers((EntityModelSet)context.getModelSet());
    }

    public void render(T te, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int destroyStage) {
        TimeHelper.SpecialEvent specialEvent;
        BlockEntityDecorativeGrave blockEntityDecorativeGrave;
        BlockState knownState;
        BlockEntityPlayerGrave grave;
        if (te.getLevel() == null) {
            return;
        }
        if (te instanceof BlockEntityPlayerGrave && !(grave = (BlockEntityPlayerGrave)((Object)te)).getNeedAccess()) {
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            BlockState web = Blocks.COBWEB.defaultBlockState();
            BlockRenderDispatcher rendererDispatcher = Minecraft.getInstance().getBlockRenderer();
            rendererDispatcher.renderSingleBlock(web, poseStack, multiBufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
            poseStack.translate(1.0f, 0.0f, 1.0f);
            rendererDispatcher.renderSingleBlock(web, poseStack, multiBufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        if (!ModBlocks.isAnyGrave((knownState = te.getLevel().getBlockState(te.getBlockPos())).getBlock())) {
            return;
        }
        if (te instanceof BlockEntityDecorativeGrave && (blockEntityDecorativeGrave = (BlockEntityDecorativeGrave)((Object)te)).isScreaming()) {
            this.renderScreamingGraveOverlay(blockEntityDecorativeGrave, poseStack, multiBufferSource, partialTicks);
            return;
        }
        switch ((ConfigTombstone.Client.GraveSkinRule)((Object)ConfigTombstone.client.graveSkinRule.get())) {
            default: {
                throw new MatchException(null, null);
            }
            case FORCE_NORMAL: {
                TimeHelper.SpecialEvent specialEvent2 = TimeHelper.SpecialEvent.NONE;
                break;
            }
            case FORCE_HALLOWEEN: {
                TimeHelper.SpecialEvent specialEvent2 = TimeHelper.SpecialEvent.HALLOWEEN;
                break;
            }
            case FORCE_CHRISTMAS: {
                TimeHelper.SpecialEvent specialEvent2 = TimeHelper.SpecialEvent.CHRISTMAS;
                break;
            }
            case FORCE_SPRING_BLOOM: {
                TimeHelper.SpecialEvent specialEvent2 = TimeHelper.SpecialEvent.SPRING_BLOOM;
                break;
            }
            case DEFAULT: {
                TimeHelper.SpecialEvent specialEvent2 = specialEvent = TimeHelper.getSpecialEvent();
            }
        }
        if (!((BlockEntityWritableGrave)((Object)te)).hasOwner() && specialEvent == TimeHelper.SpecialEvent.NONE) {
            return;
        }
        Direction facing = (Direction)knownState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        BlockGraveBase grave2 = (BlockGraveBase)knownState.getBlock();
        GraveModel graveModel = grave2.getGraveType();
        BlockGraveMarble.MarbleType marbleType = BlockGraveMarble.MarbleType.byId((Integer)knownState.getValue((Property)BlockGraveBase.MODEL_TEXTURE));
        if (specialEvent != TimeHelper.SpecialEvent.NONE) {
            this.renderSpecial(te, poseStack, multiBufferSource, graveModel, marbleType, facing, light, specialEvent);
        }
        if (!((BlockEntityWritableGrave)((Object)te)).hasOwner()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f * (float)(this.getRotationIndex(facing) - 2)));
        if (graveModel == GraveModel.GRAVE_CROSS) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.translate(0.0f, 0.26f, -0.07f);
        } else {
            poseStack.mulPose(Axis.XN.rotationDegrees(180.0f));
            switch (graveModel) {
                case GRAVE_SIMPLE: {
                    poseStack.translate(0.0f, -0.4f, 0.29f);
                    break;
                }
                case GRAVE_NORMAL: {
                    poseStack.translate(0.0f, -0.5f, 0.36f);
                    break;
                }
                case TOMBSTONE: {
                    poseStack.translate(0.0f, -0.23f, -0.08f);
                    break;
                }
                case SUBARAKI_GRAVE: {
                    poseStack.translate(0.0f, -0.62f, -0.14f);
                    break;
                }
                case GRAVE_ORIGINAL: {
                    poseStack.translate(0.0f, -0.2f, -0.51f);
                    break;
                }
            }
        }
        Font fontRender = Minecraft.getInstance().font;
        boolean is_original = graveModel == GraveModel.GRAVE_ORIGINAL;
        this.showString((Component)LangKey.MESSAGE_RIP.getText(ChatFormatting.BOLD, new Object[0]), poseStack, fontRender, is_original ? 8 : 0, (Integer)ConfigTombstone.client.textColorRIP.get() + -16777216, 0.007f, multiBufferSource, light);
        this.showString((Component)Component.literal((String)((BlockEntityWritableGrave)((Object)te)).getOwnerName()), poseStack, fontRender, is_original ? 14 : 11, (Integer)ConfigTombstone.client.textColorOwner.get() + -16777216, 0.005f, multiBufferSource, light);
        float scaleForDate = (Boolean)ConfigTombstone.client.dateInMCTime.get() != false ? 0.005f : 0.004f;
        this.showString((Component)LangKey.MESSAGE_DIED_ON.getText(new Object[0]), poseStack, fontRender, 26, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, multiBufferSource, light);
        if (((Boolean)ConfigTombstone.client.dateInMCTime.get()).booleanValue()) {
            long days = ((BlockEntityWritableGrave)((Object)te)).getDeathMCTime() / 24000L;
            MutableComponent dateString = LangKey.MESSAGE_DAY.getText(days);
            this.showString((Component)dateString, poseStack, fontRender, 36, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, multiBufferSource, light);
        } else {
            Date date = new Date(((BlockEntityWritableGrave)((Object)te)).getOwnerDeathTime());
            MutableComponent dateString = Component.literal((String)new SimpleDateFormat("dd/MM/yyyy").format(date));
            MutableComponent timeString = LangKey.MESSAGE_DEATH_TIME.getText(new SimpleDateFormat("HH:mm:ss").format(date));
            this.showString((Component)dateString, poseStack, fontRender, 36, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, multiBufferSource, light);
            this.showString((Component)timeString, poseStack, fontRender, 46, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, multiBufferSource, light);
        }
        poseStack.popPose();
    }

    private void renderScreamingGraveOverlay(BlockEntityDecorativeGrave blockEntityDecorativeGrave, PoseStack poseStack, MultiBufferSource multiBufferSource, float partialTicks) {
        int segments = 16;
        float radius = 0.9f;
        float scroll = ((float)blockEntityDecorativeGrave.countTicks + partialTicks) * 0.02f % 1.0f;
        float v1 = 0.0f;
        float v2 = 1.0f;
        float height = 0.4f;
        float yOffset = 0.2f;
        int r = 55;
        int g = 124;
        int b = 255;
        float alpha = 0.6f;
        Matrix4f matrix = poseStack.last().pose();
        Matrix3f normal = poseStack.last().normal();
        poseStack.pushPose();
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)SCREAMING_GRAVE_OVERLAY, (boolean)false));
        for (int i = 0; i < 16; ++i) {
            double angle1 = 0.39269908169872414 * (double)i;
            double angle2 = 0.39269908169872414 * (double)((i + 1) % 16);
            float x1 = (float)Math.cos(angle1) * 0.9f + 0.5f;
            float z1 = (float)Math.sin(angle1) * 0.9f + 0.5f;
            float x2 = (float)Math.cos(angle2) * 0.9f + 0.5f;
            float z2 = (float)Math.sin(angle2) * 0.9f + 0.5f;
            float u1 = (float)i / 16.0f + scroll;
            float u2 = (float)(i + 1) / 16.0f + scroll;
            Vector3f faceNormal = new Vector3f(z2 - z1, 0.0f, x1 - x2).normalize();
            vertexConsumer.addVertex(matrix, x1, 0.2f, z1).setColor(55, 124, 255, 153).setUv(u1, v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(faceNormal.x(), faceNormal.y(), faceNormal.z());
            vertexConsumer.addVertex(matrix, x2, 0.2f, z2).setColor(55, 124, 255, 153).setUv(u2, v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(faceNormal.x(), faceNormal.y(), faceNormal.z());
            vertexConsumer.addVertex(matrix, x2, 0.6f, z2).setColor(55, 124, 255, 153).setUv(u2, v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(faceNormal.x(), faceNormal.y(), faceNormal.z());
            vertexConsumer.addVertex(matrix, x1, 0.6f, z1).setColor(55, 124, 255, 153).setUv(u1, v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(faceNormal.x(), faceNormal.y(), faceNormal.z());
        }
        poseStack.popPose();
    }

    private void showString(Component content, PoseStack poseStack, Font fontRenderer, int posY, int color, float scale, MultiBufferSource multiBufferSource, int light) {
        poseStack.pushPose();
        poseStack.scale(scale, scale, scale);
        FormattedCharSequence formattedCharSequence = FontHelper.canBeFantasy(content.getString()) ? FontHelper.withFantasyFont(content).getVisualOrderText() : content.getVisualOrderText();
        fontRenderer.drawInBatch(formattedCharSequence, (float)(-fontRenderer.width(formattedCharSequence)) / 2.0f, (float)(posY - 30), color, false, poseStack.last().pose(), multiBufferSource, Font.DisplayMode.POLYGON_OFFSET, 0, light);
        poseStack.popPose();
    }

    private void renderSpecial(T te, PoseStack poseStack, MultiBufferSource iRenderTypeBuffer, GraveModel graveModel, BlockGraveMarble.MarbleType marbleType, Direction facing, int light, TimeHelper.SpecialEvent specialEvent) {
        if (specialEvent == TimeHelper.SpecialEvent.SPRING_BLOOM) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.0f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f * (float)this.getRotationIndex(facing)));
            Random rand = new Random(te.getBlockPos().asLong());
            int flowerCount = 3 + rand.nextInt(3);
            float y = 0.13f;
            float scale = 0.7f;
            for (int i = 0; i < flowerCount; ++i) {
                float x;
                poseStack.pushPose();
                poseStack.translate(x, y, switch (graveModel) {
                    case GraveModel.GRAVE_NORMAL, GraveModel.GRAVE_ORIGINAL -> {
                        x = (rand.nextBoolean() ? -0.45f : 0.35f) + 0.05f;
                        yield -0.45f + rand.nextFloat() * 0.9f;
                    }
                    case GraveModel.GRAVE_CROSS -> {
                        if (rand.nextBoolean()) {
                            x = -0.45f + rand.nextFloat() * 0.9f;
                            yield -0.45f + rand.nextFloat() * 0.45f;
                        }
                        x = (rand.nextBoolean() ? -0.45f : 0.3f) + rand.nextFloat() * 0.15f;
                        yield rand.nextFloat() * 0.45f;
                    }
                    case GraveModel.TOMBSTONE -> {
                        x = -0.45f + rand.nextFloat() * 0.9f;
                        yield -0.45f + rand.nextFloat() * 0.2f;
                    }
                    case GraveModel.SUBARAKI_GRAVE -> {
                        if (rand.nextBoolean()) {
                            x = (rand.nextBoolean() ? -0.45f : 0.35f) + 0.05f;
                            yield -0.45f + rand.nextFloat() * 0.9f;
                        }
                        x = -0.45f + rand.nextFloat() * 0.9f;
                        yield (rand.nextBoolean() ? -0.45f : 0.35f) + 0.05f;
                    }
                    default -> {
                        x = -0.45f + rand.nextFloat() * 0.9f;
                        yield -0.45f + rand.nextFloat() * 0.7f;
                    }
                });
                poseStack.scale(scale, scale, scale);
                poseStack.mulPose(Axis.YP.rotationDegrees(rand.nextFloat() * 360.0f));
                Item flower = Helper.getRandomInList(Helper.getItemList((TagKey<Item>)ItemTags.SMALL_FLOWERS), rand).orElse(Items.ALLIUM);
                Minecraft.getInstance().getItemRenderer().renderStatic(new ItemStack((ItemLike)flower), ItemDisplayContext.GROUND, light, OverlayTexture.NO_OVERLAY, poseStack, iRenderTypeBuffer, te.getLevel(), 0);
                poseStack.popPose();
            }
            poseStack.popPose();
        } else {
            boolean isNight = Helper.isNight(te.getLevel());
            boolean isHalloween = specialEvent == TimeHelper.SpecialEvent.HALLOWEEN;
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.0f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f * (float)this.getRotationIndex(facing)));
            if (graveModel == GraveModel.GRAVE_NORMAL || graveModel == GraveModel.GRAVE_SIMPLE) {
                if (graveModel == GraveModel.GRAVE_SIMPLE) {
                    poseStack.translate(0.0f, isHalloween ? 0.21f : 0.17f, 0.0f);
                } else {
                    poseStack.translate(0.0f, isHalloween ? 0.41f : 0.43f, 0.0f);
                }
                float scale = 0.2f;
                poseStack.scale(scale, scale, scale);
                ItemStack stack = isHalloween ? new ItemStack((ItemLike)(isNight ? Blocks.JACK_O_LANTERN : Blocks.PUMPKIN)) : this.getStackForChristmas(marbleType);
                Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.NONE, false, poseStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.NO_OVERLAY, Minecraft.getInstance().getItemRenderer().getModel(stack, null, null, 0));
            } else if (graveModel == GraveModel.TOMBSTONE) {
                poseStack.translate(-0.2f, isHalloween ? 0.65f : 0.74f, -0.2f);
                float scale = isHalloween ? 0.4f : 0.2f;
                poseStack.scale(scale, scale, scale);
                if (isHalloween) {
                    Block block = marbleType == BlockGraveMarble.MarbleType.DARK ? Blocks.LANTERN : Blocks.SOUL_LANTERN;
                    Minecraft.getInstance().getBlockRenderer().renderSingleBlock(block.defaultBlockState(), poseStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
                } else {
                    ItemStack stack = this.getStackForChristmas(marbleType);
                    Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.NONE, false, poseStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.NO_OVERLAY, Minecraft.getInstance().getItemRenderer().getModel(stack, null, null, 0));
                }
            } else {
                if (graveModel == GraveModel.SUBARAKI_GRAVE) {
                    poseStack.translate(isHalloween ? -0.35f : 0.0f, isHalloween ? 0.44f : 0.22f, -0.35f);
                } else if (graveModel == GraveModel.GRAVE_CROSS) {
                    poseStack.translate(0.2f, isHalloween ? 0.07f : 0.15f, -0.1f);
                } else {
                    poseStack.translate(isHalloween ? -0.575f : -0.34f, isHalloween ? 0.07f : 0.19f, -0.35f);
                }
                float scale = isHalloween ? 0.3f : 0.2f;
                poseStack.scale(scale, scale, scale);
                if (isHalloween) {
                    SkullBlockRenderer.renderSkull(null, (float)0.0f, (float)0.0f, (PoseStack)poseStack, (MultiBufferSource)iRenderTypeBuffer, (int)(isNight ? 0xF000F0 : light), (SkullModelBase)this.skullModels.get(SkullBlock.Types.SKELETON), (RenderType)RenderType.entityCutoutNoCullZOffset((ResourceLocation)TEXTURE_SKELETON_HEAD));
                } else {
                    ItemStack stack = this.getStackForChristmas(marbleType);
                    Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.NONE, false, poseStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.NO_OVERLAY, Minecraft.getInstance().getItemRenderer().getModel(stack, null, null, 0));
                }
            }
            poseStack.popPose();
        }
    }

    private ItemStack getStackForChristmas(BlockGraveMarble.MarbleType marbleType) {
        return new ItemStack((ItemLike)(marbleType == BlockGraveMarble.MarbleType.DARK ? ModItems.christmas_gift : ModItems.villager_gift));
    }

    private int getRotationIndex(Direction facing) {
        return switch (facing) {
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 1;
            case Direction.EAST -> 3;
            default -> 0;
        };
    }
}

