/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EvokerFangsModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.entity.SpectralBite;
import ovh.corail.tombstone.helper.Helper;

@OnlyIn(value=Dist.CLIENT)
public final class SpectralBiteRenderer
extends EntityRenderer<SpectralBite> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/illager/evoker_fangs.png");
    private final EvokerFangsModel<SpectralBite> model;

    public SpectralBiteRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new EvokerFangsModel(context.bakeLayer(ModelLayers.EVOKER_FANGS));
    }

    public void render(SpectralBite spectralBite, float p_114529_, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        float progress = spectralBite.getAnimationProgress(partialTicks);
        if (progress != 0.0f) {
            float f1 = 2.0f;
            if (progress > 0.9f) {
                f1 *= (1.0f - progress) / 0.1f;
            }
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f - spectralBite.getYRot()));
            poseStack.scale(-f1, -f1, f1);
            poseStack.translate(0.0, -0.626, 0.0);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            this.model.setupAnim((Entity)spectralBite, progress, 0.0f, 0.0f, spectralBite.getYRot(), spectralBite.getXRot());
            this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)TEXTURE_LOCATION)), 0xF000F0, OverlayTexture.NO_OVERLAY, Helper.convertColorToInt(0.3f, 0.5f, 1.0f, 1.0f));
            poseStack.popPose();
            super.render((Entity)spectralBite, p_114529_, partialTicks, poseStack, bufferSource, light);
        }
    }

    public ResourceLocation getTextureLocation(SpectralBite spectralBite) {
        return TEXTURE_LOCATION;
    }
}

