/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.client.screen;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivelib.client.screen.AbstractUpgradeableContainerScreen;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.util.FluidContainerUtil;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryControllerBlockEntity;
import cy.jdkdigital.productivemetalworks.common.datamap.FuelMap;
import cy.jdkdigital.productivemetalworks.common.menu.FoundryControllerContainer;
import cy.jdkdigital.productivemetalworks.network.MoveFoundryFluidData;
import cy.jdkdigital.productivemetalworks.recipe.ItemMeltingRecipe;
import cy.jdkdigital.productivemetalworks.registry.ModTags;
import cy.jdkdigital.productivemetalworks.util.CoilType;
import cy.jdkdigital.productivemetalworks.util.FluidHelper;
import cy.jdkdigital.productivemetalworks.util.RecipeHelper;
import cy.jdkdigital.productivemetalworks.util.TickingSlotInventoryHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class FoundryControllerScreen
extends AbstractUpgradeableContainerScreen<FoundryControllerContainer> {
    private static final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"textures/gui/container/foundry_controller.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/creative_inventory/scroller");
    private boolean isScrolling;
    private float scrollOffs;
    private int fuelTanks = 0;
    Map<Integer, Pair<Integer, Integer>> fluidPositions = new HashMap<Integer, Pair<Integer, Integer>>();

    public FoundryControllerScreen(FoundryControllerContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainer)container, inv, titleIn);
    }

    protected void init() {
        super.init();
        if (((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getMultiblockData() != null) {
            ((FoundryControllerContainer)this.menu).scrollTo(this.scrollOffs);
            this.fuelTanks = (int)((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getMultiblockData().peripherals().stream().filter(blockPos -> ((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getLevel().getBlockState(blockPos).is(ModTags.Blocks.FOUNDRY_TANKS)).count();
        }
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(GUI, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        IItemHandler iItemHandler = ((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getItemHandler();
        if (iItemHandler instanceof TickingSlotInventoryHandler) {
            TickingSlotInventoryHandler itemHandler = (TickingSlotInventoryHandler)iItemHandler;
            int rowIndex = ((FoundryControllerContainer)this.menu).getRowIndexForScroll(this.scrollOffs);
            int slotsAfterScroll = itemHandler.getSlots() - rowIndex * FoundryControllerContainer.COLUMNS;
            int rows = ((FoundryControllerContainer)this.menu).calculateRowCount(rowIndex);
            for (int row = 0; row < Math.min(3, rows); ++row) {
                for (int i = 0; i < FoundryControllerContainer.COLUMNS; ++i) {
                    int slot = row * FoundryControllerContainer.COLUMNS + rowIndex * FoundryControllerContainer.COLUMNS + i;
                    if (row * FoundryControllerContainer.COLUMNS + i >= slotsAfterScroll || slot >= itemHandler.getSlots() || !((Slot)((FoundryControllerContainer)this.menu).slots.get(slot)).isActive()) continue;
                    int slotX = this.getGuiLeft() + 79 + i * 18;
                    int slotY = this.getGuiTop() + 16 + row * 18;
                    guiGraphics.blit(GUI, slotX, slotY, 202, 0, 18, 18);
                    ItemStack stack = itemHandler.getStackInSlot(slot);
                    if (stack.isEmpty()) continue;
                    Pair<Integer, Integer> ticker = itemHandler.getTicker(slot);
                    if ((Integer)ticker.getSecond() != 0 && !((Integer)ticker.getFirst()).equals(ticker.getSecond())) {
                        int progress = (int)(18.0f - (float)((Integer)ticker.getFirst()).intValue() / (float)((Integer)ticker.getSecond()).intValue() * 18.0f);
                        guiGraphics.blit(GUI, slotX, slotY + (18 - progress), 202, 36 - progress, 18, progress);
                        continue;
                    }
                    guiGraphics.blit(GUI, slotX, slotY, 202, 36, 18, 18);
                }
            }
        }
        guiGraphics.blitSprite(SCROLLER_SPRITE, this.getGuiLeft() + 156, this.getGuiTop() + 17 + (int)(37.0f * this.scrollOffs), 12, 15);
        switch (((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getCoilType()) {
            case UNKNOWN: 
            case FLUID: {
                if (((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).fuel.isEmpty()) break;
                FluidContainerUtil.renderFluidTank((GuiGraphics)guiGraphics, (AbstractContainerScreen)this, (FluidStack)((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).fuel, (int)(this.fuelTanks * 4000), (int)57, (int)17, (int)16, (int)52);
                break;
            }
            case ENERGY: {
                if (((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getPowerMax() == 0) break;
                guiGraphics.blit(GUI, this.getGuiLeft() + 56, this.getGuiTop() + 14, 238, 0, 18, 56);
                float powerRatio = (float)((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getPower() / (float)((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getPowerMax();
                int energyLevel = (int)(52.0f * powerRatio + 0.5f);
                guiGraphics.blit(GUI, this.getGuiLeft() + 57, this.getGuiTop() + 17 + 52 - energyLevel, 239, 59, 16, energyLevel);
            }
        }
        int tankCapacity = ((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getFluidHandler().getCapacity();
        if (this.fluidPositions.size() != ((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getFluidHandler().getTanks()) {
            this.fluidPositions.clear();
        }
        int fluidCount = 0;
        for (int tank = 0; tank < ((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getFluidHandler().getTanks(); ++tank) {
            if (((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getFluidHandler().getFluidInTank(tank).isEmpty()) continue;
            ++fluidCount;
        }
        int tankHeight = 52;
        int fluidMinHeight = 4;
        int fluidMinAmount = tankCapacity / tankHeight * fluidMinHeight;
        int fluidMaxAmount = tankCapacity - (fluidCount * fluidMinAmount - fluidMinAmount);
        int nextFluidOffset = 0;
        for (int tank = 0; tank < ((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).fluidHandler.getTanks(); ++tank) {
            FluidStack fluidStack = ((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).fluidHandler.getFluidInTank(tank);
            if (fluidStack.isEmpty()) continue;
            int adjustedAmount = Math.max(Math.min(fluidMaxAmount, fluidStack.getAmount()), fluidMinAmount);
            double fluidHeight = Math.round((double)tankHeight * ((double)adjustedAmount / (double)tankCapacity));
            this.fluidPositions.put(tank, (Pair<Integer, Integer>)Pair.of((Object)nextFluidOffset, (Object)((int)fluidHeight)));
            FluidContainerUtil.renderTiledFluid((GuiGraphics)guiGraphics, (AbstractContainerScreen)this, (FluidStack)fluidStack, (int)8, (int)(69 - (int)fluidHeight - nextFluidOffset), (int)42, (int)((int)fluidHeight), (int)0);
            nextFluidOffset += (int)fluidHeight;
        }
    }

    @NotNull
    protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
        List tooltips = super.getTooltipFromContainerItem(stack);
        if (!stack.isEmpty()) {
            RecipeHolder<ItemMeltingRecipe> recipe;
            FuelMap fuelData;
            FoundryControllerBlockEntity.IMelterProcessor melter;
            switch (((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getCoilType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case UNKNOWN: {
                    FoundryControllerBlockEntity.IMelterProcessor iMelterProcessor = null;
                    break;
                }
                case FLUID: {
                    FoundryControllerBlockEntity.IMelterProcessor iMelterProcessor = new FoundryControllerBlockEntity.LiquidMelter();
                    break;
                }
                case ENERGY: {
                    FoundryControllerBlockEntity.IMelterProcessor iMelterProcessor = melter = new FoundryControllerBlockEntity.EnergyMelter();
                }
            }
            if (melter != null && (fuelData = melter.getFoundryFuel(((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getLevel(), (FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getFuelData()) != null && (recipe = RecipeHelper.getItemMeltingRecipe((Level)Minecraft.getInstance().level, stack, fuelData)) != null) {
                int speedModifier = ((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getSpeedModifier();
                int totalProducedFluid = ((ItemMeltingRecipe)recipe.value()).result.stream().map(FluidStack::getAmount).reduce(Integer::sum).orElse(0);
                int requiredFuel = (int)((float)totalProducedFluid * fuelData.consumption() * (float)speedModifier);
                boolean hasEnough = requiredFuel <= (((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getCoilType().equals((Object)CoilType.ENERGY) ? ((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getPower() : ((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getFuel().getAmount());
                tooltips.add(tooltips.size() - 1, Component.translatable((String)"gui.productivemetalworks.required_fuel", (Object[])new Object[]{requiredFuel + (((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getCoilType().equals((Object)CoilType.ENERGY) ? " FE" : " mb")}).withStyle(hasEnough ? ChatFormatting.GREEN : ChatFormatting.RED));
            }
        }
        return tooltips;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int tank;
        super.renderLabels(guiGraphics, mouseX, mouseY);
        ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
        if (this.insideFuelTank(mouseX, mouseY)) {
            FoundryControllerBlockEntity.IMelterProcessor melter = switch (((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getCoilType()) {
                default -> throw new MatchException(null, null);
                case CoilType.UNKNOWN -> null;
                case CoilType.FLUID -> new FoundryControllerBlockEntity.LiquidMelter();
                case CoilType.ENERGY -> new FoundryControllerBlockEntity.EnergyMelter();
            };
            switch (((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getCoilType()) {
                case FLUID: {
                    FuelMap fuelData;
                    if (((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).fuel.isEmpty()) break;
                    tooltipList.add(Component.literal((String)(((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).fuel.getAmount() + "mb " + Component.translatable((String)((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).fuel.getFluid().getFluidType().getDescriptionId()).getString())).getVisualOrderText());
                    if (melter == null || (fuelData = melter.getFoundryFuel(((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getLevel(), (FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getFuelData()) == null) break;
                    tooltipList.add(Component.translatable((String)"gui.productivemetalworks.temperature", (Object[])new Object[]{fuelData.temperature()}).getVisualOrderText());
                    break;
                }
                case ENERGY: {
                    FuelMap fuelData;
                    tooltipList.add(Component.literal((String)(((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getPower() + " FE")).getVisualOrderText());
                    if (melter == null || (fuelData = melter.getFoundryFuel(((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getLevel(), (FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getFuelData()) == null) break;
                    tooltipList.add(Component.translatable((String)"gui.productivemetalworks.temperature", (Object[])new Object[]{fuelData.temperature()}).getVisualOrderText());
                }
            }
        }
        if (this.insideTank(mouseX, mouseY) && (tank = this.getHoveredTank(mouseX, mouseY)) >= 0) {
            FluidStack fluidStack = ((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getFluidHandler().getFluidInTank(tank);
            tooltipList.add(Component.literal((String)(fluidStack.getAmount() + "mb " + Component.translatable((String)fluidStack.getFluid().getFluidType().getDescriptionId()).getString())).getVisualOrderText());
            tooltipList.addAll(FluidHelper.formatTooltip(fluidStack).stream().map(Component::getVisualOrderText).toList());
        }
        if (!tooltipList.isEmpty()) {
            guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.insideTank(mouseX, mouseY)) {
            int tank = this.getHoveredTank(mouseX, mouseY);
            PacketDistributor.sendToServer((CustomPacketPayload)new MoveFoundryFluidData(((FoundryControllerBlockEntity)((FoundryControllerContainer)this.menu).getBlockEntity()).getBlockPos(), tank), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        if (this.insideScrollbar(mouseX, mouseY)) {
            this.isScrolling = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            this.scrollOffs = ((float)mouseY - (float)this.getGuiTop() - 24.5f) / 37.0f;
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            ((FoundryControllerContainer)this.menu).scrollTo(this.scrollOffs);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.insideScrollbar(mouseX, mouseY) || this.insideContainer(mouseX, mouseY)) {
            this.scrollOffs = ((FoundryControllerContainer)this.menu).subtractInputFromScroll(this.scrollOffs, scrollY);
            ((FoundryControllerContainer)this.menu).scrollTo(this.scrollOffs);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private int getHoveredTank(double mouseX, double mouseY) {
        if (this.insideTank(mouseX, mouseY)) {
            for (Map.Entry<Integer, Pair<Integer, Integer>> entry : this.fluidPositions.entrySet()) {
                Pair<Integer, Integer> o = entry.getValue();
                if (!this.isHovering(8, 69 - (Integer)o.getFirst() - (Integer)o.getSecond(), 42, (Integer)o.getSecond(), mouseX, mouseY)) continue;
                return entry.getKey();
            }
        }
        return -1;
    }

    private boolean insideContainer(double mouseX, double mouseY) {
        return this.isHovering(80, 17, 88, 52, mouseX, mouseY);
    }

    private boolean insideFuelTank(double mouseX, double mouseY) {
        return this.isHovering(57, 17, 16, 52, mouseX, mouseY);
    }

    private boolean insideTank(double mouseX, double mouseY) {
        return this.isHovering(8, 17, 42, 52, mouseX, mouseY);
    }

    protected boolean insideScrollbar(double mouseX, double mouseY) {
        return this.isHovering(156, 17, 12, 52, mouseX, mouseY);
    }
}

