/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block.entity;

import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.IMultiBlockPeripheralBlockEntity;
import cy.jdkdigital.productivelib.util.MultiBlockDetector;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryControllerBlockEntity;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;

public class FoundryCapacitorBlockEntity
extends CapabilityBlockEntity
implements IMultiBlockPeripheralBlockEntity {
    private BlockPos controllerPosition;
    private int tickCounter = 0;
    public EnergyStorage energyHandler = new EnergyStorage(40000){

        public int receiveEnergy(int toReceive, boolean simulate) {
            int receivedEnergy = super.receiveEnergy(toReceive, simulate);
            if (receivedEnergy > 0 && FoundryCapacitorBlockEntity.this.level instanceof ServerLevel) {
                FoundryCapacitorBlockEntity.this.sync(FoundryCapacitorBlockEntity.this.level);
            }
            return receivedEnergy;
        }

        public int extractEnergy(int toExtract, boolean simulate) {
            int extractedEnergy = super.extractEnergy(toExtract, simulate);
            if (extractedEnergy > 0 && FoundryCapacitorBlockEntity.this.level instanceof ServerLevel) {
                FoundryCapacitorBlockEntity.this.sync(FoundryCapacitorBlockEntity.this.level);
            }
            return extractedEnergy;
        }
    };

    public FoundryCapacitorBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)MetalworksRegistrator.FOUNDRY_CAPACITOR_BLOCK_ENTITY.get(), pos, blockState);
    }

    public EnergyStorage getEnergyHandler() {
        return this.energyHandler;
    }

    public void setMultiblockController(BlockPos pos) {
        this.controllerPosition = pos;
    }

    public BlockPos getMultiblockController() {
        return this.controllerPosition;
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.controllerPosition != null) {
            tag.putLong("controller", this.controllerPosition.asLong());
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("controller")) {
            this.controllerPosition = BlockPos.of((long)tag.getLong("controller"));
        }
    }

    public void sync(Level level) {
        level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, FoundryCapacitorBlockEntity capacitorBlockEntity) {
        BlockEntity blockEntity;
        if (++capacitorBlockEntity.tickCounter % 5 == 0 && capacitorBlockEntity.getMultiblockController() != null && (blockEntity = level.getBlockEntity(capacitorBlockEntity.getMultiblockController())) instanceof FoundryControllerBlockEntity) {
            FoundryControllerBlockEntity controllerBlockEntity = (FoundryControllerBlockEntity)blockEntity;
            capacitorBlockEntity.tickCounter = 0;
            MultiBlockDetector.MultiBlockData mb = controllerBlockEntity.getMultiblockData();
            if (mb != null) {
                mb.peripherals().forEach(pos -> {
                    BlockEntity patt0$temp;
                    if (!pos.equals((Object)capacitorBlockEntity.getBlockPos()) && (patt0$temp = level.getBlockEntity(pos)) instanceof FoundryCapacitorBlockEntity) {
                        FoundryCapacitorBlockEntity otherCapacitor = (FoundryCapacitorBlockEntity)patt0$temp;
                        int energyDiff = capacitorBlockEntity.getEnergyHandler().getEnergyStored() - otherCapacitor.getEnergyHandler().getEnergyStored();
                        if (energyDiff > 0) {
                            int transferred = otherCapacitor.getEnergyHandler().receiveEnergy((int)Math.ceil((double)energyDiff / 2.0), false);
                            capacitorBlockEntity.getEnergyHandler().extractEnergy(transferred, false);
                        }
                    }
                });
            }
        }
    }
}

