/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.pricklemc.common.api.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberUtils {
    public static boolean greaterThan(Number x, Number y) {
        return NumberUtils.compareNumber(x, y) == 1;
    }

    public static boolean equals(Number x, Number y) {
        return NumberUtils.compareNumber(x, y) == 0;
    }

    public static boolean lessThan(Number x, Number y) {
        return NumberUtils.compareNumber(x, y) == -1;
    }

    public static int compareNumber(Number x, Number y) {
        return NumberUtils.isSpecialNumber(x) || NumberUtils.isSpecialNumber(y) ? Double.compare(x.doubleValue(), y.doubleValue()) : NumberUtils.asBigDecimal(x).compareTo(NumberUtils.asBigDecimal(y));
    }

    public static boolean isSpecialNumber(Number number) {
        Float floatVal;
        Double doubleVal;
        boolean specialDouble = number instanceof Double && (Double.isNaN(doubleVal = (Double)number) || Double.isInfinite(doubleVal));
        boolean specialFloat = number instanceof Float && (Float.isNaN((floatVal = (Float)number).floatValue()) || Float.isInfinite(floatVal.floatValue()));
        return specialDouble || specialFloat;
    }

    public static BigDecimal asBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            BigDecimal decimalVal = (BigDecimal)number;
            return decimalVal;
        }
        if (number instanceof BigInteger) {
            BigInteger bigInt = (BigInteger)number;
            return new BigDecimal(bigInt);
        }
        if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        if (number instanceof Float || number instanceof Double) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        try {
            return new BigDecimal(number.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The number '" + String.valueOf(number) + "' of class " + number.getClass().getName() + " is not supported.");
        }
    }
}

