/*
 * Decompiled with CFR 0.152.
 */
package systems.alexander.bellsandwhistles.block.custom;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.decoration.copycat.CopycatPanelBlock;
import com.simibubi.create.content.decoration.copycat.CopycatSpecialCases;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import systems.alexander.bellsandwhistles.block.ModBlocks;

public class PanelBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    protected static final int AABB_THICKNESS = 3;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public PanelBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos) {
        return Blocks.MOSSY_COBBLESTONE.defaultBlockState();
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return ((Direction)state.getValue((Property)FACING)).getOpposite() == face;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return this.canFaceBeOccluded(state, face.getOpposite());
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.getStateForPlacement(pContext);
        return (BlockState)stateForPlacement.setValue((Property)FACING, (Comparable)pContext.getNearestLookingDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACING}));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (state.is((Block)this) == neighborState.is((Block)this)) {
            if (CopycatSpecialCases.isBarsMaterial((BlockState)PanelBlock.getMaterial(level, pos)) && CopycatSpecialCases.isBarsMaterial((BlockState)PanelBlock.getMaterial(level, pos.relative(dir)))) {
                return state.getValue((Property)FACING) == neighborState.getValue((Property)FACING);
            }
            if (PanelBlock.getMaterial(level, pos).skipRendering(PanelBlock.getMaterial(level, pos.relative(dir)), dir.getOpposite())) {
                return PanelBlock.isOccluded(state, neighborState, dir.getOpposite());
            }
        }
        return state.getValue((Property)FACING) == dir.getOpposite() && PanelBlock.getMaterial(level, pos).skipRendering(neighborState, dir.getOpposite());
    }

    public static boolean isOccluded(BlockState state, BlockState other, Direction pDirection) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (facing.getOpposite() == other.getValue((Property)FACING) && pDirection == facing) {
            return true;
        }
        if (other.getValue((Property)FACING) != facing) {
            return false;
        }
        return pDirection.getAxis() != facing.getAxis();
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.CASING_3PX.get((Direction)pState.getValue((Property)FACING));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return itemStack -> itemStack.getItem() == ModBlocks.METRO_PANEL.asItem();
        }

        public Predicate<BlockState> getStatePredicate() {
            return blockState -> blockState.is(ModBlocks.METRO_PANEL);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)((Direction)state.getValue((Property)CopycatPanelBlock.FACING)).getAxis(), dir -> world.getBlockState(pos.relative(dir)).canBeReplaced());
            return directions.isEmpty() ? PlacementOffset.fail() : PlacementOffset.success((Vec3i)pos.relative((Direction)directions.get(0)), s -> (BlockState)s.setValue((Property)CopycatPanelBlock.FACING, (Comparable)((Direction)state.getValue((Property)CopycatPanelBlock.FACING))));
        }
    }
}

