/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.DynamicTreesHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SnowUnderTreesFeature
extends Feature<NoneFeatureConfiguration> {
    public SnowUnderTreesFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        BlockPos pos = ctx.origin();
        WorldGenLevel level = ctx.level();
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int xi = 0; xi < 16; ++xi) {
            for (int zi = 0; zi < 16; ++zi) {
                BlockPos groundPos;
                int x = pos.getX() + xi;
                int z = pos.getZ() + zi;
                mPos.set(x, level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z) - 1, z);
                if (!level.getBlockState((BlockPos)mPos).is(BlockTags.LEAVES)) continue;
                mPos.set(x, level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z), z);
                if (SnowUnderTrees.isDynamicTreesLoaded() && (groundPos = DynamicTreesHandler.findGround(level, mPos)) == null) {
                    return false;
                }
                if (!SnowUnderTrees.placeSnow(level, (BlockPos)mPos)) continue;
                mPos.move(Direction.DOWN);
                BlockState stateBelow = level.getBlockState((BlockPos)mPos);
                if (!stateBelow.hasProperty((Property)SnowyDirtBlock.SNOWY)) continue;
                level.setBlock((BlockPos)mPos, (BlockState)stateBelow.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return true;
    }
}

