/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib.toml;

import com.supermartijn642.configlib.ConfigFile;
import com.supermartijn642.configlib.ConfigLib;
import com.supermartijn642.configlib.toml.TomlDeserializer;
import com.supermartijn642.configlib.toml.TomlElement;
import com.supermartijn642.configlib.toml.TomlSerializer;
import com.supermartijn642.configlib.toml.TomlTable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class TomlConfigFile
implements ConfigFile<TomlElement> {
    private final File file;
    private TomlTable table = new TomlTable();
    private boolean tracking = false;

    public TomlConfigFile(File file) {
        this.file = file;
    }

    public TomlElement get(String[] path) {
        if (path.length == 0) {
            return this.table;
        }
        TomlTable object = this.table;
        for (int i = 0; i < path.length - 1; ++i) {
            TomlElement member = object.get(path[i]);
            if (member == null || !member.isTable()) {
                return null;
            }
            object = member.getAsTable();
        }
        return object.get(path[path.length - 1]);
    }

    private void set(String[] path, TomlElement element) {
        TomlTable object = this.table;
        for (int i = 0; i < path.length - 1; ++i) {
            TomlElement member = object.get(path[i]);
            if (member == null || !member.isTable()) {
                TomlTable newObject = new TomlTable();
                if (member != null) {
                    newObject.comment = member.comment;
                    newObject.valueHint = member.valueHint;
                }
                object.add(path[i], newObject);
                object = newObject;
                continue;
            }
            object = member.getAsTable();
        }
        TomlElement oldElement = object.get(path[path.length - 1]);
        String comment = oldElement == null ? null : oldElement.comment;
        String hint = oldElement == null ? null : oldElement.valueHint;
        element.comment = comment;
        element.valueHint = hint;
        object.add(path[path.length - 1], element);
    }

    @Override
    public void setValue(String[] path, TomlElement value) {
        this.set(path, value);
    }

    @Override
    public TomlElement getValue(String[] path) {
        return this.get(path);
    }

    @Override
    public void setComment(String[] path, String comment) {
        TomlElement element = this.get(path);
        if (element != null) {
            element.comment = comment;
        } else {
            TomlElement emptyElement = TomlElement.empty();
            this.set(path, emptyElement);
            emptyElement.comment = comment;
        }
    }

    @Override
    public void setAllowedValuesHint(String[] path, String hint) {
        TomlElement element = this.get(path);
        if (element != null) {
            element.valueHint = hint;
        } else {
            TomlElement emptyElement = TomlElement.empty();
            this.set(path, emptyElement);
            emptyElement.valueHint = hint;
        }
    }

    @Override
    public void clearValues() {
        this.table = new TomlTable();
    }

    @Override
    public void startTrackingFile() {
        WatchService watchService;
        if (this.tracking) {
            throw new IllegalStateException("Config file is already being tracked!");
        }
        Path parentPath = this.file.getParentFile().toPath();
        try {
            watchService = parentPath.getFileSystem().newWatchService();
            parentPath.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (Exception e) {
            ConfigLib.LOGGER.error("Failed to create watch service for config file!", (Throwable)e);
            return;
        }
        this.tracking = true;
        Thread watchThread = new Thread(() -> {
            while (true) {
                WatchKey watchKey;
                try {
                    watchKey = watchService.take();
                }
                catch (Exception e) {
                    this.tracking = false;
                    break;
                }
                for (WatchEvent<?> pollEvent : watchKey.pollEvents()) {
                    Path path = (Path)pollEvent.context();
                    if (!this.file.getName().equals(path.toString())) continue;
                    this.readFile();
                    break;
                }
                watchKey.reset();
            }
        }, "Config Lib config file watcher");
        watchThread.setDaemon(true);
        watchThread.start();
    }

    @Override
    public void readFile() {
        if (!this.file.exists() || this.file.isDirectory()) {
            this.table = new TomlTable();
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
            this.table = TomlDeserializer.readTomlTable(reader);
        }
        catch (Exception e) {
            ConfigLib.LOGGER.error("Failed to read toml file '" + this.file.getPath() + "'!", (Throwable)e);
            this.table = new TomlTable();
        }
    }

    @Override
    public void writeFile() {
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));){
            TomlSerializer.writeTomlTable(writer, this.table);
        }
        catch (Exception e) {
            ConfigLib.LOGGER.error("Failed to write toml file '" + this.file.getPath() + "'!", (Throwable)e);
        }
    }
}

