/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.modifiers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_attributes.modifiers.EntityEquipmentSlot;
import dev.shadowsoffire.apothic_attributes.modifiers.EntitySlotGroup;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import org.jetbrains.annotations.Nullable;

public class EquipmentSlotCompat {
    private static final BiMap<EquipmentSlot, Holder<EntityEquipmentSlot>> SLOT_MAP = (BiMap)Util.make((Object)HashBiMap.create((int)7), map -> {
        map.put((Object)EquipmentSlot.MAINHAND, ALObjects.EquipmentSlots.MAINHAND);
        map.put((Object)EquipmentSlot.OFFHAND, ALObjects.EquipmentSlots.OFFHAND);
        map.put((Object)EquipmentSlot.HEAD, ALObjects.EquipmentSlots.HEAD);
        map.put((Object)EquipmentSlot.CHEST, ALObjects.EquipmentSlots.CHEST);
        map.put((Object)EquipmentSlot.LEGS, ALObjects.EquipmentSlots.LEGS);
        map.put((Object)EquipmentSlot.FEET, ALObjects.EquipmentSlots.FEET);
        map.put((Object)EquipmentSlot.BODY, ALObjects.EquipmentSlots.BODY);
    });
    private static final BiMap<EquipmentSlotGroup, EntitySlotGroup> GROUP_MAP = (BiMap)Util.make((Object)HashBiMap.create((int)10), map -> {
        map.put((Object)EquipmentSlotGroup.ANY, (Object)ALObjects.EquipmentSlotGroups.ANY_VANILLA);
        map.put((Object)EquipmentSlotGroup.MAINHAND, (Object)ALObjects.EquipmentSlotGroups.MAINHAND);
        map.put((Object)EquipmentSlotGroup.OFFHAND, (Object)ALObjects.EquipmentSlotGroups.OFFHAND);
        map.put((Object)EquipmentSlotGroup.HAND, (Object)ALObjects.EquipmentSlotGroups.HAND);
        map.put((Object)EquipmentSlotGroup.HEAD, (Object)ALObjects.EquipmentSlotGroups.HEAD);
        map.put((Object)EquipmentSlotGroup.CHEST, (Object)ALObjects.EquipmentSlotGroups.CHEST);
        map.put((Object)EquipmentSlotGroup.LEGS, (Object)ALObjects.EquipmentSlotGroups.LEGS);
        map.put((Object)EquipmentSlotGroup.FEET, (Object)ALObjects.EquipmentSlotGroups.FEET);
        map.put((Object)EquipmentSlotGroup.ARMOR, (Object)ALObjects.EquipmentSlotGroups.ARMOR);
        map.put((Object)EquipmentSlotGroup.BODY, (Object)ALObjects.EquipmentSlotGroups.BODY);
    });

    @Nullable
    public static EquipmentSlot toVanilla(Holder<EntityEquipmentSlot> slot) {
        return (EquipmentSlot)SLOT_MAP.inverse().get(slot);
    }

    @Nullable
    public static Holder<EntityEquipmentSlot> fromVanilla(EquipmentSlot slot) {
        return (Holder)SLOT_MAP.get((Object)slot);
    }

    @Nullable
    public static EquipmentSlotGroup toVanilla(EntitySlotGroup group) {
        if (group == ALObjects.EquipmentSlotGroups.ANY) {
            return EquipmentSlotGroup.ANY;
        }
        return (EquipmentSlotGroup)GROUP_MAP.inverse().get((Object)group);
    }

    @Nullable
    public static EntitySlotGroup fromVanilla(EquipmentSlotGroup group) {
        return (EntitySlotGroup)GROUP_MAP.get((Object)group);
    }
}

