/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public class AuxDmgTracker {
    public static final Codec<AuxDmgTracker> CODEC = Codec.unboundedMap((Codec)ResourceKey.codec((ResourceKey)Registries.DAMAGE_TYPE), Entry.CODEC).xmap(AuxDmgTracker::new, tracker -> tracker.data);
    private final IdentityHashMap<ResourceKey<DamageType>, Entry> data = new IdentityHashMap(3);
    private transient int origInvulTime = 0;
    private transient float origLastHurt = 0.0f;
    private static final Marker MARKER = MarkerManager.getMarker((String)AuxDmgTracker.class.getSimpleName());

    public AuxDmgTracker() {
    }

    public AuxDmgTracker(Map<ResourceKey<DamageType>, Entry> data) {
        this.data.putAll(data);
    }

    public static void executeWith(LivingEntity entity, Consumer<AuxDmgTracker> consumer) {
        AuxDmgTracker tracker = (AuxDmgTracker)entity.getData(ALObjects.Attachments.AUX_DMG_TRACKER);
        tracker.start(entity);
        try {
            consumer.accept(tracker);
        }
        finally {
            tracker.end(entity);
        }
    }

    public boolean attackWith(LivingEntity attacker, LivingEntity target, ResourceKey<DamageType> type, Holder<Attribute> attribute, @Nullable PostAttackEffect callback) {
        float damage = (float)attacker.getAttributeValue(attribute);
        return this.attackWith(attacker, target, type, damage, callback);
    }

    public boolean attackWith(LivingEntity attacker, LivingEntity target, ResourceKey<DamageType> type, float damage, @Nullable PostAttackEffect callback) {
        float atkStrength = ApothicAttributes.getLocalAtkStrength((Entity)attacker);
        AuxDmgTracker.debugLog("Attacking {} with {}: damage = {}, atkStrength = {}", target, type.location(), Float.valueOf(damage), Float.valueOf(atkStrength));
        if ((double)damage > 0.001 && atkStrength >= 0.55f && !target.isDeadOrDying()) {
            this.setup(target, type);
            float dmg = AuxDmgTracker.modifyDamage(attacker, target, atkStrength * damage);
            float health = target.getHealth();
            if (target.hurt(AuxDmgTracker.src(type, attacker), dmg)) {
                float delta = health - target.getHealth();
                AuxDmgTracker.debugLog("Attack successful: {} -> {}: type = {}, damage = {}, atkStrength = {}", attacker, target, type.location(), Float.valueOf(dmg), Float.valueOf(atkStrength));
                if (callback != null) {
                    callback.apply(attacker, target, AuxDmgTracker.src(type, attacker), dmg, delta);
                }
                this.record(target, type);
                return true;
            }
        }
        AuxDmgTracker.debugLog("Skipping attack: damage = {}, atkStrength = {}, target.isDeadOrDying() = {}", Float.valueOf(damage), Float.valueOf(atkStrength), target.isDeadOrDying());
        return false;
    }

    public void start(LivingEntity entity) {
        this.origInvulTime = entity.invulnerableTime;
        this.origLastHurt = entity.lastHurt;
        AuxDmgTracker.debugLog("Starting aux damage pipeline for {}: invulTime = {}, lastHurt = {}", entity, this.origInvulTime, Float.valueOf(this.origLastHurt));
    }

    public void setup(LivingEntity entity, ResourceKey<DamageType> type) {
        Entry entry = this.getData(type);
        entity.invulnerableTime = entry.time();
        entity.lastHurt = entry.lastHurt();
        AuxDmgTracker.debugLog("Setup values for {} / {}: invulTime = {}, lastHurt = {}", entity, type.location(), entry.time(), Float.valueOf(entry.lastHurt()));
    }

    public void record(LivingEntity entity, ResourceKey<DamageType> type) {
        Entry entry = new Entry(entity.invulnerableTime, entity.lastHurt);
        this.data.put(type, entry);
        AuxDmgTracker.debugLog("Recorded values for {} / {}: invulTime = {}, lastHurt = {}", entity, type.location(), entry.time(), Float.valueOf(entry.lastHurt()));
    }

    public void end(LivingEntity entity) {
        entity.invulnerableTime = this.origInvulTime;
        entity.lastHurt = this.origLastHurt;
        AuxDmgTracker.debugLog("Ending aux damage pipeline for {}: invulTime = {}, lastHurt = {}", entity, this.origInvulTime, Float.valueOf(this.origLastHurt));
    }

    public void tick() {
        this.data.values().forEach(entry -> {
            if (entry.time > 0) {
                --entry.time;
            }
        });
    }

    public Entry getData(ResourceKey<DamageType> type) {
        return this.data.getOrDefault(type, Entry.DEFAULT);
    }

    private static DamageSource src(ResourceKey<DamageType> type, LivingEntity entity) {
        return entity.level().damageSources().source(type, (Entity)entity);
    }

    private static float modifyDamage(LivingEntity attacker, LivingEntity target, float damage) {
        if (target.getPersistentData().getBoolean("apoth.hit_by_sweep_attack") && attacker.getAttributes().hasAttribute(Attributes.SWEEPING_DAMAGE_RATIO)) {
            float realDmg = Math.min(damage, 1.0f + (float)attacker.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * damage);
            AuxDmgTracker.debugLog("Sweep attack detected. Modifying damage for {} from {} to {}.", attacker, Float.valueOf(damage), Float.valueOf(realDmg));
            return realDmg;
        }
        return damage;
    }

    private static void debugLog(String msg, Object ... args) {
        if (ApothicAttributes.DEBUG_AUX_DMG) {
            ApothicAttributes.LOGGER.debug(MARKER, msg, args);
        }
    }

    public static interface PostAttackEffect {
        public void apply(LivingEntity var1, LivingEntity var2, DamageSource var3, float var4, float var5);
    }

    public static class Entry {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("time").forGetter(Entry::time), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("lastHurt").forGetter(Entry::lastHurt)).apply((Applicative)inst, Entry::new));
        public static final Entry DEFAULT = new Entry(0, 0.0f);
        protected int time;
        protected final float lastHurt;

        public Entry(int time, float lastHurt) {
            this.time = Math.max(0, time);
            this.lastHurt = Math.max(0.0f, lastHurt);
        }

        public int time() {
            return this.time;
        }

        public float lastHurt() {
            return this.lastHurt;
        }
    }
}

