/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock.matcher;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TagMatcher
implements StateMatcher {
    public static final ResourceLocation TYPE = Modonomicon.loc("tag");
    private final BlockState displayState;
    private final java.util.function.Supplier<TagKey<Block>> tag;
    private final java.util.function.Supplier<Map<String, String>> props;
    private final TriPredicate<BlockGetter, BlockPos, BlockState> predicate;

    protected TagMatcher(java.util.function.Supplier<TagKey<Block>> tag, java.util.function.Supplier<Map<String, String>> props) {
        this(null, tag, props);
    }

    protected TagMatcher(BlockState displayState, java.util.function.Supplier<TagKey<Block>> tag, java.util.function.Supplier<Map<String, String>> props) {
        this.displayState = displayState;
        this.tag = tag;
        this.props = props;
        this.predicate = (blockGetter, blockPos, blockState) -> blockState.is(this.tag.get()) && TagMatcher.checkProps(blockState, this.props);
    }

    public static TagMatcher fromJson(JsonObject json, HolderLookup.Provider provider) {
        Object tagString;
        BlockState displayState = null;
        if (json.has("display")) {
            try {
                displayState = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(GsonHelper.getAsString((JsonObject)json, (String)"display")), (boolean)false).blockState();
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for TagStateMatcher.", e);
            }
        }
        if (!((String)(tagString = GsonHelper.getAsString((JsonObject)json, (String)"tag"))).startsWith("#")) {
            tagString = "#" + (String)tagString;
        }
        String finalTagString = tagString;
        Supplier tagSupplier = Suppliers.memoize(() -> {
            try {
                BlockStateParser.TagResult parserResult = (BlockStateParser.TagResult)BlockStateParser.parseForTesting((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(finalTagString), (boolean)true).right().orElseThrow();
                return (TagKey)parserResult.tag().unwrap().left().orElseThrow();
            }
            catch (CommandSyntaxException e) {
                Modonomicon.LOG.error("Failed to parse Tag and BlockState properties from json member \"tag\" for TagMatcher: {0}. Will use \"modonomicon:bedrock\" as fallback, Exception: {1}", (Object)finalTagString, (Object)e);
                return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Modonomicon.loc("bedrock"));
            }
        });
        Supplier propsSupplier = Suppliers.memoize(() -> {
            try {
                BlockStateParser.TagResult parserResult = (BlockStateParser.TagResult)BlockStateParser.parseForTesting((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(finalTagString), (boolean)true).right().orElseThrow();
                return parserResult.vagueProperties();
            }
            catch (CommandSyntaxException e) {
                Modonomicon.LOG.error("Failed to parse Tag and BlockState properties from json member \"tag\" for TagMatcher: {0}. Will use empty property map as fallback, Exception: {1}", (Object)finalTagString, (Object)e);
                return Map.of();
            }
        });
        return new TagMatcher(displayState, (java.util.function.Supplier<TagKey<Block>>)tagSupplier, (java.util.function.Supplier<Map<String, String>>)propsSupplier);
    }

    public static TagMatcher fromNetwork(FriendlyByteBuf buffer) {
        try {
            BlockState displayState = null;
            if (buffer.readBoolean()) {
                displayState = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(buffer.readUtf()), (boolean)false).blockState();
            }
            TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)buffer.readResourceLocation());
            Map props = buffer.readMap(b -> b.readUtf(), b -> b.readUtf());
            return new TagMatcher(displayState, () -> tag, () -> props);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse TagMatcher from network.", e);
        }
    }

    public static boolean checkProps(BlockState state, java.util.function.Supplier<Map<String, String>> props) {
        for (Map.Entry<String, String> entry : props.get().entrySet()) {
            Property prop = state.getBlock().getStateDefinition().getProperty(entry.getKey());
            if (prop == null) {
                return false;
            }
            Comparable value = prop.getValue(entry.getValue()).orElse(null);
            if (value == null) {
                return false;
            }
            if (state.getValue(prop).equals(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public BlockState getDisplayedState(long ticks) {
        if (this.displayState != null) {
            return this.displayState;
        }
        ImmutableList all = ImmutableList.copyOf((Iterable)BuiltInRegistries.BLOCK.getTagOrEmpty(this.tag.get()));
        if (all.isEmpty()) {
            return Blocks.BEDROCK.defaultBlockState();
        }
        int idx = (int)(ticks / 20L % (long)all.size());
        return ((Block)((Holder)all.get(idx)).value()).defaultBlockState();
    }

    @Override
    public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
        return this.predicate;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.displayState != null);
        if (this.displayState != null) {
            buffer.writeUtf(BlockStateParser.serialize((BlockState)this.displayState));
        }
        buffer.writeResourceLocation(this.tag.get().location());
        buffer.writeMap(this.props.get(), (b, v) -> b.writeUtf(v), (b, v) -> b.writeUtf(v));
    }

    @Override
    public boolean countsTowardsTotalBlocks() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.props, this.displayState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagMatcher that = (TagMatcher)o;
        return this.tag.equals(that.tag) && this.props.equals(that.props) && this.displayState.equals(that.displayState);
    }
}

