/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.jei.common;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

class ResourceGhostIngredientHandler
implements IGhostIngredientHandler<AbstractBaseScreen> {
    ResourceGhostIngredientHandler() {
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(AbstractBaseScreen screen, ITypedIngredient<I> ingredient, boolean doStart) {
        AbstractContainerMenu abstractContainerMenu = screen.getMenu();
        if (abstractContainerMenu instanceof AbstractResourceContainerMenu) {
            AbstractResourceContainerMenu resourceMenu = (AbstractResourceContainerMenu)abstractContainerMenu;
            ArrayList targets = new ArrayList();
            RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResource(ingredient.getIngredient()).ifPresent(resource -> {
                for (ResourceSlot slot : resourceMenu.getResourceSlots()) {
                    if (!slot.isActive() || !slot.isFilter() || !slot.isValid((ResourceKey)resource)) continue;
                    Rect2i bounds = ResourceGhostIngredientHandler.getBounds(screen, (Slot)slot);
                    targets.add(new TargetImpl(bounds, slot.index));
                }
            });
            return targets;
        }
        return Collections.emptyList();
    }

    private static Rect2i getBounds(AbstractBaseScreen screen, Slot slot) {
        return new Rect2i(screen.getLeftPos() + slot.x, screen.getTopPos() + slot.y, 17, 17);
    }

    public void onComplete() {
    }

    private static class TargetImpl<I>
    implements IGhostIngredientHandler.Target<I> {
        private final Rect2i area;
        private final int slotIndex;

        TargetImpl(Rect2i area, int slotIndex) {
            this.area = area;
            this.slotIndex = slotIndex;
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResource(ingredient).ifPresent(convertedResource -> C2SPackets.sendResourceFilterSlotChange((PlatformResourceKey)convertedResource, (int)this.slotIndex));
        }
    }
}

