/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.watut.InventorySnapshot;
import com.corosus.watut.WatutMod;
import com.corosus.watut.client.screen.ScreenData;
import com.corosus.watut.math.Lerpables;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class PlayerStatus {
    private PlayerGuiState playerGuiState;
    private boolean playerGuiDontSendDetailedGUIInfo;
    private boolean playerGuiDontSendItemInfo;
    private PlayerChatState playerChatState;
    private float typingAmplifier = 1.0f;
    private float screenPosPercentX = 0.0f;
    private float screenPosPercentY = 0.0f;
    private boolean isPressing = false;
    private int ticksSinceLastAction = 0;
    private int ticksToMarkPlayerIdleSyncedForClient = 6000;
    private Particle particle;
    private Particle particleIdle;
    private long lastTypeTime;
    private String lastTypeString = "";
    private boolean flagForRemoval = false;
    private long lastTypeTimeForAmp;
    private String lastTypeStringForAmp = "";
    private int lastTypeDiff;
    private Lerpables lerpTarget = new Lerpables();
    private Lerpables lerpPrev = new Lerpables();
    public float lerpTicks = 0.0f;
    public float lerpTicksPrev = 0.0f;
    public float lerpTicksMax = 5.0f;
    public float lastPartialTick = 0.0f;
    public float yRotHeadWhileOverriding = 0.0f;
    public float xRotHeadWhileOverriding = 0.0f;
    public float yRotHeadBeforeOverriding = 0.0f;
    public float xRotHeadBeforeOverriding = 0.0f;
    private float typingAmplifierSmooth = 0.5f;
    private CompoundTag nbtCache = new CompoundTag();
    private ScreenData screenData;
    private BlockPos lastBlockOpened = BlockPos.ZERO;
    private InventorySnapshot inventorySnapshotPlayer = new InventorySnapshot();
    private InventorySnapshot inventorySnapshotContainer = new InventorySnapshot();
    private InventorySnapshot inventorySnapshotCarried = new InventorySnapshot();
    private boolean isCarriedItemFromPlayerInventory = false;
    private UUID uuid = null;

    public PlayerStatus(PlayerGuiState playerGuiState, UUID uuid) {
        this.playerGuiState = playerGuiState;
        this.uuid = uuid;
    }

    public void tick() {
        this.lerpTicksPrev = this.lerpTicks;
        if (this.isLerping()) {
            this.lerpTicks += 1.0f;
        }
    }

    public void setNewLerp(float ticks) {
        this.lerpTicksMax = ticks;
        this.lerpTicks = 0.0f;
        this.lerpTicksPrev = 0.0f;
    }

    public float getPartialLerp(float partialTick) {
        float lerpPrev = this.lerpTicksPrev / this.lerpTicksMax;
        float lerp = this.lerpTicks / this.lerpTicksMax;
        return Math.min(lerpPrev + (lerp - lerpPrev) * partialTick, this.lerpTicksMax);
    }

    public void resetParticles() {
        if (this.particle != null) {
            this.particle.remove();
        }
        if (this.particleIdle != null) {
            this.particleIdle.remove();
        }
        this.particle = null;
        this.particleIdle = null;
    }

    public void reset() {
        this.resetParticles();
        WatutMod.dbg("remove trigger for " + String.valueOf(this));
        this.ticksSinceLastAction = 0;
    }

    public boolean isLerping() {
        return this.lerpTicks < this.lerpTicksMax;
    }

    public PlayerGuiState getPlayerGuiState() {
        return this.playerGuiState;
    }

    public void setPlayerGuiState(PlayerGuiState playerGuiState) {
        this.playerGuiState = playerGuiState;
    }

    public boolean isPlayerGuiDontSendDetailedGUIInfo() {
        return this.playerGuiDontSendDetailedGUIInfo;
    }

    public void setPlayerGuiDontSendDetailedGUIInfo(boolean playerGuiDontSendDetailedGUIInfo) {
        this.playerGuiDontSendDetailedGUIInfo = playerGuiDontSendDetailedGUIInfo;
    }

    public boolean isPlayerGuiDontSendItemInfo() {
        return this.playerGuiDontSendItemInfo;
    }

    public void setPlayerGuiDontSendItemInfo(boolean playerGuiDontSendItemInfo) {
        this.playerGuiDontSendItemInfo = playerGuiDontSendItemInfo;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    public long getLastTypeTime() {
        return this.lastTypeTime;
    }

    public void setLastTypeTime(long lastTypeTime) {
        this.lastTypeTime = lastTypeTime;
    }

    public String getLastTypeString() {
        return this.lastTypeString;
    }

    public void setLastTypeString(String lastTypeString) {
        this.lastTypeString = lastTypeString;
    }

    public float getScreenPosPercentX() {
        return this.screenPosPercentX;
    }

    public void setScreenPosPercentX(float screenPosPercentX) {
        this.screenPosPercentX = screenPosPercentX;
    }

    public float getScreenPosPercentY() {
        return this.screenPosPercentY;
    }

    public void setScreenPosPercentY(float screenPosPercentY) {
        this.screenPosPercentY = screenPosPercentY;
    }

    public Lerpables getLerpTarget() {
        return this.lerpTarget;
    }

    public void setLerpTarget(Lerpables lerpTarget) {
        this.lerpTarget = lerpTarget;
    }

    public Lerpables getLerpPrev() {
        return this.lerpPrev;
    }

    public void setLerpPrev(Lerpables lerpPrev) {
        this.lerpPrev = lerpPrev;
    }

    public boolean isPressing() {
        return this.isPressing;
    }

    public void setPressing(boolean pressing) {
        this.isPressing = pressing;
    }

    public float getTypingAmplifier() {
        return this.typingAmplifier;
    }

    public void setTypingAmplifier(float typingAmplifier) {
        this.typingAmplifier = typingAmplifier;
    }

    public int getLastTypeDiff() {
        return this.lastTypeDiff;
    }

    public void setLastTypeDiff(int lastTypeDiff) {
        this.lastTypeDiff = lastTypeDiff;
    }

    public long getLastTypeTimeForAmp() {
        return this.lastTypeTimeForAmp;
    }

    public void setLastTypeTimeForAmp(long lastTypeTimeForAmp) {
        this.lastTypeTimeForAmp = lastTypeTimeForAmp;
    }

    public String getLastTypeStringForAmp() {
        return this.lastTypeStringForAmp;
    }

    public void setLastTypeStringForAmp(String lastTypeStringForAmp) {
        this.lastTypeStringForAmp = lastTypeStringForAmp;
    }

    public int getTicksSinceLastAction() {
        return this.ticksSinceLastAction;
    }

    public void setTicksSinceLastAction(int ticksSinceLastAction) {
        this.ticksSinceLastAction = ticksSinceLastAction;
    }

    public float getTypingAmplifierSmooth() {
        return this.typingAmplifierSmooth;
    }

    public void setTypingAmplifierSmooth(float typingAmplifierSmooth) {
        this.typingAmplifierSmooth = typingAmplifierSmooth;
    }

    public boolean isFlagForRemoval() {
        return this.flagForRemoval;
    }

    public void setFlagForRemoval(boolean flagForRemoval) {
        this.flagForRemoval = flagForRemoval;
    }

    public Particle getParticleIdle() {
        return this.particleIdle;
    }

    public void setParticleIdle(Particle particleIdle) {
        this.particleIdle = particleIdle;
    }

    public boolean isIdle() {
        return this.ticksSinceLastAction > this.ticksToMarkPlayerIdleSyncedForClient;
    }

    public CompoundTag getNbtCache() {
        return this.nbtCache;
    }

    public void setNbtCache(CompoundTag nbtCache) {
        this.nbtCache = nbtCache;
    }

    public int getTicksToMarkPlayerIdleSyncedForClient() {
        return this.ticksToMarkPlayerIdleSyncedForClient;
    }

    public void setTicksToMarkPlayerIdleSyncedForClient(int ticksToMarkPlayerIdleSyncedForClient) {
        this.ticksToMarkPlayerIdleSyncedForClient = ticksToMarkPlayerIdleSyncedForClient;
    }

    public PlayerChatState getPlayerChatState() {
        return this.playerChatState;
    }

    public void setPlayerChatState(PlayerChatState playerChatState) {
        this.playerChatState = playerChatState;
    }

    public ScreenData getScreenData() {
        if (this.screenData == null) {
            this.screenData = new ScreenData();
        }
        return this.screenData;
    }

    public void setScreenData(ScreenData screenData) {
        this.screenData = screenData;
    }

    public BlockPos getLastBlockOpened() {
        return this.lastBlockOpened;
    }

    public void setLastBlockOpened(BlockPos lastBlockOpened) {
        this.lastBlockOpened = lastBlockOpened;
    }

    public InventorySnapshot getInventorySnapshotPlayer() {
        return this.inventorySnapshotPlayer;
    }

    public void setInventorySnapshotPlayer(InventorySnapshot inventorySnapshotPlayer) {
        this.inventorySnapshotPlayer = inventorySnapshotPlayer;
    }

    public InventorySnapshot getInventorySnapshotContainer() {
        return this.inventorySnapshotContainer;
    }

    public void setInventorySnapshotContainer(InventorySnapshot inventorySnapshotContainer) {
        this.inventorySnapshotContainer = inventorySnapshotContainer;
    }

    public InventorySnapshot getInventorySnapshotCarried() {
        return this.inventorySnapshotCarried;
    }

    public void setInventorySnapshotCarried(InventorySnapshot inventorySnapshotCarried) {
        this.inventorySnapshotCarried = inventorySnapshotCarried;
    }

    public boolean isCarriedItemFromPlayerInventory() {
        return this.isCarriedItemFromPlayerInventory;
    }

    public void setCarriedItemFromPlayerInventory(boolean carriedItemFromPlayerInventory) {
        this.isCarriedItemFromPlayerInventory = carriedItemFromPlayerInventory;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public static enum PlayerGuiState {
        NONE,
        CHAT_SCREEN,
        INVENTORY,
        CRAFTING,
        ESCAPE,
        EDIT_SIGN,
        EDIT_BOOK,
        CHEST,
        ENCHANTING_TABLE,
        ANVIL,
        BEACON,
        BREWING_STAND,
        DISPENSER,
        FURNACE,
        GRINDSTONE,
        HOPPER,
        HORSE,
        LOOM,
        VILLAGER,
        COMMAND_BLOCK,
        MISC;

        private static final Map<Integer, PlayerGuiState> lookup;
        private static final List<PlayerGuiState> listPointingGuis;
        private static final List<PlayerGuiState> listTypingGuis;
        private static final List<PlayerGuiState> listSoundMakerGuis;

        public static boolean isPointingGui(PlayerGuiState playerGuiState) {
            return listPointingGuis.contains((Object)playerGuiState);
        }

        public static boolean isTypingGui(PlayerGuiState playerGuiState) {
            return listTypingGuis.contains((Object)playerGuiState);
        }

        public static boolean canPreventIdleInGui(PlayerGuiState playerGuiState) {
            return listPointingGuis.contains((Object)playerGuiState);
        }

        public static boolean isSoundMakerGui(PlayerGuiState playerGuiState) {
            return listSoundMakerGuis.contains((Object)playerGuiState);
        }

        public static PlayerGuiState get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, PlayerGuiState>();
            listPointingGuis = new ArrayList<PlayerGuiState>();
            listTypingGuis = new ArrayList<PlayerGuiState>();
            listSoundMakerGuis = new ArrayList<PlayerGuiState>();
            for (PlayerGuiState e : EnumSet.allOf(PlayerGuiState.class)) {
                lookup.put(e.ordinal(), e);
                listPointingGuis.add(e);
                listSoundMakerGuis.add(e);
            }
            listPointingGuis.remove((Object)NONE);
            listPointingGuis.remove((Object)CHAT_SCREEN);
            listPointingGuis.remove((Object)EDIT_BOOK);
            listPointingGuis.remove((Object)EDIT_SIGN);
            listPointingGuis.remove((Object)COMMAND_BLOCK);
            listTypingGuis.add(CHAT_SCREEN);
            listTypingGuis.add(EDIT_BOOK);
            listTypingGuis.add(EDIT_SIGN);
            listTypingGuis.add(COMMAND_BLOCK);
            listSoundMakerGuis.remove((Object)NONE);
            listSoundMakerGuis.remove((Object)CHAT_SCREEN);
            listSoundMakerGuis.remove((Object)CHEST);
        }
    }

    public static enum PlayerChatState {
        NONE,
        CHAT_FOCUSED,
        CHAT_TYPING;

        private static final Map<Integer, PlayerChatState> lookup;

        public static PlayerChatState get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, PlayerChatState>();
            for (PlayerChatState e : EnumSet.allOf(PlayerChatState.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }
}

