/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.coroutil.util.CULog;
import com.corosus.watut.ParticleRegistry;
import com.corosus.watut.PlayerStatus;
import com.corosus.watut.PlayerStatusManager;
import com.corosus.watut.ShaderInstanceBlur;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.client.CustomParticleEngine;
import com.corosus.watut.client.screen.RenderHelper;
import com.corosus.watut.client.screen.ScreenParticleRenderer;
import com.corosus.watut.config.ConfigClient;
import com.corosus.watut.config.ConfigServerControlledSyncedToClient;
import com.corosus.watut.config.ConfigServerSyncHelper;
import com.corosus.watut.config.CustomArmCorrections;
import com.corosus.watut.math.Lerpables;
import com.corosus.watut.particle.ParticleAnimated;
import com.corosus.watut.particle.ParticleDynamic;
import com.corosus.watut.particle.ParticleItem;
import com.corosus.watut.particle.ParticleRotating;
import com.corosus.watut.particle.ParticleStatic;
import com.corosus.watut.particle.ParticleStaticLoD;
import com.corosus.watut.particle.ParticleStaticPartial;
import com.ibm.icu.impl.Pair;
import com.mojang.authlib.GameProfile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractCommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.BeaconScreen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.DispenserScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.gui.screens.inventory.GrindstoneScreen;
import net.minecraft.client.gui.screens.inventory.HopperScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class PlayerStatusManagerClient
extends PlayerStatusManager {
    private PlayerStatus selfPlayerStatus = new PlayerStatus(PlayerStatus.PlayerGuiState.NONE, null);
    private PlayerStatus selfPlayerStatusPrev = new PlayerStatus(PlayerStatus.PlayerGuiState.NONE, null);
    public HashMap<UUID, PlayerStatus> lookupPlayerToStatusPrev = new HashMap();
    private long typingIdleTimeout = 60L;
    private int armMouseTickRate = 5;
    private int typeRatePollCounter = 0;
    private int steadyTickCounter = 0;
    private int forcedSyncRate = 40;
    private Level lastLevel;
    private boolean wasMousePressed = false;
    private int mousePressedCountdown = 0;
    public static ShaderInstanceBlur positionTexBlur;
    public static ShaderInstanceBlur positionTexBlurHorizontal;
    public static ShaderInstanceBlur positionTexBlurVertical;
    public static ShaderInstanceBlur particle;
    private static CustomParticleEngine customParticleEngine;
    private static HashMap<String, Boolean> lookupPlayersReceivedLatestGUIRender;

    public static CustomParticleEngine getParticleEngine() {
        if (customParticleEngine == null) {
            customParticleEngine = new CustomParticleEngine(Minecraft.getInstance().level, Minecraft.getInstance().getTextureManager());
            ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener((PreparableReloadListener)customParticleEngine);
        }
        return customParticleEngine;
    }

    public void tickGame() {
        boolean needSendUpdate;
        boolean canRenderANewGUI;
        ClientLevel level;
        ++this.steadyTickCounter;
        if (this.steadyTickCounter == Integer.MAX_VALUE) {
            this.steadyTickCounter = 0;
        }
        if ((level = Minecraft.getInstance().level) == null) {
            return;
        }
        if (Minecraft.getInstance().getConnection() != null) {
            Iterator it = this.lookupPlayerToStatus.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo((UUID)entry.getKey());
                PlayerStatus playerStatus = (PlayerStatus)entry.getValue();
                if (playerInfo == null) {
                    WatutMod.dbg("remove playerstatus for no longer existing player: " + String.valueOf(entry.getKey()));
                    playerStatus.reset();
                    it.remove();
                }
                if (level.getPlayerByUUID((UUID)entry.getKey()) != null || playerStatus.getParticle() == null && playerStatus.getParticleIdle() == null) continue;
                WatutMod.dbg("remove player particles for player outside dimension: " + String.valueOf(entry.getKey()));
                playerStatus.resetParticles();
            }
        }
        if (this.lastLevel != level) {
            WatutMod.dbg("resetting player status");
            for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
                WatutMod.dbg("reset player particles for " + String.valueOf(entry.getKey()) + " hash: " + String.valueOf(entry.getValue()));
                ((PlayerStatus)entry.getValue()).resetParticles();
            }
            this.selfPlayerStatus.reset();
            this.selfPlayerStatusPrev.reset();
            this.selfPlayerStatus.getScreenData().setGameTicksSinceLastScreenSend(0L);
        }
        this.lastLevel = level;
        long gameTime = 0L;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            gameTime = mc.level.getGameTime();
        }
        boolean testSingleplayer = false;
        Screen screen = Minecraft.getInstance().screen;
        boolean guiBlacklisted = screen instanceof ReceivingLevelScreen;
        boolean validGui = !guiBlacklisted && screen != null && this.selfPlayerStatus.getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE && this.selfPlayerStatus.getPlayerGuiState() != PlayerStatus.PlayerGuiState.CHAT_SCREEN;
        boolean stillActiveInGUI = this.selfPlayerStatus.getTicksSinceLastAction() < 100;
        boolean delayPassed = this.selfPlayerStatus.getScreenData().getGameTicksSinceLastScreenSend() + (long)ConfigServerControlledSyncedToClient.dynamicGuiTickSendRateOfGUIUpdates < gameTime;
        boolean bl = canRenderANewGUI = !ConfigServerControlledSyncedToClient.dynamicGuiDontSendConstantGUIUpdates || this.selfPlayerStatus.getScreenData().getLastScreen() != screen;
        if (delayPassed) {
            // empty if block
        }
        if (stillActiveInGUI && delayPassed) {
            if (validGui && canRenderANewGUI) {
                this.selfPlayerStatus.getScreenData().setGameTicksSinceLastScreenSend(gameTime);
                this.selfPlayerStatus.getScreenData().setNeedsNewRenderToPixelData(true);
                this.updateNearbyPlayerListAndCheckIfNewPlayerNear();
            }
            this.selfPlayerStatus.getScreenData().setLastScreen(Minecraft.getInstance().screen);
        }
        if (delayPassed && validGui && (ConfigServerControlledSyncedToClient.dynamicGuiDontSendConstantGUIUpdates || !stillActiveInGUI) && this.selfPlayerStatus.getScreenData().getTexturePixelData() != null && (needSendUpdate = this.updateNearbyPlayerListAndCheckIfNewPlayerNear())) {
            CULog.dbg((String)(gameTime + " needSendUpdate? " + needSendUpdate));
            this.sendScreenRenderData(this.selfPlayerStatus);
        }
        if (Minecraft.getInstance().screen == null) {
            this.selfPlayerStatus.getScreenData().setGameTicksSinceLastScreenSend(0L);
        }
    }

    public boolean updateNearbyPlayerListAndCheckIfNewPlayerNear() {
        HashMap<String, Boolean> lookup = new HashMap<String, Boolean>();
        boolean newPlayer = false;
        Minecraft mc = Minecraft.getInstance();
        for (AbstractClientPlayer player : mc.level.players()) {
            Vec3 vec3 = new Vec3(mc.player.getX(), mc.player.getY(), mc.player.getZ());
            if (!(player.position().distanceTo(vec3) <= (double)ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo)) continue;
            lookup.put(player.getName().getString(), true);
            if (lookupPlayersReceivedLatestGUIRender.containsKey(player.getName().getString())) continue;
            newPlayer = true;
        }
        lookupPlayersReceivedLatestGUIRender = lookup;
        return newPlayer;
    }

    @Override
    public void tickPlayerClient(Player player) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player.getUUID().equals(player.getUUID())) {
            this.tickLocalPlayerClient(player);
        }
        this.tickOtherPlayerClient(player);
        this.getStatus(player.getUUID()).tick();
        PlayerStatus status = this.getStatus(player);
        float adjRateTyping = 0.1f;
        if (status.getTypingAmplifierSmooth() < status.getTypingAmplifier() - adjRateTyping) {
            status.setTypingAmplifierSmooth(status.getTypingAmplifierSmooth() + adjRateTyping);
        } else if (status.getTypingAmplifierSmooth() > status.getTypingAmplifier() + adjRateTyping) {
            status.setTypingAmplifierSmooth(status.getTypingAmplifierSmooth() - adjRateTyping);
        }
    }

    public void tickLocalPlayerClient(Player player) {
        PlayerStatus.PlayerGuiState playerGuiState;
        Minecraft mc = Minecraft.getInstance();
        PlayerStatus statusLocal = this.getStatusLocal();
        PlayerStatus statusPrevLocal = this.getStatusPrevLocal();
        if (mc.player != null && mc.player.getUUID() != null && statusLocal.getUuid() == null) {
            CULog.dbg((String)("setting uuid for local player " + String.valueOf(mc.player.getUUID())));
            statusLocal.setUuid(mc.player.getUUID());
            statusPrevLocal.setUuid(mc.player.getUUID());
        }
        statusPrevLocal.setPlayerGuiState(statusLocal.getPlayerGuiState());
        if (ConfigClient.sendActiveGui && !statusLocal.isIdle()) {
            if (mc.screen instanceof ChatScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.CHAT_SCREEN);
            } else if (mc.screen instanceof EffectRenderingInventoryScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.INVENTORY);
            } else if (mc.screen instanceof CraftingScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.CRAFTING);
            } else if (mc.screen instanceof PauseScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.ESCAPE);
            } else if (mc.screen instanceof BookEditScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.EDIT_BOOK);
            } else if (mc.screen instanceof AbstractSignEditScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.EDIT_SIGN);
            } else if (mc.screen instanceof ContainerScreen || mc.screen instanceof ShulkerBoxScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.CHEST);
            } else if (mc.screen instanceof EnchantmentScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.ENCHANTING_TABLE);
            } else if (mc.screen instanceof AnvilScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.ANVIL);
            } else if (mc.screen instanceof BeaconScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.BEACON);
            } else if (mc.screen instanceof BrewingStandScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.BREWING_STAND);
            } else if (mc.screen instanceof DispenserScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.DISPENSER);
            } else if (mc.screen instanceof AbstractFurnaceScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.FURNACE);
            } else if (mc.screen instanceof GrindstoneScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.GRINDSTONE);
            } else if (mc.screen instanceof HopperScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.HOPPER);
            } else if (mc.screen instanceof HorseInventoryScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.HORSE);
            } else if (mc.screen instanceof LoomScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.LOOM);
            } else if (mc.screen instanceof MerchantScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.VILLAGER);
            } else if (mc.screen instanceof AbstractCommandBlockEditScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.COMMAND_BLOCK);
            } else if (mc.screen != null && !(mc.screen instanceof DeathScreen)) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.MISC);
            } else if (mc.screen == null) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.NONE);
            }
        } else {
            this.sendGuiStatus(PlayerStatus.PlayerGuiState.NONE);
        }
        String chatText = "";
        Screen screen = mc.screen;
        if (screen instanceof ChatScreen) {
            ChatScreen chatScreen = (ChatScreen)screen;
            chatText = chatScreen.input.getValue();
        } else {
            screen = mc.screen;
            if (screen instanceof BookEditScreen) {
                BookEditScreen bookEditScreen = (BookEditScreen)screen;
                chatText = (String)bookEditScreen.pageEdit.getMessageFn.get();
            } else {
                screen = mc.screen;
                if (screen instanceof AbstractSignEditScreen) {
                    AbstractSignEditScreen abstractSignEditScreen = (AbstractSignEditScreen)screen;
                    chatText = (String)abstractSignEditScreen.signField.getMessageFn.get();
                } else {
                    screen = mc.screen;
                    if (screen instanceof AbstractCommandBlockEditScreen) {
                        AbstractCommandBlockEditScreen abstractCommandBlockEditScreen = (AbstractCommandBlockEditScreen)screen;
                        chatText = abstractCommandBlockEditScreen.commandEdit.getValue();
                    }
                }
            }
        }
        if (this.checkIfTyping(chatText, player)) {
            this.sendChatStatus(PlayerStatus.PlayerChatState.CHAT_TYPING);
        } else if (this.isGuiFocusedOnTextBox(mc.screen)) {
            this.sendChatStatus(PlayerStatus.PlayerChatState.CHAT_FOCUSED);
        } else {
            this.sendChatStatus(PlayerStatus.PlayerChatState.NONE);
        }
        if (ConfigClient.sendMouseInfo && mc.screen != null && mc.level.getGameTime() % (long)this.armMouseTickRate == 0L && PlayerStatus.PlayerGuiState.canPreventIdleInGui(playerGuiState = statusLocal.getPlayerGuiState())) {
            Pair<Float, Float> pos = this.getMousePos();
            if (((Float)pos.first).floatValue() != statusLocal.getScreenPosPercentX() || ((Float)pos.second).floatValue() != statusLocal.getScreenPosPercentY()) {
                this.onAction();
            }
            this.sendMouse(this.getMousePos(), statusLocal.isPressing());
        }
        if (statusPrevLocal.getTicksSinceLastAction() != statusLocal.getTicksSinceLastAction()) {
            statusPrevLocal.setTicksSinceLastAction(statusLocal.getTicksSinceLastAction());
        }
        if (ConfigClient.sendIdleState) {
            statusLocal.setTicksSinceLastAction(statusLocal.getTicksSinceLastAction() + 1);
            if (statusLocal.getTicksSinceLastAction() > statusLocal.getTicksToMarkPlayerIdleSyncedForClient() && statusLocal.isIdle() != statusPrevLocal.isIdle()) {
                WatutMod.dbg("send idle getTicksSinceLastAction: " + statusLocal.getTicksSinceLastAction() + " - " + statusPrevLocal.getTicksSinceLastAction());
                this.sendIdle(statusLocal);
            }
        } else {
            statusLocal.setTicksSinceLastAction(0);
        }
        if (!this.wasMousePressed && this.mousePressedCountdown > 0) {
            --this.mousePressedCountdown;
            if (this.mousePressedCountdown == 0) {
                this.sendMouse(this.getMousePos(), false);
            }
        }
        this.tickSyncing(player);
    }

    public boolean isGuiFocusedOnTextBox(Screen screen) {
        return this.isGuiForceTypeFocused(screen);
    }

    public boolean isGuiForceTypeFocused(Screen screen) {
        return screen instanceof ChatScreen || screen instanceof AbstractSignEditScreen || screen instanceof BookEditScreen || screen instanceof AbstractCommandBlockEditScreen;
    }

    public void tickSyncing(Player player) {
        if (this.steadyTickCounter % this.forcedSyncRate == 0) {
            PlayerStatus playerStatusLocal = this.getStatusLocal();
            this.sendIdle(playerStatusLocal);
            this.sendGuiStatus(playerStatusLocal.getPlayerGuiState(), true);
            this.sendTyping(playerStatusLocal);
        }
    }

    public void onMouse(boolean pressedAnything) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null && mc.player.level() != null) {
            PlayerStatus.PlayerGuiState playerGuiState = this.getStatus((Player)mc.player).getPlayerGuiState();
            if (ConfigClient.sendMouseInfo && PlayerStatus.PlayerGuiState.canPreventIdleInGui(playerGuiState)) {
                if (pressedAnything) {
                    this.mousePressedCountdown = 3;
                    this.wasMousePressed = true;
                } else {
                    this.wasMousePressed = false;
                }
                this.sendMouse(this.getMousePos(), this.mousePressedCountdown > 0);
            }
            if (mc.screen == null || pressedAnything && PlayerStatus.PlayerGuiState.canPreventIdleInGui(playerGuiState)) {
                this.onAction();
            }
        }
    }

    public void onKey() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null && mc.player.level() != null && (mc.screen == null || this.isGuiFocusedOnTextBox(mc.screen))) {
            this.onAction();
        }
    }

    public void onAction() {
        if (!ConfigClient.sendIdleState) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null && mc.player.level() != null) {
            PlayerStatus statusLocal = this.getStatusLocal();
            if (statusLocal.isIdle()) {
                statusLocal.setTicksSinceLastAction(0);
                WatutMod.dbg("send idle: 0");
                this.sendIdle(statusLocal);
            } else {
                statusLocal.setTicksSinceLastAction(0);
            }
        }
    }

    public Pair<Float, Float> getMousePos() {
        Minecraft mc = Minecraft.getInstance();
        double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
        double guiScaleMax = 4.0;
        double xPercent = mc.mouseHandler.xpos() / (double)mc.getWindow().getScreenWidth() - 0.5;
        double yPercent = mc.mouseHandler.ypos() / (double)mc.getWindow().getScreenHeight() - 0.5;
        double emphasis = guiScaleMax / guiScale;
        double edgeLimit = 0.75;
        double edgeLimitYLower = 0.2;
        xPercent *= emphasis;
        yPercent *= emphasis;
        xPercent = Math.max(Math.min(xPercent, edgeLimit), -edgeLimit);
        yPercent = Math.max(Math.min(yPercent, edgeLimit), -edgeLimit);
        return Pair.of((Object)Float.valueOf((float)xPercent), (Object)Float.valueOf((float)yPercent));
    }

    public boolean checkIfTyping(String input, Player player) {
        PlayerStatus statusLocal = this.getStatusLocal();
        PlayerStatus statusPrevLocal = this.getStatusPrevLocal();
        if (statusPrevLocal.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE && statusLocal.getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE) {
            statusLocal.setLastTypeString(input);
            statusLocal.setLastTypeStringForAmp(input);
            statusLocal.setTypingAmplifier(0.0f);
            statusLocal.setLastTypeDiff(0);
            statusLocal.setLastTypeTime(0L);
        }
        ++this.typeRatePollCounter;
        if (input.length() > 0) {
            if (!input.startsWith("/")) {
                if (!input.equals(statusLocal.getLastTypeString())) {
                    statusLocal.setLastTypeString(input);
                    statusLocal.setLastTypeTime(player.level().getGameTime());
                }
                if (this.typeRatePollCounter >= 10) {
                    this.typeRatePollCounter = 0;
                    int lengthPrev = statusLocal.getLastTypeStringForAmp().length();
                    if (!input.equals(statusLocal.getLastTypeStringForAmp())) {
                        statusLocal.setLastTypeStringForAmp(input);
                        statusLocal.setLastTypeTimeForAmp(player.level().getGameTime());
                        int length = input.length();
                        int newDiff = length - lengthPrev;
                        float amp = Math.max(0.0f, Math.min(8.0f, (float)newDiff / 6.0f * 2.0f));
                        if (ConfigClient.sendTypingSpeed) {
                            statusLocal.setTypingAmplifier(amp);
                        } else {
                            statusLocal.setTypingAmplifier(1.0f);
                        }
                        this.sendTyping(statusLocal);
                    } else if (ConfigClient.sendTypingSpeed) {
                        statusLocal.setTypingAmplifier(0.0f);
                    }
                }
            }
        } else {
            statusLocal.setLastTypeString(input);
            statusLocal.setLastTypeDiff(0);
            return false;
        }
        return statusLocal.getLastTypeTime() + this.typingIdleTimeout >= player.level().getGameTime();
    }

    public void onGuiRender() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen instanceof ChatScreen && mc.getConnection() != null && ConfigClient.screenTypingVisible && ConfigServerControlledSyncedToClient.screenTypingVisible) {
            ChatScreen chat = (ChatScreen)mc.screen;
            GuiGraphics guigraphics = new GuiGraphics(mc, mc.renderBuffers().bufferSource());
            int height = chat.height + 26;
            guigraphics.drawString(mc.font, WatutMod.getPlayerStatusManagerClient().getTypingPlayers(), 2 + ConfigClient.screenTypingRelativePosition_X, height - 50 + ConfigClient.screenTypingRelativePosition_Y, 0xFFFFFF);
            guigraphics.flush();
        }
    }

    public String getTypingPlayers() {
        Minecraft mc = Minecraft.getInstance();
        Object str = "";
        for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
            GameProfile profile;
            PlayerInfo info;
            if (((PlayerStatus)entry.getValue()).getPlayerGuiState() != PlayerStatus.PlayerGuiState.CHAT_SCREEN || ((PlayerStatus)entry.getValue()).getPlayerChatState() != PlayerStatus.PlayerChatState.CHAT_TYPING || (info = mc.getConnection().getPlayerInfo((UUID)entry.getKey())) == null || (profile = info.getProfile()) == null) continue;
            str = (String)str + profile.getName() + ", ";
        }
        int playersLengthStr = ((String)str).length();
        Object anim = "";
        int animRate = 6;
        for (long time = mc.level.getGameTime() % (long)(animRate * 4); time > (long)animRate; time -= (long)animRate) {
            anim = (String)anim + ".";
        }
        if (playersLengthStr > ConfigClient.screenTypingCharacterLimit) {
            str = ConfigClient.screenTypingMultiplePlayersText + (String)anim;
        } else if (((String)str).length() > 2) {
            str = ((String)str).substring(0, ((String)str).length() - 2) + ConfigClient.screenTypingText + (String)anim;
        }
        return str;
    }

    public boolean shouldAnimate(Player player) {
        Minecraft mc = Minecraft.getInstance();
        return player != mc.player || !mc.options.getCameraType().isFirstPerson();
    }

    public void tickOtherPlayerClient(Player player) {
        Vec3 posParticle;
        ParticleRotating particle;
        boolean statusChatParticleChangeOrGone;
        PlayerStatus playerStatus = this.getStatus(player);
        PlayerStatus playerStatusPrev = this.getStatusPrev(player);
        long stableTime = this.steadyTickCounter;
        float sin = (float)Math.sin((float)stableTime / 30.0f % 360.0f);
        float cos = (float)Math.cos((float)stableTime / 30.0f % 360.0f);
        float idleY = (float)(2.6 + (double)(cos * 0.03f));
        boolean idleParticleChangeOrGone = playerStatus.isIdle() != playerStatusPrev.isIdle() || playerStatus.getParticleIdle() == null;
        boolean statusParticleChangeOrGone = playerStatus.getPlayerGuiState() != playerStatusPrev.getPlayerGuiState() || playerStatus.getParticle() == null;
        boolean bl = statusChatParticleChangeOrGone = playerStatus.getPlayerChatState() != playerStatusPrev.getPlayerChatState() && playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHAT_SCREEN;
        if (!(ConfigClient.showGuisForYourOwnPlayerIn3rdPerson && !Minecraft.getInstance().options.getCameraType().isFirstPerson() || this.getStatusLocal().getUuid() != null && playerStatus.getUuid() != this.getStatusLocal().getUuid())) {
            statusParticleChangeOrGone = false;
            statusChatParticleChangeOrGone = false;
        }
        if ((idleParticleChangeOrGone || !playerStatus.isIdle()) && playerStatus.getParticleIdle() != null) {
            playerStatus.getParticleIdle().remove();
            playerStatus.setParticleIdle(null);
        }
        if ((statusParticleChangeOrGone || statusChatParticleChangeOrGone || playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) && playerStatus.getParticle() != null) {
            playerStatus.getParticle().remove();
            playerStatus.setParticle(null);
        }
        if (playerStatus.getParticle() != null && !playerStatus.getParticle().isAlive()) {
            playerStatus.getParticle().remove();
            playerStatus.setParticle(null);
        }
        if (playerStatus.getParticleIdle() != null && !playerStatus.getParticleIdle().isAlive()) {
            playerStatus.getParticleIdle().remove();
            playerStatus.setParticleIdle(null);
        }
        double quadSize = (double)0.3f + Math.sin((float)stableTime / 10.0f % 360.0f) * (double)0.01f;
        if (this.shouldAnimate(player) && !player.isInvisible()) {
            if (idleParticleChangeOrGone && ConfigClient.showIdleStatesInPlayerAboveHead && ConfigServerControlledSyncedToClient.showIdleStatesInPlayerAboveHead && playerStatus.isIdle() && (particle = new ParticleStatic((ClientLevel)player.level(), player.position().x, player.position().y + (double)idleY, player.position().z, ParticleRegistry.idle.getSprite())) != null) {
                playerStatus.setParticleIdle((Particle)particle);
                PlayerStatusManagerClient.getParticleEngine().add((Particle)particle);
                particle.setQuadSize((float)quadSize);
                WatutMod.dbg("spawning idle particle for " + String.valueOf(player.getUUID()));
            }
            if (statusParticleChangeOrGone || statusChatParticleChangeOrGone) {
                boolean newRender;
                particle = null;
                posParticle = this.getParticlePosition(player);
                boolean useChatIdleForTestingOtherGUIs = false;
                boolean bl2 = newRender = RenderHelper.useDynamicGUISystem() && !playerStatus.isPlayerGuiDontSendDetailedGUIInfo();
                if (ConfigClient.showPlayerActiveChatGui && ConfigServerControlledSyncedToClient.showPlayerActiveChatGui && PlayerStatus.PlayerGuiState.isTypingGui(this.getStatus(player).getPlayerGuiState())) {
                    if (this.getStatus(player).getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_FOCUSED) {
                        particle = new ParticleAnimated((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, ParticleRegistry.chat_idle.getSpriteSet());
                        if (useChatIdleForTestingOtherGUIs) {
                            particle = newRender && playerStatus.getScreenData().getParticleRenderType() != null ? new ParticleDynamic((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, playerStatus.getScreenData().getParticleRenderType(), 0.7f) : new ParticleStaticLoD((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, ParticleRegistry.inventory.getSpriteSet());
                        }
                    } else if (this.getStatus(player).getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_TYPING) {
                        particle = new ParticleAnimated((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, ParticleRegistry.chat_typing.getSpriteSet());
                    }
                }
                if (ConfigClient.showPlayerActiveNonChatGui && ConfigServerControlledSyncedToClient.showPlayerActiveNonChatGui) {
                    TextureAtlasSprite sprite = null;
                    float brightness = 0.7f;
                    int subSizeX = 0;
                    int subSizeY = 0;
                    if (newRender) {
                        if (this.getStatus(player).getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE && this.getStatus(player).getPlayerGuiState() != PlayerStatus.PlayerGuiState.CHAT_SCREEN && playerStatus.getScreenData().getParticleRenderType() != null) {
                            particle = new ParticleDynamic((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, playerStatus.getScreenData().getParticleRenderType(), 0.7f);
                        }
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.INVENTORY) {
                        particle = new ParticleStaticLoD((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, ParticleRegistry.inventory.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.CRAFTING) {
                        particle = new ParticleStaticLoD((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, ParticleRegistry.crafting.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.ESCAPE) {
                        particle = new ParticleStaticLoD((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, ParticleRegistry.escape.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHEST) {
                        particle = new ParticleStaticLoD((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, ParticleRegistry.chest.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.EDIT_BOOK) {
                        if (playerStatus.getScreenData().getParticleRenderType() != null) {
                            particle = new ParticleDynamic((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, playerStatus.getScreenData().getParticleRenderType(), 0.7f);
                        }
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.EDIT_SIGN) {
                        particle = new ParticleStatic((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, ParticleRegistry.sign.getSprite(), 0.7f);
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.ENCHANTING_TABLE) {
                        sprite = ParticleRegistry.enchanting_table.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.ANVIL) {
                        sprite = ParticleRegistry.anvil.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.BEACON) {
                        sprite = ParticleRegistry.beacon.getSprite();
                        subSizeX = 231;
                        subSizeY = 219;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.BREWING_STAND) {
                        sprite = ParticleRegistry.brewing_stand.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.DISPENSER) {
                        sprite = ParticleRegistry.dispenser.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.FURNACE) {
                        sprite = ParticleRegistry.furnace.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.GRINDSTONE) {
                        sprite = ParticleRegistry.grindstone.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.HOPPER) {
                        sprite = ParticleRegistry.hopper.getSprite();
                        subSizeX = 176;
                        subSizeY = 134;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.HORSE) {
                        sprite = ParticleRegistry.horse.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.LOOM) {
                        sprite = ParticleRegistry.loom.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.VILLAGER) {
                        sprite = ParticleRegistry.villager.getSprite();
                        subSizeX = 277;
                        subSizeY = 167;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.COMMAND_BLOCK) {
                        sprite = ParticleRegistry.command_block.getSprite();
                        subSizeX = 308;
                        subSizeY = 213;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.MISC && ConfigClient.showPlayerActiveGuiIfNotExactMatch) {
                        particle = new ParticleStaticLoD((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, ParticleRegistry.chest.getSpriteSet());
                    }
                    if (sprite != null) {
                        particle = new ParticleStaticPartial((ClientLevel)player.level(), posParticle.x, posParticle.y, posParticle.z, sprite, brightness, subSizeX, subSizeY);
                    }
                }
                if (particle != null) {
                    playerStatus.setParticle((Particle)particle);
                    PlayerStatusManagerClient.getParticleEngine().add((Particle)particle);
                }
            }
        }
        if (playerStatus.getParticleIdle() != null && (particle = (ParticleStatic)playerStatus.getParticleIdle()).isAlive()) {
            particle.keepAlive();
            particle.setPos(player.position().x, player.position().y + (double)idleY, player.position().z);
            particle.setPosPrev(player.position().x, player.position().y + (double)idleY, player.position().z);
            particle.setParticleSpeed(0.0, 0.0, 0.0);
            ((ParticleStatic)particle).prevRotationYaw = ((ParticleStatic)particle).rotationYaw = -player.yBodyRot + 180.0f;
            ((ParticleStatic)particle).prevRotationRoll = ((ParticleStatic)particle).rotationRoll = cos * 5.0f;
            particle.setQuadSize(0.15f + sin * 0.03f);
            particle.setAlpha(0.5f);
        }
        if (playerStatus.getParticle() != null && playerStatus.getParticle() instanceof ParticleRotating && (particle = (ParticleRotating)playerStatus.getParticle()).isAlive()) {
            particle.keepAlive();
            posParticle = this.getParticlePosition(player);
            particle.setPos(posParticle.x, posParticle.y, posParticle.z);
            particle.setParticleSpeed(0.0, 0.0, 0.0);
            if (!(playerStatus.getParticle() instanceof ParticleAnimated)) {
                particle.setQuadSize((float)quadSize);
                if (Minecraft.getInstance().cameraEntity != null) {
                    double distToCamera = Minecraft.getInstance().cameraEntity.distanceTo((Entity)player);
                    double distToCameraCapped = Math.max(3.0, Math.min(10.0, distToCamera));
                    double distToCameraCapped2 = Math.max(3.0, Math.min(6.0, distToCamera));
                    float alpha = (float)Math.max((double)0.35f, 1.0 - distToCameraCapped / 10.0) + 0.15f;
                    float brightness = (float)Math.max((double)0.55f, 1.0 - distToCameraCapped / 10.0) + 0.15f;
                    float huh = (float)Math.max(0.0, 1.0 - distToCameraCapped2 / 6.0);
                    quadSize = (double)0.3f + Math.sin((float)stableTime / 10.0f % 360.0f) * (double)0.01f * (double)huh;
                    particle.setAlpha(alpha);
                    particle.setBrightness(brightness);
                    particle.setQuadSize((float)quadSize);
                    if (particle instanceof ParticleStaticLoD) {
                        ((ParticleStaticLoD)particle).setParticleFromDistanceToCamera((float)distToCamera);
                    }
                } else {
                    particle.setAlpha(0.5f);
                }
            }
            particle.prevRotationYaw = particle.rotationYaw = -player.yBodyRot;
            particle.prevRotationPitch = particle.rotationPitch = 20.0f;
        }
        playerStatusPrev.setPlayerGuiState(playerStatus.getPlayerGuiState());
        playerStatusPrev.setPlayerChatState(playerStatus.getPlayerChatState());
        if (playerStatusPrev.getTicksSinceLastAction() != playerStatus.getTicksSinceLastAction()) {
            playerStatusPrev.setTicksSinceLastAction(playerStatus.getTicksSinceLastAction());
        }
    }

    public boolean renderPingIconHook(PlayerTabOverlay playerTabOverlay, GuiGraphics pGuiGraphics, int p_281809_, int p_282801_, int pY, PlayerInfo pPlayerInfo) {
        if (Minecraft.getInstance().particleEngine == null || pPlayerInfo == null || pPlayerInfo.getProfile() == null || !ConfigClient.showIdleStatesInPlayerList || !ConfigServerControlledSyncedToClient.showIdleStatesInPlayerList) {
            return false;
        }
        PlayerStatus playerStatus = this.getStatus(pPlayerInfo.getProfile().getId());
        if (playerStatus.isIdle()) {
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate(0.0f, 0.0f, 101.0f);
            TextureAtlasSprite sprite = ParticleRegistry.idle.getSprite();
            int x = (int)((float)Minecraft.getInstance().particleEngine.textureAtlas.width * sprite.getU0());
            int y = (int)((float)Minecraft.getInstance().particleEngine.textureAtlas.height * sprite.getV0());
            pGuiGraphics.blit(sprite.atlasLocation(), p_282801_ + p_281809_ - 11, pY, (float)x, (float)y, 10, 8, Minecraft.getInstance().particleEngine.textureAtlas.width, Minecraft.getInstance().particleEngine.textureAtlas.height);
            pGuiGraphics.pose().popPose();
            return true;
        }
        return false;
    }

    public void setupRotationsHook(EntityModel model, Entity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!ConfigClient.showPlayerAnimations || !ConfigServerControlledSyncedToClient.showPlayerAnimations) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        boolean inOwnInventory = pEntity == mc.player && mc.screen instanceof EffectRenderingInventoryScreen && pEntity.isAlive();
        boolean isRealPlayer = pEntity.level().players().contains(pEntity);
        if (model instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)model;
            if (pEntity instanceof Player) {
                Player player = (Player)pEntity;
                if (isRealPlayer && (!inOwnInventory && this.shouldAnimate((Player)pEntity) || this.singleplayerTesting)) {
                    boolean contextIsInventoryPaperDoll;
                    PlayerStatus playerStatus = this.getStatus(player);
                    boolean bl = contextIsInventoryPaperDoll = (double)playerModel.head.yRot > Math.PI;
                    if (!contextIsInventoryPaperDoll) {
                        if (playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) {
                            playerStatus.yRotHeadBeforeOverriding = playerModel.head.yRot;
                            playerStatus.xRotHeadBeforeOverriding = playerModel.head.xRot;
                            if (player.level().getGameTime() % 5L == 0L) {
                                // empty if block
                            }
                        } else if ((double)playerModel.head.yRot <= Math.PI) {
                            playerStatus.yRotHeadWhileOverriding = playerModel.head.yRot;
                            playerStatus.xRotHeadWhileOverriding = playerModel.head.xRot;
                        }
                    }
                    if (playerStatus.isLerping() || playerStatus.getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE || playerStatus.isIdle()) {
                        float yRotDiff;
                        Vector3f adjLeftArm;
                        Vector3f adjRightArm;
                        float partialTick;
                        playerStatus.lastPartialTick = partialTick = pAgeInTicks - (float)((int)pAgeInTicks);
                        HumanoidArm mainArm = player.getMainArm();
                        if (mainArm == HumanoidArm.RIGHT) {
                            adjRightArm = CustomArmCorrections.getAdjustmentForArm(player.getItemBySlot(EquipmentSlot.MAINHAND), player.getItemBySlot(EquipmentSlot.OFFHAND), EquipmentSlot.MAINHAND);
                            adjLeftArm = CustomArmCorrections.getAdjustmentForArm(player.getItemBySlot(EquipmentSlot.OFFHAND), player.getItemBySlot(EquipmentSlot.MAINHAND), EquipmentSlot.OFFHAND);
                        } else {
                            adjLeftArm = CustomArmCorrections.getAdjustmentForArm(player.getItemBySlot(EquipmentSlot.OFFHAND), player.getItemBySlot(EquipmentSlot.MAINHAND), EquipmentSlot.OFFHAND);
                            adjRightArm = CustomArmCorrections.getAdjustmentForArm(player.getItemBySlot(EquipmentSlot.MAINHAND), player.getItemBySlot(EquipmentSlot.OFFHAND), EquipmentSlot.MAINHAND);
                        }
                        if (adjRightArm.y != Float.MAX_VALUE) {
                            playerModel.rightArm.yRot += Mth.lerp((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.yRot, (float)playerStatus.getLerpTarget().rightArm.yRot);
                        }
                        if (adjRightArm.x != Float.MAX_VALUE) {
                            playerModel.rightArm.xRot += Mth.lerp((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.xRot, (float)playerStatus.getLerpTarget().rightArm.xRot);
                        }
                        playerModel.rightArm.x += Mth.lerp((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.x, (float)playerStatus.getLerpTarget().rightArm.x);
                        playerModel.rightArm.y += Mth.lerp((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.y, (float)playerStatus.getLerpTarget().rightArm.y);
                        playerModel.rightArm.z += Mth.lerp((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.z, (float)playerStatus.getLerpTarget().rightArm.z);
                        if (adjLeftArm.y != Float.MAX_VALUE) {
                            playerModel.leftArm.yRot += Mth.lerp((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().leftArm.yRot, (float)playerStatus.getLerpTarget().leftArm.yRot);
                        }
                        if (adjLeftArm.x != Float.MAX_VALUE) {
                            playerModel.leftArm.xRot += Mth.lerp((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().leftArm.xRot, (float)playerStatus.getLerpTarget().leftArm.xRot);
                        }
                        if ((double)Math.abs(yRotDiff = playerStatus.getLerpTarget().head.yRot - playerStatus.getLerpPrev().head.yRot) < 1.5707963267948966) {
                            playerModel.head.yRot = Mth.lerp((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.yRot, (float)playerStatus.getLerpTarget().head.yRot);
                            if (player.level().getGameTime() % 5L == 0L) {
                                // empty if block
                            }
                        }
                        playerModel.head.xRot = Mth.lerp((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.xRot, (float)playerStatus.getLerpTarget().head.xRot);
                        playerModel.head.zRot = Mth.lerp((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.zRot, (float)playerStatus.getLerpTarget().head.zRot);
                        playerModel.rightSleeve.yRot = playerModel.rightArm.yRot;
                        playerModel.rightSleeve.xRot = playerModel.rightArm.xRot;
                        playerModel.rightSleeve.x = playerModel.rightArm.x;
                        playerModel.rightSleeve.y = playerModel.rightArm.y;
                        playerModel.rightSleeve.z = playerModel.rightArm.z;
                        playerModel.leftSleeve.yRot = playerModel.leftArm.yRot;
                        playerModel.leftSleeve.xRot = playerModel.leftArm.xRot;
                        playerModel.hat.xRot = playerModel.head.xRot;
                        playerModel.hat.yRot = playerModel.head.yRot;
                        if (ConfigClient.showPlayerAnimation_Typing && ConfigServerControlledSyncedToClient.showPlayerAnimation_Typing && playerStatus.getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_TYPING) {
                            float amp = playerStatus.getTypingAmplifierSmooth();
                            float typeAngle = (float)Math.toRadians(Math.sin(pAgeInTicks * 1.0f % 360.0f) * 15.0 * (double)amp);
                            float typeAngle2 = (float)Math.toRadians(-Math.sin(pAgeInTicks * 1.0f % 360.0f) * 15.0 * (double)amp);
                            if (adjRightArm.x != Float.MAX_VALUE) {
                                playerModel.rightArm.xRot -= typeAngle;
                            }
                            if (adjRightArm.x != Float.MAX_VALUE) {
                                playerModel.rightSleeve.xRot -= typeAngle;
                            }
                            if (adjLeftArm.x != Float.MAX_VALUE) {
                                playerModel.leftArm.xRot -= typeAngle2;
                            }
                            if (adjLeftArm.x != Float.MAX_VALUE) {
                                playerModel.leftSleeve.xRot -= typeAngle2;
                            }
                        }
                        if (adjRightArm.x != Float.MAX_VALUE) {
                            playerModel.rightArm.xRot -= adjRightArm.x;
                        }
                        if (adjRightArm.x != Float.MAX_VALUE) {
                            playerModel.rightSleeve.xRot -= adjRightArm.x;
                        }
                        if (adjLeftArm.x != Float.MAX_VALUE) {
                            playerModel.leftArm.xRot -= adjLeftArm.x;
                        }
                        if (adjLeftArm.x != Float.MAX_VALUE) {
                            playerModel.leftSleeve.xRot -= adjLeftArm.x;
                        }
                        if (adjRightArm.y != Float.MAX_VALUE) {
                            playerModel.rightArm.yRot -= adjRightArm.y;
                        }
                        if (adjRightArm.y != Float.MAX_VALUE) {
                            playerModel.rightSleeve.yRot -= adjRightArm.y;
                        }
                        if (adjLeftArm.y != Float.MAX_VALUE) {
                            playerModel.leftArm.yRot -= adjLeftArm.y;
                        }
                        if (adjLeftArm.y != Float.MAX_VALUE) {
                            playerModel.leftSleeve.yRot -= adjLeftArm.y;
                        }
                        if (adjRightArm.z != Float.MAX_VALUE) {
                            playerModel.rightArm.zRot -= adjRightArm.z;
                        }
                        if (adjRightArm.z != Float.MAX_VALUE) {
                            playerModel.rightSleeve.zRot -= adjRightArm.z;
                        }
                        if (adjLeftArm.z != Float.MAX_VALUE) {
                            playerModel.leftArm.zRot -= adjLeftArm.z;
                        }
                        if (adjLeftArm.z != Float.MAX_VALUE) {
                            playerModel.leftSleeve.zRot -= adjLeftArm.z;
                        }
                        if (ConfigClient.showPlayerAnimation_Idle && ConfigServerControlledSyncedToClient.showPlayerAnimation_Idle && playerStatus.isIdle()) {
                            float angle = (float)Math.toRadians(Math.sin(pAgeInTicks * 0.05f % 360.0f) * 15.0);
                            float angle2 = (float)Math.toRadians(Math.cos(pAgeInTicks * 0.05f % 360.0f) * 7.0);
                            playerModel.head.xRot += angle2;
                            playerModel.head.zRot += angle;
                        }
                    }
                    playerModel.hat.xRot = playerModel.head.xRot;
                    playerModel.hat.yRot = playerModel.head.yRot;
                    playerModel.hat.zRot = playerModel.head.zRot;
                }
            }
        }
    }

    public void setPoseTarget(UUID uuid, boolean becauseMousePress) {
        PlayerStatus playerStatus = this.getStatus(uuid);
        playerStatus.getLerpPrev().rightArm = playerStatus.getLerpTarget().rightArm.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().rightArm, playerStatus.lastPartialTick);
        playerStatus.getLerpPrev().leftArm = playerStatus.getLerpTarget().leftArm.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().leftArm, playerStatus.lastPartialTick);
        playerStatus.getLerpPrev().head = playerStatus.getLerpTarget().head.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().head, playerStatus.lastPartialTick);
        if (Float.isNaN(playerStatus.getLerpPrev().rightArm.yRot)) {
            playerStatus.getLerpPrev().rightArm.yRot = 0.0f;
        }
        if (Float.isNaN(playerStatus.getLerpPrev().rightArm.xRot)) {
            playerStatus.getLerpPrev().rightArm.xRot = 0.0f;
        }
        boolean pointing = PlayerStatus.PlayerGuiState.isPointingGui(playerStatus.getPlayerGuiState());
        boolean typing = playerStatus.getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_TYPING;
        boolean idle = playerStatus.isIdle();
        if (!ConfigClient.showPlayerAnimation_Gui || !ConfigServerControlledSyncedToClient.showPlayerAnimation_Gui) {
            pointing = false;
        }
        if (!ConfigClient.showPlayerAnimation_Typing || !ConfigServerControlledSyncedToClient.showPlayerAnimation_Typing) {
            typing = false;
        }
        if (!ConfigClient.showPlayerAnimation_Idle || !ConfigServerControlledSyncedToClient.showPlayerAnimation_Idle) {
            idle = false;
        }
        if (becauseMousePress) {
            playerStatus.setNewLerp((float)this.armMouseTickRate * 0.5f);
        } else {
            playerStatus.setNewLerp((float)this.armMouseTickRate * 1.0f);
        }
        if (pointing || typing) {
            playerStatus.getLerpTarget().head.xRot = (float)Math.toRadians(15.0);
            playerStatus.getLerpTarget().head.yRot = 0.0f;
        }
        if (pointing) {
            double xPercent = playerStatus.getScreenPosPercentX();
            double yPercent = playerStatus.getScreenPosPercentY();
            double x = Math.toRadians(90.0) - Math.toRadians(22.5) - yPercent;
            double y = -Math.toRadians(15.0) + xPercent;
            double xHead = Math.toRadians(22.5) + yPercent;
            double yHead = xPercent;
            playerStatus.getLerpTarget().rightArm.yRot = (float)y;
            playerStatus.getLerpTarget().rightArm.xRot = (float)(-x);
            playerStatus.getLerpTarget().head.yRot = (float)yHead * 0.5f;
            playerStatus.getLerpTarget().head.xRot = (float)xHead * 0.5f;
            if (playerStatus.isPressing()) {
                Vec3 vec = this.calculateViewVector((float)Math.toDegrees(y), (float)Math.toDegrees(x));
                float press = 1.0f;
                playerStatus.getLerpTarget().rightArm.x = (float)((double)press * vec.y);
                playerStatus.getLerpTarget().rightArm.y = (float)((double)press * vec.z);
                playerStatus.getLerpTarget().rightArm.z = (float)((double)press * vec.x);
            } else {
                playerStatus.getLerpTarget().rightArm.x = 0.0f;
                playerStatus.getLerpTarget().rightArm.z = 0.0f;
                playerStatus.getLerpTarget().rightArm.y = 0.0f;
            }
            playerStatus.getLerpTarget().leftArm.xRot = (float)(-Math.toRadians(70.0));
            playerStatus.getLerpTarget().leftArm.yRot = (float)Math.toRadians(25.0);
        } else if (typing) {
            double x = Math.toRadians(90.0) - Math.toRadians(22.5);
            playerStatus.getLerpTarget().rightArm.xRot = (float)(-x);
            playerStatus.getLerpTarget().leftArm.xRot = (float)(-x);
            double tiltIn = Math.toRadians(20.0);
            playerStatus.getLerpTarget().rightArm.yRot = (float)(-tiltIn);
            playerStatus.getLerpTarget().leftArm.yRot = (float)tiltIn;
        }
        if (!(pointing || typing || idle)) {
            playerStatus.setLerpTarget(new Lerpables());
            playerStatus.getLerpTarget().head.xRot = playerStatus.xRotHeadBeforeOverriding;
            playerStatus.getLerpTarget().head.yRot = playerStatus.yRotHeadBeforeOverriding;
        }
        if (idle) {
            playerStatus.getLerpTarget().head.xRot = (float)Math.toRadians(70.0);
            playerStatus.setNewLerp(40.0f);
        }
        if (this.getStatusPrev(uuid).getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE && this.getStatus(uuid).getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE) {
            playerStatus.getLerpPrev().head.xRot = playerStatus.xRotHeadBeforeOverriding;
            playerStatus.getLerpPrev().head.yRot = playerStatus.yRotHeadBeforeOverriding;
        }
    }

    public Vec3 getParticlePosition(Player player) {
        Vec3 pos = player.position();
        float distFromFace = 0.85f;
        Vec3 lookVec = this.getBodyAngle(player).scale((double)distFromFace);
        return new Vec3(pos.x + lookVec.x, pos.y + 1.2, pos.z + lookVec.z);
    }

    @Override
    public PlayerStatus getStatusLocal() {
        return this.selfPlayerStatus;
    }

    public PlayerStatus getStatusPrevLocal() {
        return this.selfPlayerStatusPrev;
    }

    public PlayerStatus getStatusPrev(Player player) {
        return this.getStatusPrev(player.getUUID());
    }

    public PlayerStatus getStatusPrev(UUID uuid) {
        return this.getStatusPrev(uuid, false);
    }

    public PlayerStatus getStatusPrev(UUID uuid, boolean local) {
        if (local) {
            return this.getStatusPrevLocal();
        }
        this.checkPrev(uuid);
        return this.lookupPlayerToStatusPrev.get(uuid);
    }

    public void checkPrev(UUID uuid) {
        if (!this.lookupPlayerToStatusPrev.containsKey(uuid)) {
            this.lookupPlayerToStatusPrev.put(uuid, new PlayerStatus(PlayerStatus.PlayerGuiState.NONE, uuid));
        }
    }

    public void sendGuiStatus(PlayerStatus.PlayerGuiState playerStatus) {
        this.sendGuiStatus(playerStatus, false);
    }

    public void sendGuiStatus(PlayerStatus.PlayerGuiState playerStatus, boolean force) {
        if (this.getStatusLocal().getPlayerGuiState() != playerStatus || force) {
            CompoundTag data = new CompoundTag();
            data.putInt(WatutNetworking.NBTDataPlayerGuiStatus, playerStatus.ordinal());
            data.putBoolean(WatutNetworking.NBTDataPlayerGuiDontSendDetailedGUIInfo, ConfigClient.dontSendDetailedGUIInfo);
            data.putBoolean(WatutNetworking.NBTDataPlayerGuiDontSendItemInfo, ConfigClient.dontSendItemInfo);
            WatutNetworking.instance().clientSendToServer(data);
        }
        this.getStatusLocal().setPlayerGuiState(playerStatus);
    }

    public void sendChatStatus(PlayerStatus.PlayerChatState playerStatus) {
        this.sendChatStatus(playerStatus, false);
    }

    public void sendChatStatus(PlayerStatus.PlayerChatState playerStatus, boolean force) {
        if (this.getStatusLocal().getPlayerChatState() != playerStatus || force) {
            CompoundTag data = new CompoundTag();
            data.putInt(WatutNetworking.NBTDataPlayerChatStatus, playerStatus.ordinal());
            WatutNetworking.instance().clientSendToServer(data);
        }
        this.getStatusLocal().setPlayerChatState(playerStatus);
    }

    public void sendMouse(Pair<Float, Float> pos, boolean pressed) {
        Minecraft mc = Minecraft.getInstance();
        float x = ((Float)pos.first).floatValue();
        float y = ((Float)pos.second).floatValue();
        boolean testSingleplayer = false;
        if (!(!testSingleplayer && mc.level.getNearestPlayer(mc.player.getX(), mc.player.getY(), mc.player.getZ(), (double)ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo, entity -> entity != mc.player) == null || this.getStatusLocal().getScreenPosPercentX() == x && this.getStatusLocal().getScreenPosPercentY() == y && this.getStatusLocal().isPressing() == pressed)) {
            CompoundTag data = new CompoundTag();
            data.putFloat(WatutNetworking.NBTDataPlayerMouseX, x);
            data.putFloat(WatutNetworking.NBTDataPlayerMouseY, y);
            data.putBoolean(WatutNetworking.NBTDataPlayerMousePressed, pressed);
            WatutNetworking.instance().clientSendToServer(data);
        }
        this.getStatusLocal().setScreenPosPercentX(x);
        this.getStatusLocal().setScreenPosPercentY(y);
        this.getStatusLocal().setPressing(pressed);
    }

    public void sendScreenRenderData(PlayerStatus status) {
        CompoundTag data = new CompoundTag();
        int packetSizeLimit = 31000;
        int sizeByteCount = status.getScreenData().getTexturePixelData().remaining();
        int sizeByteCountLimit = status.getScreenData().getTexturePixelData().limit();
        if (status.getScreenData().getTexturePixelData() != null) {
            byte[] inputBytes = new byte[sizeByteCount];
            status.getScreenData().getTexturePixelData().get(inputBytes);
            if (sizeByteCountLimit < packetSizeLimit) {
                data.putInt(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataSize, status.getScreenData().getTexturePixelData().capacity());
                data.putInt(WatutNetworking.NBTDataPlayerScreenWidth, ScreenParticleRenderer.getInstance().widthScaledDown);
                data.putInt(WatutNetworking.NBTDataPlayerScreenHeight, ScreenParticleRenderer.getInstance().heightScaledDown);
                data.putByteArray(WatutNetworking.NBTDataPlayerScreenCompressedPixelData, inputBytes);
                data.putInt(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketCount, 1);
                data.putInt(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketIndex, 1);
                WatutNetworking.instance().clientSendToServer(data);
            } else {
                int packetCount = Mth.ceil((float)((float)sizeByteCount / (float)packetSizeLimit));
                int packetBytesIndex = 0;
                for (int i = 0; i < packetCount; ++i) {
                    byte[] inputBytesPartial = packetBytesIndex + packetSizeLimit < sizeByteCount ? Arrays.copyOfRange(inputBytes, packetBytesIndex, packetBytesIndex + packetSizeLimit) : Arrays.copyOfRange(inputBytes, packetBytesIndex, sizeByteCount);
                    packetBytesIndex += inputBytesPartial.length;
                    data = new CompoundTag();
                    data.putInt(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataSize, status.getScreenData().getTexturePixelData().capacity());
                    data.putInt(WatutNetworking.NBTDataPlayerScreenWidth, ScreenParticleRenderer.getInstance().widthScaledDown);
                    data.putInt(WatutNetworking.NBTDataPlayerScreenHeight, ScreenParticleRenderer.getInstance().heightScaledDown);
                    data.putByteArray(WatutNetworking.NBTDataPlayerScreenCompressedPixelData, inputBytesPartial);
                    data.putInt(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketCount, packetCount);
                    data.putInt(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketIndex, i);
                    WatutNetworking.instance().clientSendToServer(data);
                }
            }
            status.getScreenData().getTexturePixelData().flip();
        }
    }

    public void sendTyping(PlayerStatus status) {
        CompoundTag data = new CompoundTag();
        data.putFloat(WatutNetworking.NBTDataPlayerTypingAmp, status.getTypingAmplifier());
        WatutNetworking.instance().clientSendToServer(data);
    }

    public void sendIdle(PlayerStatus status) {
        CompoundTag data = new CompoundTag();
        data.putInt(WatutNetworking.NBTDataPlayerIdleTicks, status.getTicksSinceLastAction());
        WatutNetworking.instance().clientSendToServer(data);
    }

    public void receiveAny(UUID uuid, CompoundTag data) {
        block30: {
            PlayerStatus status = this.getStatus(uuid);
            PlayerStatus statusPrev = this.getStatusPrev(uuid);
            if (data.contains(WatutNetworking.NBTDataPlayerTypingAmp)) {
                status.setTypingAmplifier(data.getFloat(WatutNetworking.NBTDataPlayerTypingAmp));
            }
            if (data.contains(WatutNetworking.NBTDataPlayerMouseX)) {
                Player player;
                float x = data.getFloat(WatutNetworking.NBTDataPlayerMouseX);
                float y = data.getFloat(WatutNetworking.NBTDataPlayerMouseY);
                boolean pressed = data.getBoolean(WatutNetworking.NBTDataPlayerMousePressed);
                boolean differentPress = status.isPressing() != pressed;
                this.setMouse(uuid, x, y, pressed);
                this.setPoseTarget(uuid, differentPress);
                if (pressed && differentPress && (player = Minecraft.getInstance().level.getPlayerByUUID(uuid)) != null && ConfigClient.playMouseClickSounds && ConfigServerControlledSyncedToClient.playMouseClickSounds && player != Minecraft.getInstance().player) {
                    WatutMod.dbg("play sound for " + String.valueOf(uuid) + " name " + player.getDisplayName().getString());
                    player.level().playLocalSound(player.getOnPos(), SoundEvents.CHICKEN_EGG, SoundSource.PLAYERS, 0.05f, 0.1f, false);
                }
            }
            if (data.contains(WatutNetworking.NBTDataPlayerGuiStatus)) {
                PlayerStatus.PlayerGuiState playerGuiState = PlayerStatus.PlayerGuiState.get(data.getInt(WatutNetworking.NBTDataPlayerGuiStatus));
                status.setPlayerGuiState(playerGuiState);
                if (data.contains(WatutNetworking.NBTDataPlayerGuiDontSendDetailedGUIInfo)) {
                    status.setPlayerGuiDontSendDetailedGUIInfo(data.getBoolean(WatutNetworking.NBTDataPlayerGuiDontSendDetailedGUIInfo));
                }
                if (data.contains(WatutNetworking.NBTDataPlayerGuiDontSendItemInfo)) {
                    status.setPlayerGuiDontSendItemInfo(data.getBoolean(WatutNetworking.NBTDataPlayerGuiDontSendItemInfo));
                }
                if (status.getPlayerGuiState() != statusPrev.getPlayerGuiState()) {
                    WatutMod.dbg("New gui player state and new pose target set relating to: " + String.valueOf((Object)status.getPlayerGuiState()) + " for " + String.valueOf(uuid));
                    if (statusPrev.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) {
                        status.setLerpTarget(new Lerpables());
                    }
                    this.setPoseTarget(uuid, false);
                    Player player = Minecraft.getInstance().level.getPlayerByUUID(uuid);
                    if (player != null && ConfigClient.playScreenOpenSounds && ConfigServerControlledSyncedToClient.playScreenOpenSounds && player != Minecraft.getInstance().player) {
                        PlayerStatus.PlayerGuiState playerGuiStatePrev = statusPrev.getPlayerGuiState();
                        if (PlayerStatus.PlayerGuiState.isSoundMakerGui(playerGuiState) || PlayerStatus.PlayerGuiState.isSoundMakerGui(playerGuiStatePrev) || playerGuiState == PlayerStatus.PlayerGuiState.INVENTORY || playerGuiState == PlayerStatus.PlayerGuiState.CRAFTING || playerGuiState == PlayerStatus.PlayerGuiState.MISC || playerGuiStatePrev == PlayerStatus.PlayerGuiState.INVENTORY || playerGuiStatePrev == PlayerStatus.PlayerGuiState.CRAFTING || playerGuiStatePrev == PlayerStatus.PlayerGuiState.MISC) {
                            player.level().playLocalSound(player.getOnPos(), (SoundEvent)SoundEvents.ARMOR_EQUIP_CHAIN.value(), SoundSource.PLAYERS, 0.9f, 1.0f, false);
                        }
                    }
                }
            }
            if (data.contains(WatutNetworking.NBTDataPlayerChatStatus)) {
                PlayerStatus.PlayerChatState state = PlayerStatus.PlayerChatState.get(data.getInt(WatutNetworking.NBTDataPlayerChatStatus));
                status.setPlayerChatState(state);
                if (status.getPlayerChatState() != statusPrev.getPlayerChatState()) {
                    WatutMod.dbg("New chat player state and new pose target set relating to: " + String.valueOf((Object)status.getPlayerChatState()) + " for " + String.valueOf(uuid));
                    if (statusPrev.getPlayerChatState() == PlayerStatus.PlayerChatState.NONE) {
                        status.setLerpTarget(new Lerpables());
                    }
                    if (status.getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_FOCUSED) {
                        status.setTypingAmplifier(1.0f);
                        status.setTypingAmplifierSmooth(1.0f);
                    }
                    this.setPoseTarget(uuid, false);
                }
            }
            if (data.contains(WatutNetworking.NBTDataPlayerIdleTicks)) {
                status.setTicksSinceLastAction(data.getInt(WatutNetworking.NBTDataPlayerIdleTicks));
                status.setTicksToMarkPlayerIdleSyncedForClient(data.getInt(WatutNetworking.NBTDataPlayerTicksToGoIdle));
                statusPrev.setTicksToMarkPlayerIdleSyncedForClient(data.getInt(WatutNetworking.NBTDataPlayerTicksToGoIdle));
                this.getStatusLocal().setTicksToMarkPlayerIdleSyncedForClient(data.getInt(WatutNetworking.NBTDataPlayerTicksToGoIdle));
                this.getStatusPrevLocal().setTicksToMarkPlayerIdleSyncedForClient(data.getInt(WatutNetworking.NBTDataPlayerTicksToGoIdle));
                if (statusPrev.isIdle() != status.isIdle()) {
                    WatutMod.dbg("New idle player state and new pose target set relating to idle state: " + status.isIdle() + " for " + String.valueOf(uuid));
                    this.setPoseTarget(uuid, false);
                }
            }
            if (data.contains(WatutNetworking.NBTDataPlayerScreenCompressedPixelData)) {
                byte[] pixelData = data.getByteArray(WatutNetworking.NBTDataPlayerScreenCompressedPixelData);
                int decompressedSize = data.getInt(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataSize);
                int packetCount = data.getInt(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketCount);
                int packetIndex = data.getInt(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketIndex);
                status.getScreenData().setWidth(data.getInt(WatutNetworking.NBTDataPlayerScreenWidth));
                status.getScreenData().setHeight(data.getInt(WatutNetworking.NBTDataPlayerScreenHeight));
                long gameTime = Minecraft.getInstance().level != null ? Minecraft.getInstance().level.getGameTime() : 0L;
                int timeout = 10;
                if (packetCount > 1) {
                    if (packetIndex == 0) {
                        status.getScreenData().setGameTicksSinceFirstPacket(gameTime);
                        status.getScreenData().setLastIndexReceived(0);
                        status.getScreenData().setTexturePixelDataPartial(pixelData);
                    } else if (packetIndex != status.getScreenData().getLastIndexReceived() + 1) {
                        CULog.dbg((String)"ERROR: packet index incorrect, aborting packet processing");
                    } else {
                        status.getScreenData().setLastIndexReceived(packetIndex);
                        if (gameTime <= status.getScreenData().getGameTicksSinceFirstPacket() + (long)timeout && pixelData.length > 0) {
                            byte[] dataBytes = status.getScreenData().getTexturePixelDataPartial();
                            byte[] combined = new byte[dataBytes.length + pixelData.length];
                            System.arraycopy(dataBytes, 0, combined, 0, dataBytes.length);
                            System.arraycopy(pixelData, 0, combined, dataBytes.length, pixelData.length);
                            status.getScreenData().setTexturePixelDataPartial(combined);
                            if (packetIndex == packetCount - 1) {
                                try {
                                    if (status.getScreenData().getTexturePixelDataPartial() != null) {
                                        status.getScreenData().setTexturePixelData(RenderHelper.decompress(status.getScreenData(), ByteBuffer.wrap(status.getScreenData().getTexturePixelDataPartial()), decompressedSize));
                                        status.getScreenData().markNeedsNewRenderFromPixelData(true);
                                        status.getScreenData().getIsBufferReady().set(true);
                                        break block30;
                                    }
                                    CULog.dbg((String)"getTexturePixelDataPartial() null!");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                } else {
                    try {
                        status.getScreenData().setTexturePixelData(RenderHelper.decompress(status.getScreenData(), ByteBuffer.wrap(pixelData), decompressedSize));
                        status.getScreenData().markNeedsNewRenderFromPixelData(true);
                        status.getScreenData().getIsBufferReady().set(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void receiveItemMove(CompoundTag data) {
        if (data.contains(WatutNetworking.NBTDataItemTransferItemStack)) {
            ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)data.getCompound(WatutNetworking.NBTDataItemTransferItemStack));
            ParticleItem particleItem = new ParticleItem(Minecraft.getInstance().level, 1.0f, itemStack, Minecraft.getInstance().renderBuffers(), Minecraft.getInstance().getEntityRenderDispatcher(), data.getFloat(WatutNetworking.NBTDataItemTransferFromX), data.getFloat(WatutNetworking.NBTDataItemTransferFromY), data.getFloat(WatutNetworking.NBTDataItemTransferFromZ), data.getFloat(WatutNetworking.NBTDataItemTransferToX), data.getFloat(WatutNetworking.NBTDataItemTransferToY), data.getFloat(WatutNetworking.NBTDataItemTransferToZ));
            PlayerStatusManagerClient.getParticleEngine().add((Particle)particleItem);
        }
    }

    public void receiveServerConfig(CompoundTag nbt) {
        CULog.dbg((String)"receiving server config sync");
        ConfigServerSyncHelper.getInstance().updateSyncableConfigOnClient(nbt);
        ScreenParticleRenderer.getInstance().resizeScaledDown(ScreenParticleRenderer.getInstance().width, ScreenParticleRenderer.getInstance().height);
    }

    static {
        lookupPlayersReceivedLatestGUIRender = new HashMap();
    }
}

