/*
 * Decompiled with CFR 0.152.
 */
package waves;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import waves.config.Config;
import waves.util.WaveDataManager;
import waves.util.WaveHelpers;

public class EventHandler {
    public static void init() {
        IEventBus bus = NeoForge.EVENT_BUS;
        bus.addListener(EventHandler::updateCaches);
        bus.addListener(EventHandler::resetWaveData);
        bus.addListener(EventHandler::loadWaveData);
        bus.addListener(EventHandler::handleWavesServer);
    }

    public static void resetWaveData(LevelEvent.Unload event) {
        WaveDataManager.WAVE_DATA.clearData();
        WaveHelpers.wipeCaches();
    }

    public static void loadWaveData(LevelEvent.Load event) {
        WaveDataManager.WAVE_DATA.initConfigs();
        WaveHelpers.wipeCaches();
    }

    public static void handleWavesServer(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (level.getGameTime() % 20L == 0L && !level.isClientSide() && (Integer)Config.COMMON.waveSpawnFrequency.get() > 0 && (Double)Config.COMMON.waveSpawnAmount.get() > 0.0 && !WaveDataManager.WAVE_DATA.get().isEmpty() && player != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level != null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                WaveHelpers.spawnWaves(serverLevel, (Player)serverPlayer, (Boolean)Config.COMMON.toggleWaveEntities.get());
            }
        }
    }

    public static void updateCaches(ServerTickEvent.Post event) {
        ServerLevel level;
        if (((Boolean)Config.COMMON.useCaches.get()).booleanValue() && (level = event.getServer().getLevel(Level.OVERWORLD)) != null && level.getGameTime() % (long)((Integer)Config.COMMON.cacheUpdateFrequency.get()).intValue() == 0L) {
            WaveHelpers.wipeCaches();
        }
    }
}

