/*
 * Decompiled with CFR 0.152.
 */
package waves.client.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import waves.client.particle.WaveParticles;
import waves.util.WaveHelpers;

public class WaveParticleOption
implements ParticleOptions {
    public static final MapCodec<WaveParticleOption> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.listOf().listOf().optionalFieldOf("positions", List.of(List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0)), List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0)), List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0)))).forGetter(option -> option.positions), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(0.0f)).forGetter(option -> Float.valueOf(option.scale)), (App)Codec.FLOAT.optionalFieldOf("size", (Object)Float.valueOf(0.0f)).forGetter(option -> Float.valueOf(option.size)), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(0.0f)).forGetter(option -> Float.valueOf(option.speed)), (App)Codec.INT.optionalFieldOf("waveSize", (Object)0).forGetter(option -> option.waveSize), (App)Codec.INT.optionalFieldOf("surroundWaterBlocks", (Object)0).forGetter(option -> option.surroundWaterBlocks)).apply((Applicative)instance, (positions, scale, size, speed, waveSize, surroundWaterBlocks) -> new WaveParticleOption(WaveHelpers.unpackToVec3((List)positions.get(0)), WaveHelpers.unpackToVec3((List)positions.get(1)), WaveHelpers.unpackToVec3((List)positions.get(2)), scale.floatValue(), size.floatValue(), speed.floatValue(), (int)waveSize, (int)surroundWaterBlocks)));
    public static final StreamCodec<RegistryFriendlyByteBuf, WaveParticleOption> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.DOUBLE)), WaveParticleOption::getPositions, (StreamCodec)ByteBufCodecs.FLOAT, WaveParticleOption::getScale, (StreamCodec)ByteBufCodecs.FLOAT, WaveParticleOption::getSize, (StreamCodec)ByteBufCodecs.FLOAT, WaveParticleOption::getSpeed, (StreamCodec)ByteBufCodecs.INT, WaveParticleOption::getWaveSize, (StreamCodec)ByteBufCodecs.INT, WaveParticleOption::getSurroundWaterBlocks, (positions, scale, size, speed, waveSize, surroundWaterBlocks) -> new WaveParticleOption(WaveHelpers.unpackToVec3((List)positions.get(0)), WaveHelpers.unpackToVec3((List)positions.get(1)), WaveHelpers.unpackToVec3((List)positions.get(2)), scale.floatValue(), size.floatValue(), speed.floatValue(), (int)waveSize, (int)surroundWaterBlocks));
    public final List<List<Double>> positions;
    public final float scale;
    public final float size;
    public final float speed;
    public final int waveSize;
    public final int surroundWaterBlocks;

    public WaveParticleOption(Vec3 startPos, Vec3 shorePos, Vec3 direction, float scale, float size, float speed, int waveSize, int surroundWaterBlocks) {
        ArrayList<Double> startPosList = new ArrayList<Double>();
        startPosList.add(startPos.x());
        startPosList.add(startPos.y());
        startPosList.add(startPos.z());
        ArrayList<Double> shorePosList = new ArrayList<Double>();
        shorePosList.add(shorePos.x());
        shorePosList.add(shorePos.y());
        shorePosList.add(shorePos.z());
        ArrayList<Double> directionList = new ArrayList<Double>();
        directionList.add(direction.x());
        directionList.add(direction.y());
        directionList.add(direction.z());
        ArrayList<List<Double>> positionsList = new ArrayList<List<Double>>();
        positionsList.add(0, startPosList);
        positionsList.add(1, shorePosList);
        positionsList.add(2, directionList);
        this.positions = positionsList;
        this.scale = scale;
        this.size = size;
        this.speed = speed;
        this.waveSize = waveSize;
        this.surroundWaterBlocks = surroundWaterBlocks;
    }

    public ParticleType<?> getType() {
        return (ParticleType)WaveParticles.WAVES.get();
    }

    public List<List<Double>> getPositions() {
        return this.positions;
    }

    public Vec3 getStartPos() {
        List<Double> startPos = this.positions.get(0);
        return new Vec3(startPos.get(0).doubleValue(), startPos.get(1).doubleValue(), startPos.get(2).doubleValue());
    }

    public Vec3 getShorePos() {
        List<Double> shorePos = this.positions.get(1);
        return new Vec3(shorePos.get(0).doubleValue(), shorePos.get(1).doubleValue(), shorePos.get(2).doubleValue());
    }

    public Vec3 getDirection() {
        List<Double> direction = this.positions.get(2);
        return new Vec3(direction.get(0).doubleValue(), direction.get(1).doubleValue(), direction.get(2).doubleValue());
    }

    public float getScale() {
        return this.scale;
    }

    public float getSize() {
        return this.size;
    }

    public float getSpeed() {
        return this.speed;
    }

    public int getWaveSize() {
        return this.waveSize;
    }

    public int getSurroundWaterBlocks() {
        return this.surroundWaterBlocks;
    }
}

