/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.core.block.BigBarrelBlock;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class BigBarrelRightBlock
extends BigBarrelBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF;
    private static final Supplier<VoxelShape> bottomVoxelShapeSupplier;
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPE;
    private static final Supplier<VoxelShape> topVoxelShapeSupplier;
    public static final Map<Direction, VoxelShape> TOP_SHAPE;

    public BigBarrelRightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.setBlockAndUpdate(blockPos.above(), (BlockState)blockState.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER));
        }
    }

    @NotNull
    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.getValue(HALF);
        if (direction.getAxis() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return blockState2.is((Block)this) && blockState2.getValue(HALF) != doubleBlockHalf ? (BlockState)blockState.setValue((Property)FACING, (Comparable)((Direction)blockState2.getValue((Property)FACING))) : Blocks.AIR.defaultBlockState();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !blockState.canSurvive((LevelReader)levelAccessor, blockPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        BlockPos backPos = blockPos.relative(facing.getOpposite());
        BlockPos sidePos = blockPos.relative(facing.getClockWise());
        BlockPos diagonalPos = sidePos.relative(facing.getOpposite());
        level.removeBlock(backPos, false);
        level.removeBlock(sidePos, false);
        level.removeBlock(diagonalPos, false);
        level.removeBlock(blockPos, false);
        super.onRemove(blockState, level, blockPos, blockState2, bl);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (half == DoubleBlockHalf.LOWER) {
            return BOTTOM_SHAPE.get(facing);
        }
        return TOP_SHAPE.get(facing);
    }

    static {
        bottomVoxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.25, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.1875, (double)1.0, (double)0.25, (double)0.4375));
            return shape;
        };
        BOTTOM_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)bottomVoxelShapeSupplier.get()));
            }
        });
        topVoxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
            return shape;
        };
        TOP_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)topVoxelShapeSupplier.get()));
            }
        });
        HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    }
}

