/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.core.block.BrewingstationBlock;
import net.satisfy.brewery.core.block.entity.BrewstationBlockEntity;
import net.satisfy.brewery.core.block.property.BrewMaterial;
import net.satisfy.brewery.core.block.property.Liquid;
import net.satisfy.brewery.core.registry.BlockStateRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.brewery.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewKettleBlock
extends BrewingstationBlock
implements EntityBlock {
    public static final EnumProperty<Liquid> LIQUID = BlockStateRegistry.LIQUID;
    public static final Map<Direction, VoxelShape> SHAPE;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    private final BrewMaterial brewMaterial;
    public static final MapCodec<BrewKettleBlock> CODEC;

    public BrewKettleBlock(BlockBehaviour.Properties properties) {
        this(BrewMaterial.WOOD, properties);
    }

    public BrewKettleBlock(BrewMaterial brewMaterial, BlockBehaviour.Properties properties) {
        super(properties);
        this.brewMaterial = brewMaterial;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)MATERIAL, (Comparable)((Object)brewMaterial))).setValue(LIQUID, (Comparable)((Object)Liquid.EMPTY)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (interactionHand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.CONSUME;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof BrewstationBlockEntity) {
            BrewstationBlockEntity brewKettleEntity = (BrewstationBlockEntity)blockEntity;
            if (itemStack.isEmpty()) {
                ItemStack returnStack = brewKettleEntity.removeIngredient();
                if (returnStack != null) {
                    player.addItem(returnStack);
                    level.playSound(null, blockPos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
                    level.sendBlockUpdated(blockPos, blockState, blockState, 2);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.CONSUME;
            }
            if (itemStack.getItem() == ((Block)ObjectRegistry.BEER_MUG.get()).asItem()) {
                if (blockState.getValue(LIQUID) == Liquid.BEER) {
                    ItemStack beerStack = brewKettleEntity.getBeer();
                    if (beerStack != null) {
                        player.addItem(beerStack);
                        if (!player.isCreative()) {
                            itemStack.shrink(1);
                            if (itemStack.isEmpty()) {
                                player.getInventory().removeItem(itemStack);
                            }
                            level.playSound(null, blockPos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
                            level.sendBlockUpdated(blockPos, blockState, blockState, 2);
                        }
                        return ItemInteractionResult.SUCCESS;
                    }
                    return ItemInteractionResult.CONSUME;
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (itemStack.getItem() == Items.WATER_BUCKET) {
                if (blockState.getValue(LIQUID) == Liquid.EMPTY || blockState.getValue(LIQUID) == Liquid.DRAINED) {
                    level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(LIQUID, (Comparable)((Object)Liquid.FILLED)));
                    level.playSound(null, blockPos, SoundEvents.BUCKET_EMPTY, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.isCreative()) {
                        player.setItemInHand(interactionHand, new ItemStack((ItemLike)Items.BUCKET));
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.CONSUME;
            }
            if (itemStack.getItem() == Items.BUCKET) {
                Liquid liquid = (Liquid)((Object)blockState.getValue(LIQUID));
                if (liquid == Liquid.FILLED || liquid == Liquid.OVERFLOWING) {
                    level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(LIQUID, (Comparable)((Object)(liquid == Liquid.OVERFLOWING ? Liquid.FILLED : Liquid.EMPTY))));
                    level.playSound(null, blockPos, SoundEvents.BUCKET_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.isCreative()) {
                        itemStack.shrink(1);
                        ItemStack filledBucket = new ItemStack((ItemLike)Items.WATER_BUCKET);
                        if (!player.addItem(filledBucket)) {
                            player.drop(filledBucket, false);
                        }
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.CONSUME;
            }
            if (blockState.getValue(LIQUID) != Liquid.BEER) {
                ItemInteractionResult interactionResult;
                ItemStack insertStack;
                ItemStack itemStack2 = insertStack = player.isCreative() ? itemStack.copy() : itemStack;
                if (player.isCreative()) {
                    insertStack.setCount(1);
                }
                if ((interactionResult = brewKettleEntity.addIngredient(insertStack)) == ItemInteractionResult.SUCCESS) {
                    level.playSound(null, blockPos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.PLAYERS, 1.0f, 1.0f);
                    level.sendBlockUpdated(blockPos, blockState, blockState, 2);
                }
                return interactionResult;
            }
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (blockState.getValue(LIQUID) == Liquid.OVERFLOWING) {
            double x = (double)blockPos.getX() + 0.5;
            double y = (double)blockPos.getY() + 0.95;
            double z = (double)blockPos.getZ() + 0.5;
            if (randomSource.nextDouble() < 0.02) {
                level.playLocalSound(x, y, z, (SoundEvent)SoundEventRegistry.BREWSTATION_KETTLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            double offset = 0.2;
            double offsetX = randomSource.nextDouble() * offset - offset / 2.0;
            double offsetY = randomSource.nextDouble() * 0.1;
            double offsetZ = randomSource.nextDouble() * offset - offset / 2.0;
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof BrewstationBlockEntity) {
                BrewstationBlockEntity brewstationEntity = (BrewstationBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)brewstationEntity);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    @Override
    @NotNull
    public ItemStack getCloneItemStack(LevelReader getter, BlockPos pos, BlockState state) {
        BrewMaterial material = (BrewMaterial)((Object)state.getValue((Property)MATERIAL));
        return switch (material) {
            default -> throw new MatchException(null, null);
            case BrewMaterial.COPPER -> new ItemStack((ItemLike)ObjectRegistry.COPPER_BREWINGSTATION.get());
            case BrewMaterial.WOOD -> new ItemStack((ItemLike)ObjectRegistry.WOODEN_BREWINGSTATION.get());
            case BrewMaterial.NETHERITE -> new ItemStack((ItemLike)ObjectRegistry.NETHERITE_BREWINGSTATION.get());
        };
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.getLevel();
        BlockPos mainPos = blockPlaceContext.getClickedPos();
        BlockState blockState = super.getStateForPlacement(blockPlaceContext);
        if (blockState == null) {
            return null;
        }
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        BlockPos backPos = mainPos.relative(facing.getOpposite());
        BlockPos sidePos = mainPos.relative(facing.getCounterClockWise());
        BlockPos diagonalPos = sidePos.relative(facing.getOpposite());
        BlockPos topPos = diagonalPos.above();
        boolean placeable = this.canPlace(level, backPos, sidePos, diagonalPos, topPos);
        return placeable ? blockState : null;
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.setPlacedBy(level, blockPos, blockState, livingEntity, itemStack);
        if (level.isClientSide) {
            return;
        }
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        BlockPos backPos = blockPos.relative(facing.getOpposite());
        BlockPos sidePos = blockPos.relative(facing.getCounterClockWise());
        BlockPos diagonalPos = sidePos.relative(facing.getOpposite());
        BlockPos topPos = diagonalPos.above();
        if (!this.canPlace(level, backPos, sidePos, diagonalPos, topPos)) {
            return;
        }
        level.setBlock(backPos, (BlockState)((BlockState)((Block)ObjectRegistry.BREW_TIMER.get()).defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)MATERIAL, (Comparable)((Object)this.brewMaterial)), 3);
        level.setBlock(sidePos, (BlockState)((BlockState)((Block)ObjectRegistry.BREW_WHISTLE.get()).defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)MATERIAL, (Comparable)((Object)this.brewMaterial)), 3);
        level.setBlock(diagonalPos, (BlockState)((BlockState)((Block)ObjectRegistry.BREW_OVEN.get()).defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)MATERIAL, (Comparable)((Object)this.brewMaterial)), 3);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof BrewstationBlockEntity) {
            BrewstationBlockEntity brewKettleEntity = (BrewstationBlockEntity)blockEntity;
            brewKettleEntity.setComponents(blockPos, backPos, sidePos, diagonalPos);
        }
    }

    private boolean canPlace(Level level, BlockPos ... blockPoses) {
        for (BlockPos blockPos : blockPoses) {
            if (level.getBlockState(blockPos).isAir()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BrewstationBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (lvl, pos, st, be) -> {
            if (be instanceof BrewstationBlockEntity) {
                BrewstationBlockEntity kettle = (BrewstationBlockEntity)be;
                kettle.tick(lvl, pos, st, kettle);
            }
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIQUID});
    }

    @Override
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    static {
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.125));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.125, (double)0.125, (double)1.0, (double)1.0, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.125, (double)0.125, (double)1.0, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.125, (double)0.9375, (double)0.875, (double)1.0, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.5625, (double)0.09375, (double)0.875, (double)0.5625, (double)0.96875));
            return shape;
        };
        SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
            }
        });
        CODEC = BrewKettleBlock.simpleCodec(BrewKettleBlock::new);
    }
}

