/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.item;

import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.core.registry.MobEffectRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.brewery.core.registry.SoundEventRegistry;
import org.jetbrains.annotations.NotNull;

public class BreathalyzerItem
extends Item {
    public BreathalyzerItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        player.startUsingItem(interactionHand);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEventRegistry.BREATH.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    private void addNbt(LivingEntity livingEntity) {
        int amp;
        ItemStack itemStack = livingEntity.getItemInHand(livingEntity.getUsedItemHand());
        Holder holder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)MobEffectRegistry.DRUNK.get()));
        MobEffectInstance inst = livingEntity.getEffect(holder);
        int n = amp = inst != null ? inst.getAmplifier() : -1;
        String val = amp <= 1 ? "EASY" : (amp <= 3 ? "WARNING" : "DANGER");
        CompoundTag nbtData = new CompoundTag();
        nbtData.putString("brewery.drunkenness", val);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbtData));
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.TOOT_HORN;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 100;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack itemStack, int tick) {
        if (this.getUseDuration(itemStack, livingEntity) - tick == 60) {
            this.addNbt(livingEntity);
        }
        super.onUseTick(level, livingEntity, itemStack, tick);
    }

    public static void init() {
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ObjectRegistry.BREATHALYZER.get()), (ResourceLocation)Brewery.identifier("breathing"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ObjectRegistry.BREATHALYZER.get()), (ResourceLocation)Brewery.identifier("drunkenness"), (itemStack, clientLevel, livingEntity, i) -> {
            if (itemStack.has(DataComponents.CUSTOM_DATA)) {
                String drunkenness;
                return switch (drunkenness = ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("brewery.drunkenness")) {
                    case "DANGER" -> 0.9f;
                    case "WARNING" -> 0.6f;
                    case "EASY" -> 0.3f;
                    default -> 0.0f;
                };
            }
            return 0.0f;
        });
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        if (itemStack.has(DataComponents.CUSTOM_DATA)) {
            String drunkenness;
            MutableComponent tooltip = switch (drunkenness = ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("brewery.drunkenness")) {
                case "DANGER" -> Component.translatable((String)drunkenness).withStyle(ChatFormatting.RED);
                case "WARNING" -> Component.translatable((String)drunkenness).withStyle(ChatFormatting.GOLD);
                case "EASY" -> Component.translatable((String)drunkenness).withStyle(ChatFormatting.GREEN);
                default -> Component.translatable((String)drunkenness);
            };
            list.add((Component)tooltip);
        }
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
    }
}

