/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.satisfy.brewery.core.entity.DarkBrewEntity;
import org.jetbrains.annotations.NotNull;

public class DarkBrewItem
extends Item {
    public DarkBrewItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.EGG_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            DarkBrewEntity darkBrewEntity = new DarkBrewEntity(world, (LivingEntity)user);
            darkBrewEntity.setItem(itemStack);
            darkBrewEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
            world.addFreshEntity((Entity)darkBrewEntity);
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!user.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }
}

