/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms.events;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.callback.MoveSelectCallbacks;
import com.cobblemon.mod.common.api.callback.MoveSelectDTO;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.moves.Learnset;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dragomordor.simpletms.SimpleTMs;
import dragomordor.simpletms.SimpleTMsItems;
import dragomordor.simpletms.events.EventHandler;
import dragomordor.simpletms.util.MiscUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J-\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b&\u0010'\u00a8\u0006("}, d2={"Ldragomordor/simpletms/events/MoveLearnItemDropEventListeners;", "Ldragomordor/simpletms/events/EventHandler;", "<init>", "()V", "", "registerListeners", "Lcom/cobblemon/mod/common/api/events/battles/BattleFaintedEvent;", "event", "onBattleFainted", "(Lcom/cobblemon/mod/common/api/events/battles/BattleFaintedEvent;)V", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lnet/minecraft/world/damagesource/DamageSource;", "source", "Ldev/architectury/event/EventResult;", "onEntityFainted", "(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/damagesource/DamageSource;)Ldev/architectury/event/EventResult;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "killedPokemon", "Lnet/minecraft/server/level/ServerPlayer;", "player", "onPokemonFainted", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/server/level/ServerPlayer;)V", "", "inBattle", "dropMoveLearnItemOnPlayer", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/server/level/ServerPlayer;Z)V", "Lcom/cobblemon/mod/common/api/moves/Move;", "move", "isTR", "isTM", "dropMoveLearnItemOnPlayerHandler", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/api/moves/Move;ZZ)V", "pokemon", "", "numberOfMovesToChooseFrom", "", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "getRandomApplicableMoveTemplates", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;IZ)Ljava/util/List;", "common"})
@SourceDebugExtension(value={"SMAP\nMoveLearnItemDropEventListeners.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveLearnItemDropEventListeners.kt\ndragomordor/simpletms/events/MoveLearnItemDropEventListeners\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n1557#2:228\n1628#2,3:229\n1557#2:232\n1628#2,3:233\n774#2:236\n865#2,2:237\n774#2:239\n865#2,2:240\n774#2:242\n865#2,2:243\n*S KotlinDebug\n*F\n+ 1 MoveLearnItemDropEventListeners.kt\ndragomordor/simpletms/events/MoveLearnItemDropEventListeners\n*L\n127#1:228\n127#1:229,3\n130#1:232\n130#1:233,3\n175#1:236\n175#1:237,2\n186#1:239\n186#1:240,2\n190#1:242\n190#1:243,2\n*E\n"})
public final class MoveLearnItemDropEventListeners
implements EventHandler {
    @NotNull
    public static final MoveLearnItemDropEventListeners INSTANCE = new MoveLearnItemDropEventListeners();

    private MoveLearnItemDropEventListeners() {
    }

    @Override
    public void registerListeners() {
        CobblemonEvents.BATTLE_FAINTED.subscribe(Priority.NORMAL, (Function1)new Function1<BattleFaintedEvent, Unit>((Object)this){

            public final void invoke(BattleFaintedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((MoveLearnItemDropEventListeners)this.receiver).onBattleFainted(p0);
            }
        });
        EntityEvent.LIVING_DEATH.register(MoveLearnItemDropEventListeners::registerListeners$lambda$0);
    }

    public final void onBattleFainted(@NotNull BattleFaintedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List players = event.getBattle().getPlayers();
        if (players.size() == 1) {
            ServerPlayer player = (ServerPlayer)players.get(0);
            BattlePokemon killedBattlePokemon = event.getKilled();
            Pokemon killedPokemon = killedBattlePokemon.getEffectedPokemon();
            if (!killedPokemon.isPlayerOwned() && SimpleTMs.INSTANCE.getConfig().getDropInBattle()) {
                this.dropMoveLearnItemOnPlayer(killedPokemon, player, true);
            }
        }
    }

    private final EventResult onEntityFainted(LivingEntity entity, DamageSource source) {
        if (entity.getClass() == PokemonEntity.class) {
            Entity entity2 = source.getEntity();
            if (Intrinsics.areEqual(entity2 != null ? entity2.getClass() : null, ServerPlayer.class)) {
                Entity entity3 = source.getEntity();
                Intrinsics.checkNotNull((Object)entity3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                ServerPlayer player = (ServerPlayer)entity3;
                Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.pokemon.PokemonEntity");
                this.onPokemonFainted(((PokemonEntity)entity).getPokemon(), player);
            }
        }
        return EventResult.pass();
    }

    private final void onPokemonFainted(Pokemon killedPokemon, ServerPlayer player) {
        if (!SimpleTMs.INSTANCE.getConfig().getDropOutsideOfBattle()) {
            return;
        }
        if (!killedPokemon.isPlayerOwned()) {
            this.dropMoveLearnItemOnPlayer(killedPokemon, player, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void dropMoveLearnItemOnPlayer(Pokemon killedPokemon, ServerPlayer player, boolean inBattle) {
        boolean isTR;
        Pair pair = inBattle ? TuplesKt.to((Object)SimpleTMs.INSTANCE.getConfig().getDropRateInBattle(), (Object)SimpleTMs.INSTANCE.getConfig().getDropRateTMFractionInBattle()) : TuplesKt.to((Object)SimpleTMs.INSTANCE.getConfig().getDropRateOutsideOfBattle(), (Object)SimpleTMs.INSTANCE.getConfig().getDropRateTMFractionOutsideOfBattle());
        double dropRateTR = ((Number)pair.component1()).doubleValue();
        double dropRateTMtoTRRatio = ((Number)pair.component2()).doubleValue();
        MutableComponent pokemonDisplayName = killedPokemon.getSpecies().getTranslatedName();
        int numberOfMovesToChooseFrom = inBattle ? SimpleTMs.INSTANCE.getConfig().getNumberOfMovesToChooseFromInBattle() : SimpleTMs.INSTANCE.getConfig().getNumberOfMovesToChooseFromOutsideBattle();
        double randomDouble = Math.random();
        boolean isTM = randomDouble < dropRateTR * dropRateTMtoTRRatio;
        boolean bl = isTR = randomDouble < dropRateTR;
        if (isTM || isTR) {
            boolean shouldUseMoveSelect;
            List<MoveTemplate> moveTemplatesToChooseFrom = null;
            moveTemplatesToChooseFrom = isTM ? this.getRandomApplicableMoveTemplates(killedPokemon, numberOfMovesToChooseFrom, false) : this.getRandomApplicableMoveTemplates(killedPokemon, numberOfMovesToChooseFrom, true);
            if (moveTemplatesToChooseFrom.isEmpty()) {
                Object[] objectArray = new Object[]{pokemonDisplayName};
                player.displayClientMessage((Component)MiscUtilsKt.fromLang("simpletms", "error.no_moves_to_drop", objectArray), true);
                return;
            }
            boolean bl2 = shouldUseMoveSelect = numberOfMovesToChooseFrom > 1;
            if (shouldUseMoveSelect) {
                Collection<MoveSelectDTO> collection;
                Move it;
                Collection collection2;
                Iterable $this$mapTo$iv$iv;
                Object[] objectArray = new Object[]{pokemonDisplayName};
                player.displayClientMessage((Component)MiscUtilsKt.fromLang("simpletms", "message.select_move_to_drop", objectArray), true);
                Iterable $this$map$iv = moveTemplatesToChooseFrom;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    MoveTemplate moveTemplate = (MoveTemplate)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    collection2.add(it.create());
                }
                List movesToChooseFrom = (List)destination$iv$iv;
                $this$map$iv = movesToChooseFrom;
                Component component = null;
                ServerPlayer serverPlayer = player;
                collection2 = MoveSelectCallbacks.INSTANCE;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void battleMove;
                    it = (Move)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(new MoveSelectDTO((Move)battleMove, false, 2, null));
                }
                collection = (List)destination$iv$iv;
                MoveSelectCallbacks.create$default((MoveSelectCallbacks)collection2, (ServerPlayer)serverPlayer, component, (List)collection, null, (arg_0, arg_1, arg_2) -> MoveLearnItemDropEventListeners.dropMoveLearnItemOnPlayer$lambda$3(player, movesToChooseFrom, isTR, isTM, arg_0, arg_1, arg_2), (int)10, null);
            } else {
                this.dropMoveLearnItemOnPlayerHandler(player, ((MoveTemplate)CollectionsKt.random((Collection)moveTemplatesToChooseFrom, (Random)((Random)Random.Default))).create(), isTR, isTM);
            }
        }
    }

    private final void dropMoveLearnItemOnPlayerHandler(ServerPlayer player, Move move, boolean isTR, boolean isTM) {
        boolean isTRItem = isTR && !isTM;
        Item droppedItem = SimpleTMsItems.INSTANCE.getTMorTRItemFromMove(move, isTRItem);
        ItemStack droppedItemStack = new ItemStack((ItemLike)droppedItem);
        PlayerExtensionsKt.giveOrDropItemStack((Player)((Player)player), (ItemStack)droppedItemStack, (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MoveTemplate> getRandomApplicableMoveTemplates(Pokemon pokemon, int numberOfMovesToChooseFrom, boolean isTR) {
        MoveTemplate it;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        List allMoves = Moves.INSTANCE.all();
        ElementalType pokemonPrimaryType = pokemon.getPrimaryType();
        ElementalType pokemonSecondaryType = pokemon.getSecondaryType();
        Learnset learnset = pokemon.getForm().getMoves();
        Set levelUpMoves = learnset.getLevelUpMovesUpTo(Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel());
        Set levelUpMovesUpToPokemonLevel = learnset.getLevelUpMovesUpTo(pokemon.getLevel());
        List tmMoves = learnset.getTmMoves();
        List tutorMoves = learnset.getTutorMoves();
        List eggMoves = learnset.getEggMoves();
        boolean DropAny = SimpleTMs.INSTANCE.getConfig().getDropAnyMove();
        boolean DropPrimaryType = SimpleTMs.INSTANCE.getConfig().getDropPrimaryType();
        boolean DropSecondaryType = SimpleTMs.INSTANCE.getConfig().getDropSecondaryType();
        boolean DropLevelList = SimpleTMs.INSTANCE.getConfig().getDropFromLevelList();
        boolean DropAnyLevel = SimpleTMs.INSTANCE.getConfig().getDropAnyLevelMoveFromLevelList();
        boolean DropTMs = SimpleTMs.INSTANCE.getConfig().getDropFromTmMoveList();
        boolean DropTutors = SimpleTMs.INSTANCE.getConfig().getDropFromTutorMoveList();
        boolean DropEggMoves = SimpleTMs.INSTANCE.getConfig().getDropFromEggMoveList();
        if (DropAny) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = allMoves;
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                MoveTemplate it2 = (MoveTemplate)element$iv$iv;
                boolean bl = false;
                if (!SimpleTMsItems.INSTANCE.hasItemForMove(it2, isTR)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List movesWithItems = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
            List<String> excludedMoves = SimpleTMsItems.INSTANCE.getALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS();
            movesWithItems.removeIf(arg_0 -> MoveLearnItemDropEventListeners.getRandomApplicableMoveTemplates$lambda$6(arg_0 -> MoveLearnItemDropEventListeners.getRandomApplicableMoveTemplates$lambda$5(excludedMoves, arg_0), arg_0));
            List applicableMoves = CollectionsKt.toList((Iterable)movesWithItems);
            return CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)applicableMoves), (int)numberOfMovesToChooseFrom);
        }
        List applicableMoves = new ArrayList();
        if (DropPrimaryType) {
            $this$filter$iv = Moves.INSTANCE.all();
            $i$f$filter = false;
            Iterable destination$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MoveTemplate)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementalType(), (Object)pokemonPrimaryType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List primaryTypeMoves = (List)destination$iv$iv;
            applicableMoves.addAll(primaryTypeMoves);
        }
        if (DropSecondaryType) {
            $this$filter$iv = Moves.INSTANCE.all();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MoveTemplate)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementalType(), (Object)pokemonSecondaryType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List secondaryTypeMoves = (List)destination$iv$iv;
            applicableMoves.addAll(secondaryTypeMoves);
        }
        if (DropAnyLevel) {
            applicableMoves.addAll(levelUpMoves);
        } else if (DropLevelList) {
            applicableMoves.addAll(levelUpMovesUpToPokemonLevel);
        }
        if (DropTMs) {
            applicableMoves.addAll(tmMoves);
        }
        if (DropTutors) {
            applicableMoves.addAll(tutorMoves);
        }
        if (DropEggMoves) {
            applicableMoves.addAll(eggMoves);
        }
        applicableMoves.removeIf(arg_0 -> MoveLearnItemDropEventListeners.getRandomApplicableMoveTemplates$lambda$10(arg_0 -> MoveLearnItemDropEventListeners.getRandomApplicableMoveTemplates$lambda$9(isTR, arg_0), arg_0));
        List<String> excludedMoves = SimpleTMsItems.INSTANCE.getALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS();
        applicableMoves.removeIf(arg_0 -> MoveLearnItemDropEventListeners.getRandomApplicableMoveTemplates$lambda$12(arg_0 -> MoveLearnItemDropEventListeners.getRandomApplicableMoveTemplates$lambda$11(excludedMoves, arg_0), arg_0));
        return CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)applicableMoves), (int)numberOfMovesToChooseFrom);
    }

    private static final EventResult registerListeners$lambda$0(LivingEntity entity, DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return INSTANCE.onEntityFainted(entity, source);
    }

    private static final Unit dropMoveLearnItemOnPlayer$lambda$3(ServerPlayer $player, List $movesToChooseFrom, boolean $isTR, boolean $isTM, ServerPlayer serverPlayer, int index, MoveSelectDTO moveSelectDTO) {
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)$movesToChooseFrom, (String)"$movesToChooseFrom");
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)moveSelectDTO, (String)"<unused var>");
        INSTANCE.dropMoveLearnItemOnPlayerHandler($player, (Move)$movesToChooseFrom.get(index), $isTR, $isTM);
        return Unit.INSTANCE;
    }

    private static final boolean getRandomApplicableMoveTemplates$lambda$5(List $excludedMoves, MoveTemplate move) {
        Intrinsics.checkNotNullParameter((Object)$excludedMoves, (String)"$excludedMoves");
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        return $excludedMoves.contains(move.getName());
    }

    private static final boolean getRandomApplicableMoveTemplates$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getRandomApplicableMoveTemplates$lambda$9(boolean $isTR, MoveTemplate move) {
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        return !SimpleTMsItems.INSTANCE.hasItemForMove(move, $isTR);
    }

    private static final boolean getRandomApplicableMoveTemplates$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getRandomApplicableMoveTemplates$lambda$11(List $excludedMoves, MoveTemplate move) {
        Intrinsics.checkNotNullParameter((Object)$excludedMoves, (String)"$excludedMoves");
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        return $excludedMoves.contains(move.getName());
    }

    private static final boolean getRandomApplicableMoveTemplates$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

