/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms.item.custom;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import dragomordor.simpletms.SimpleTMs;
import dragomordor.simpletms.SimpleTMsItems;
import dragomordor.simpletms.item.SimpleTMsItem;
import dragomordor.simpletms.item.api.PokemonAndMoveSelectingItemNonBattle;
import dragomordor.simpletms.util.MiscUtilsKt;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u00011B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b#\u0010$J5\u0010-\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00132\u0006\u0010'\u001a\u00020&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b-\u0010.R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010/\u001a\u0004\b\u0004\u00100\u00a8\u00062"}, d2={"Ldragomordor/simpletms/item/custom/BlankTmItem;", "Ldragomordor/simpletms/item/SimpleTMsItem;", "Ldragomordor/simpletms/item/api/PokemonAndMoveSelectingItemNonBattle;", "", "isTR", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(ZLnet/minecraft/world/item/Item$Properties;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "canUseOnPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lcom/cobblemon/mod/common/api/moves/Move;", "move", "canUseOnMove", "(Lcom/cobblemon/mod/common/api/moves/Move;)Z", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "applyToPokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/api/moves/Move;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "canUseBlankOnMove", "(ZLcom/cobblemon/mod/common/api/moves/Move;)Z", "canUseBlank", "(Z)Z", "itemStack", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipContext", "", "Lnet/minecraft/network/chat/Component;", "list", "Lnet/minecraft/world/item/TooltipFlag;", "tooltipFlag", "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Z", "()Z", "FailureMessage", "common"})
@SourceDebugExtension(value={"SMAP\nBlankTmItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlankTmItem.kt\ndragomordor/simpletms/item/custom/BlankTmItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1755#2,3:177\n*S KotlinDebug\n*F\n+ 1 BlankTmItem.kt\ndragomordor/simpletms/item/custom/BlankTmItem\n*L\n40#1:177,3\n*E\n"})
public final class BlankTmItem
extends SimpleTMsItem
implements PokemonAndMoveSelectingItemNonBattle {
    private final boolean isTR;

    public BlankTmItem(boolean isTR, @NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.isTR = isTR;
    }

    public final boolean isTR() {
        return this.isTR;
    }

    @Override
    public boolean canUseOnPokemon(@NotNull Pokemon pokemon) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            Iterable $this$any$iv = (Iterable)pokemon.getMoveSet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Move p0 = (Move)element$iv;
                    boolean bl2 = false;
                    if (!this.canUseOnMove(p0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean canUseOnMove(@NotNull Move move) {
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        return this.canUseBlankOnMove(this.isTR, move);
    }

    @Override
    public void applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Pokemon pokemon, @NotNull Move move) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        boolean isTR = this.isTR;
        if (!this.canUseBlank(isTR)) {
            player.displayClientMessage(FailureMessage.Companion.getFailureMessage(), true);
            return;
        }
        int cooldownTicks = SimpleTMs.INSTANCE.getConfig().getBlankTMCooldownTicks();
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            int cooldownHH = Math.floorDiv(cooldownTicks, 72000);
            int cooldownMM = Math.floorDiv(cooldownTicks - cooldownHH * 72000, 1200);
            int cooldownSS = Math.floorDiv(cooldownTicks - cooldownHH * 72000 - cooldownMM * 1200, 20);
            String cooldownString = cooldownHH + ":" + cooldownMM + ":" + cooldownSS;
            Object[] objectArray = new Object[]{stack.getDisplayName(), cooldownString};
            MutableComponent mutableComponent = MiscUtilsKt.fromLang("simpletms", "error.not_learnable.on_cooldown", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"fromLang(...)");
            dragomordor.simpletms.util.FailureMessage.Companion.setFailureMessage((Component)mutableComponent);
            player.displayClientMessage(dragomordor.simpletms.util.FailureMessage.Companion.getFailureMessage(), true);
            return;
        }
        Item newMoveLearnItem = SimpleTMsItems.INSTANCE.getTMorTRItemFromMove(move, isTR);
        PlayerExtensionsKt.giveOrDropItemStack$default((Player)((Player)player), (ItemStack)new ItemStack((ItemLike)newMoveLearnItem), (boolean)false, (int)2, null);
        player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        if (!player.isCreative() && !isTR && stack.getCount() > 0 && cooldownTicks > 0) {
            player.getCooldowns().addCooldown((Item)this, cooldownTicks);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (world instanceof ServerLevel && user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            ItemStack itemStack = user.getItemInHand(hand);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            InteractionResultHolder interactionResultHolder = this.use(serverPlayer, itemStack);
            if (interactionResultHolder == null) {
                InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.pass((Object)user.getItemInHand(hand));
                interactionResultHolder = interactionResultHolder2;
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder2, (String)"pass(...)");
            }
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = super.use(world, user, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    private final boolean canUseBlankOnMove(boolean isTR, Move move) {
        boolean canUseBlank = this.canUseBlank(isTR);
        if (!canUseBlank) {
            return false;
        }
        if (!SimpleTMsItems.INSTANCE.hasItemForMove(move.getTemplate(), isTR)) {
            return false;
        }
        List<String> excludedMoves = SimpleTMsItems.INSTANCE.getALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING();
        return !excludedMoves.contains(move.getTemplate().getName());
    }

    private final boolean canUseBlank(boolean isTR) {
        if (!SimpleTMs.INSTANCE.getConfig().getBlankTRsUsable() && isTR) {
            MutableComponent mutableComponent = MiscUtilsKt.fromLang("simpletms", "error.not_usable.blank_trs_disabled", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"fromLang(...)");
            FailureMessage.Companion.setFailureMessage((Component)mutableComponent);
            return false;
        }
        if (!SimpleTMs.INSTANCE.getConfig().getBlankTMsUsable() && !isTR) {
            MutableComponent mutableComponent = MiscUtilsKt.fromLang("simpletms", "error.not_usable.blank_tms_disabled", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"fromLang(...)");
            FailureMessage.Companion.setFailureMessage((Component)mutableComponent);
            return false;
        }
        return true;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)tooltipContext, (String)"tooltipContext");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        Color baseGreyColor = Color.LIGHT_GRAY;
        boolean isTR = this.isTR;
        String itemType = isTR ? "TR" : "TM";
        Object[] objectArray = new Object[]{TextKt.text((String)itemType)};
        MutableComponent blankItemDescription = MiscUtilsKt.fromLang("simpletms", "item.tooltip.blank_item.description", objectArray).withColor(baseGreyColor.getRGB());
        Intrinsics.checkNotNull((Object)blankItemDescription);
        list.add((Component)blankItemDescription);
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
    }

    @Override
    @Nullable
    public InteractionResultHolder<ItemStack> use(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        return PokemonAndMoveSelectingItemNonBattle.DefaultImpls.use(this, player, stack);
    }

    @Override
    public boolean canUseOnMove(@NotNull Pokemon pokemon, @NotNull Move move) {
        return PokemonAndMoveSelectingItemNonBattle.DefaultImpls.canUseOnMove(this, pokemon, move);
    }

    @Override
    @Nullable
    public InteractionResultHolder<ItemStack> interactGeneral(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        return PokemonAndMoveSelectingItemNonBattle.DefaultImpls.interactGeneral(this, player, stack);
    }

    @Override
    @Nullable
    public InteractionResultHolder<ItemStack> interactWithSpecific(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        return PokemonAndMoveSelectingItemNonBattle.DefaultImpls.interactWithSpecific(this, player, stack, pokemon);
    }

    @Override
    @NotNull
    public List<Move> moveSetAndBenchedMoveList(@NotNull Pokemon pokemon) {
        return PokemonAndMoveSelectingItemNonBattle.DefaultImpls.moveSetAndBenchedMoveList(this, pokemon);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Ldragomordor/simpletms/item/custom/BlankTmItem$FailureMessage;", "", "<init>", "()V", "Companion", "common"})
    public static final class FailureMessage {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static Component message;

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u000b\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Ldragomordor/simpletms/item/custom/BlankTmItem$FailureMessage$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/chat/Component;", "getFailureMessage", "()Lnet/minecraft/network/chat/Component;", "message", "", "setFailureMessage", "(Lnet/minecraft/network/chat/Component;)V", "Lnet/minecraft/network/chat/Component;", "getMessage", "setMessage", "common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Component getMessage() {
                Component component = message;
                if (component != null) {
                    return component;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"message");
                return null;
            }

            public final void setMessage(@NotNull Component component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"<set-?>");
                message = component;
            }

            @NotNull
            public final Component getFailureMessage() {
                return this.getMessage();
            }

            public final void setFailureMessage(@NotNull Component message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.setMessage(message);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

